/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.util;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.site.decoration.Skin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public final class ReportUtils {
    private ReportUtils() {
    }

    public static File getSkinArtifactFile(MavenProject project, ArtifactRepository localRepository, ArtifactResolver resolver, ArtifactFactory factory) throws MojoExecutionException {
        Skin skin = Skin.getDefaultSkin();
        String version = ReportUtils.determineVersion(skin);
        try {
            VersionRange versionSpec = VersionRange.createFromVersionSpec((String)version);
            Artifact artifact = factory.createDependencyArtifact(skin.getGroupId(), skin.getArtifactId(), versionSpec, "jar", null, null);
            resolver.resolve(artifact, project.getRemoteArtifactRepositories(), localRepository);
            return artifact.getFile();
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("The skin version '" + version + "' is not valid: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to find skin", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("The skin does not exist: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private static String determineVersion(Skin skin) {
        String version = skin.getVersion();
        if (version == null) {
            version = "RELEASE";
        }
        return version;
    }
}

