/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.common;

import com.redhat.rcm.maven.plugin.buildmetadata.common.Property;
import com.redhat.rcm.maven.plugin.buildmetadata.common.SortedProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.codehaus.plexus.util.StringUtils;

public final class Constant {
    public static final String SECTION_BUILD_SCM = "build.scm";
    public static final String SECTION_ARTIFACT = "build.artifact";
    public static final String SECTION_BUILD_DATE = "build.timeAndDate";
    public static final String SECTION_BUILD_RUNTIME = "build.runtime";
    public static final String SECTION_BUILD_JAVA = "build.java";
    public static final String SECTION_BUILD_MAVEN = "build.maven";
    public static final String SECTION_BUILD_MISC = "build.misc";
    public static final String SECTION_PROJECT = "project";
    public static final String PROP_NAME_SCM_URL = "build.scmRevision.url";
    public static final String PROP_NAME_SCM_REVISION_ID = "build.scmRevision.id";
    public static final String PROP_NAME_SCM_REVISION_DATE = "build.scmRevision.date";
    public static final String PROP_NAME_SCM_LOCALLY_MODIFIED = "build.scmLocallyModified";
    public static final String PROP_NAME_SCM_LOCALLY_MODIFIED_FILES = "build.scmLocallyModified.files";
    public static final String PROP_NAME_BUILD_DATE = "build.date";
    public static final String PROP_NAME_BUILD_TIMESTAMP = "build.timestamp.millis";
    public static final String PROP_NAME_BUILD_DATE_PATTERN = "build.date.pattern";
    public static final String PROP_NAME_GROUP_ID = "build.groupId";
    public static final String PROP_NAME_ARTIFACT_ID = "build.artifactId";
    public static final String PROP_NAME_VERSION = "build.version";
    public static final String PROP_NAME_FULL_VERSION = "build.version.full";
    public static final String PROP_NAME_BUILD_YEAR = "build.year";
    public static final String PROP_NAME_BUILD_DURATION = "build.duration";
    public static final String PROP_NAME_COPYRIGHT_YEAR = "build.copyright.year";
    public static final String DEFAULT_DATE_PATTERN = "dd.MM.yyyy";
    public static final String PROP_NAME_BUILD_USER = "build.user";
    public static final String PROP_NAME_HOSTNAME = "build.host.name";
    public static final String PROP_NAME_OS_NAME = "build.os.name";
    public static final String PROP_NAME_OS_ARCH = "build.os.arch";
    public static final String PROP_NAME_OS_VERSION = "build.os.version";
    public static final String PROP_NAME_JAVA_RUNTIME_NAME = "build.java.runtime.name";
    public static final String PROP_NAME_JAVA_RUNTIME_VERSION = "build.java.runtime.version";
    public static final String PROP_NAME_JAVA_VENDOR = "build.java.vendor";
    public static final String PROP_NAME_JAVA_VM = "build.java.vm";
    public static final String PROP_NAME_JAVA_COMPILER = "build.java.compiler";
    public static final String PROP_NAME_MAVEN_VERSION = "build.maven.version";
    public static final String PROP_NAME_MAVEN_GOALS = "build.maven.execution.goals";
    public static final String PROP_NAME_MAVEN_CMDLINE = "build.maven.execution.cmdline";
    public static final String PROP_NAME_MAVEN_OPTS = "build.maven.execution.opts";
    public static final String PROP_NAME_JAVA_OPTS = "build.maven.execution.java.opts";
    public static final String PROP_NAME_MAVEN_IS_EXECUTION_ROOT = "build.maven.execution.isRoot";
    public static final String PROP_NAME_MAVEN_EXECUTION_PROJECT = "build.maven.execution.project";
    public static final String PROP_NAME_MAVEN_FILTERS = "build.maven.execution.filters";
    public static final String MAVEN_EXECUTION_PROPERTIES_PREFIX = "execution.property";
    public static final String PROP_NAME_MAVEN_ACTIVE_PROFILES = "build.maven.execution.profiles.active";
    public static final String MAVEN_ACTIVE_PROFILE_PREFIX = "build.maven.execution.profile.active";
    public static final String PROP_NAME_PROJECT_HOMEPAGE = "project.page.home.url";
    public static final String PROP_NAME_PROJECT_OPS = "project.page.ops.url";
    public static final String PROP_NAME_PROJECT_CATEGORY = "project.category";
    public static final String PROP_NAME_PROJECT_SUBCATEGORY = "project.subcategory";
    public static final String PROP_NAME_PROJECT_TAGS = "project.tags";
    public static final List<Section> REPORT_PROPERTIES;
    public static final Set<String> STANDARD_PROPERTIES;

    private Constant() {
    }

    public static boolean isIntendedForMiscSection(String name) {
        return !name.startsWith(MAVEN_ACTIVE_PROFILE_PREFIX);
    }

    public static Properties calcNonStandardProperties(Properties buildMetaDataProperties, List<Property> userProperties) {
        SortedProperties nonStandardProperties = new SortedProperties();
        Set<String> selectedProperties = Constant.createSelectedPropertiesExcludeMiscSection(userProperties);
        for (Map.Entry<Object, Object> entry : buildMetaDataProperties.entrySet()) {
            String key = String.valueOf(entry.getKey());
            if (STANDARD_PROPERTIES.contains(key) || selectedProperties.contains(key)) continue;
            nonStandardProperties.put(key, entry.getValue());
        }
        return nonStandardProperties;
    }

    private static Set<String> createSelectedPropertiesExcludeMiscSection(List<Property> userProperties) {
        HashSet<String> selectedProperties = new HashSet<String>();
        if (userProperties != null) {
            for (Property property : userProperties) {
                if (!Constant.isNotTargetedForMiscSection(property.getSection())) continue;
                selectedProperties.add(property.getName());
            }
        }
        return selectedProperties;
    }

    private static boolean isNotTargetedForMiscSection(String section) {
        return SECTION_BUILD_SCM.equals(section) || SECTION_BUILD_DATE.equals(section) || SECTION_BUILD_RUNTIME.equals(section) || SECTION_BUILD_JAVA.equals(section) || SECTION_BUILD_MAVEN.equals(section);
    }

    public static String prettify(String string) {
        String trimmed = string.trim();
        int end = trimmed.length() - 1;
        if (trimmed.charAt(0) == '[' && trimmed.charAt(end) == ']') {
            return trimmed.substring(1, end);
        }
        return trimmed;
    }

    public static String prettifyFilesValue(Object value) {
        if (value == null) {
            return null;
        }
        String string = String.valueOf(value);
        if (StringUtils.isNotBlank((String)string)) {
            string = string.replace(']', ' ');
            if ((string = string.replace('[', ',')).indexOf(0) == 44) {
                return string.substring(1);
            }
        }
        return string;
    }

    static {
        ArrayList<Section> sections = new ArrayList<Section>();
        Section scm = new Section(SECTION_BUILD_SCM, new String[]{PROP_NAME_SCM_REVISION_ID, PROP_NAME_SCM_REVISION_DATE, PROP_NAME_SCM_URL, PROP_NAME_SCM_LOCALLY_MODIFIED_FILES});
        sections.add(scm);
        Section artifact = new Section(SECTION_ARTIFACT, new String[]{PROP_NAME_GROUP_ID, PROP_NAME_ARTIFACT_ID, PROP_NAME_VERSION, PROP_NAME_FULL_VERSION});
        sections.add(artifact);
        Section dateAndVersion = new Section(SECTION_BUILD_DATE, new String[]{PROP_NAME_BUILD_DATE, PROP_NAME_BUILD_TIMESTAMP, PROP_NAME_BUILD_YEAR, PROP_NAME_COPYRIGHT_YEAR, DEFAULT_DATE_PATTERN});
        sections.add(dateAndVersion);
        Section buildRuntime = new Section(SECTION_BUILD_RUNTIME, new String[]{PROP_NAME_HOSTNAME, PROP_NAME_OS_NAME, PROP_NAME_OS_ARCH, PROP_NAME_OS_VERSION, PROP_NAME_BUILD_USER});
        sections.add(buildRuntime);
        Section buildJava = new Section(SECTION_BUILD_JAVA, new String[]{PROP_NAME_JAVA_VENDOR, PROP_NAME_JAVA_RUNTIME_NAME, PROP_NAME_JAVA_RUNTIME_VERSION, PROP_NAME_JAVA_VM, PROP_NAME_JAVA_COMPILER, PROP_NAME_JAVA_OPTS});
        sections.add(buildJava);
        Section buildMaven = new Section(SECTION_BUILD_MAVEN, new String[]{PROP_NAME_MAVEN_VERSION, PROP_NAME_MAVEN_CMDLINE, PROP_NAME_MAVEN_GOALS, PROP_NAME_MAVEN_OPTS, PROP_NAME_MAVEN_EXECUTION_PROJECT, PROP_NAME_MAVEN_IS_EXECUTION_ROOT, PROP_NAME_MAVEN_FILTERS, PROP_NAME_MAVEN_ACTIVE_PROFILES});
        sections.add(buildMaven);
        Section project = new Section(SECTION_PROJECT, new String[]{PROP_NAME_PROJECT_HOMEPAGE, PROP_NAME_PROJECT_OPS, PROP_NAME_PROJECT_CATEGORY, PROP_NAME_PROJECT_SUBCATEGORY, PROP_NAME_PROJECT_TAGS});
        sections.add(project);
        HashSet<String> properties = new HashSet<String>(Arrays.asList(PROP_NAME_SCM_REVISION_ID, PROP_NAME_SCM_REVISION_DATE, PROP_NAME_SCM_URL, PROP_NAME_SCM_LOCALLY_MODIFIED_FILES, PROP_NAME_BUILD_DATE, PROP_NAME_BUILD_TIMESTAMP, PROP_NAME_BUILD_YEAR, PROP_NAME_COPYRIGHT_YEAR, DEFAULT_DATE_PATTERN, PROP_NAME_GROUP_ID, PROP_NAME_ARTIFACT_ID, PROP_NAME_VERSION, PROP_NAME_FULL_VERSION, PROP_NAME_HOSTNAME, PROP_NAME_OS_NAME, PROP_NAME_OS_ARCH, PROP_NAME_OS_VERSION, PROP_NAME_BUILD_USER, PROP_NAME_JAVA_VENDOR, PROP_NAME_JAVA_RUNTIME_NAME, PROP_NAME_JAVA_RUNTIME_VERSION, PROP_NAME_JAVA_VM, PROP_NAME_JAVA_COMPILER, PROP_NAME_JAVA_OPTS, PROP_NAME_MAVEN_VERSION, PROP_NAME_MAVEN_CMDLINE, PROP_NAME_MAVEN_GOALS, PROP_NAME_MAVEN_OPTS, PROP_NAME_MAVEN_EXECUTION_PROJECT, PROP_NAME_MAVEN_IS_EXECUTION_ROOT, PROP_NAME_MAVEN_FILTERS, PROP_NAME_MAVEN_ACTIVE_PROFILES, PROP_NAME_PROJECT_HOMEPAGE, PROP_NAME_PROJECT_OPS));
        STANDARD_PROPERTIES = Collections.unmodifiableSet(properties);
        REPORT_PROPERTIES = Collections.unmodifiableList(sections);
    }

    public static final class Section {
        private final String titleKey;
        private final List<String> properties;

        private Section(String titleKey, String ... properties) {
            this.titleKey = titleKey;
            this.properties = Arrays.asList(properties);
        }

        public String getTitleKey() {
            return this.titleKey;
        }

        public List<String> getProperties() {
            return this.properties;
        }
    }
}

