/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.common;

import com.redhat.rcm.maven.plugin.buildmetadata.AbstractBuildMojo;
import com.redhat.rcm.maven.plugin.buildmetadata.common.ScmControl;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.LocallyModifiedInfo;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.Revision;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.RevisionNumberFetcher;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.ScmException;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.ScmNoRevisionException;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.maven.MavenScmRevisionNumberFetcher;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.maven.ScmAccessInfo;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.maven.ScmConnectionInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.manager.ScmManager;

public final class RevisionHelper
extends AbstractBuildMojo {
    private final ScmManager scmManager;
    private final ScmConnectionInfo scmConnectionInfo;
    private final ScmAccessInfo scmAccessInfo;
    private final String buildDatePattern;

    public RevisionHelper(ScmManager scmManager, ScmConnectionInfo scmConnectionInfo, ScmAccessInfo scmAccessInfo, String buildDatePattern) {
        this.scmManager = scmManager;
        this.scmConnectionInfo = scmConnectionInfo;
        this.scmAccessInfo = scmAccessInfo;
        this.buildDatePattern = buildDatePattern;
    }

    public void provideScmBuildInfo(Properties buildMetaDataProperties, ScmControl scmControl) throws ScmException {
        boolean failOnMissingRevision = scmControl.isFailOnMissingRevision();
        MavenScmRevisionNumberFetcher revisionFetcher = new MavenScmRevisionNumberFetcher(this.scmManager, this.scmConnectionInfo, this.scmAccessInfo);
        Revision revision = revisionFetcher.fetchLatestRevisionNumber();
        if (revision != null) {
            buildMetaDataProperties.setProperty("build.scmRevision.url", this.scmConnectionInfo.getConnectionUrl());
            String revisionId = revision.getId();
            buildMetaDataProperties.setProperty("build.scmRevision.id", revisionId);
            Date revisionDate = revision.getDate();
            SimpleDateFormat format = new SimpleDateFormat(this.buildDatePattern, Locale.ENGLISH);
            String revisionDateString = format.format(revisionDate);
            buildMetaDataProperties.setProperty("build.scmRevision.date", revisionDateString);
            boolean validateCheckout = scmControl.isValidateCheckout();
            if (validateCheckout) {
                this.provideLocallyModifiedInfo(buildMetaDataProperties, revisionFetcher);
            }
        } else if (failOnMissingRevision) {
            throw new ScmNoRevisionException("Cannot fetch SCM revision. " + this.scmConnectionInfo);
        }
    }

    private void provideLocallyModifiedInfo(Properties buildMetaDataProperties, RevisionNumberFetcher revisionFetcher) throws ScmException {
        block5: {
            try {
                ScmFileSet fileSet = new ScmFileSet(this.scmAccessInfo.getRootDirectory(), "**/*", null);
                LocallyModifiedInfo info = revisionFetcher.containsModifications(fileSet);
                buildMetaDataProperties.setProperty("build.scmLocallyModified", String.valueOf(info.isLocallyModified()));
                if (info.isLocallyModified()) {
                    buildMetaDataProperties.setProperty("build.scmLocallyModified.files", info.getFiles());
                    if (this.scmAccessInfo.isFailIndicated()) {
                        throw new ScmException("Local Modifications detected (" + info.getFiles() + ").");
                    }
                }
            }
            catch (Exception e) {
                if (this.scmAccessInfo.isFailIndicated()) {
                    throw new ScmException(e);
                }
                buildMetaDataProperties.setProperty("build.scmLocallyModified", "unknown");
                if (!this.getLog().isInfoEnabled()) break block5;
                this.getLog().info((CharSequence)"Failed to check modification status.");
            }
        }
    }
}

