/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.data;

import com.redhat.rcm.maven.plugin.buildmetadata.common.ScmInfo;
import com.redhat.rcm.maven.plugin.buildmetadata.data.MetaDataProvider;
import com.redhat.rcm.maven.plugin.buildmetadata.data.Provider;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public final class MetaDataProviderBuilder {
    private final MavenProject project;
    private final MavenSession session;
    private final RuntimeInformation runtime;
    private final ScmInfo scmInfo;

    public MetaDataProviderBuilder(MavenProject project, MavenSession session, RuntimeInformation runtime, ScmInfo scmInfo) {
        this.project = project;
        this.session = session;
        this.runtime = runtime;
        this.scmInfo = scmInfo;
    }

    public MetaDataProvider build(Provider config) throws MojoExecutionException {
        MetaDataProvider instance = this.create(config.getType());
        this.initialize(instance, config.getProperties());
        return instance;
    }

    private MetaDataProvider create(String metaDataProviderClassName) throws MojoExecutionException {
        try {
            Class<?> metaDataProviderClass = Class.forName(metaDataProviderClassName);
            MetaDataProvider instance = (MetaDataProvider)metaDataProviderClass.newInstance();
            return instance;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot create instance for meta data provider class '" + metaDataProviderClassName + "'.", e);
        }
    }

    private void initialize(MetaDataProvider instance, Map<String, String> properties) throws MojoExecutionException {
        this.setNonNullProperty(instance, "project", this.project, MavenProject.class);
        this.setNonNullProperty(instance, "session", this.session, MavenSession.class);
        this.setNonNullProperty(instance, "runtime", this.runtime, RuntimeInformation.class);
        this.setNonNullProperty(instance, "scmInfo", this.scmInfo, ScmInfo.class);
        this.setProperties(instance, properties);
    }

    private void setNonNullProperty(MetaDataProvider instance, String propertyName, Object propertyValue, Class<?> propertyType) throws MojoExecutionException {
        if (propertyValue != null) {
            Class<?> metaDataProviderClass = instance.getClass();
            try {
                Field field = this.findField(metaDataProviderClass, propertyName);
                Class<?> type = field.getType();
                if (type.isAssignableFrom(propertyType)) {
                    field.setAccessible(true);
                    field.set(instance, propertyValue);
                }
            }
            catch (NoSuchFieldException e) {
            }
            catch (Exception e) {
                throw new MojoExecutionException("Cannot set property '" + propertyName + "' for the instance of class '" + metaDataProviderClass.getName() + "'.", e);
            }
        }
    }

    private Field findField(Class<?> type, String propertyName) throws NoSuchFieldException {
        try {
            return type.getDeclaredField(propertyName);
        }
        catch (NoSuchFieldException e) {
            if (type.getSuperclass().equals(Object.class)) {
                throw e;
            }
            return this.findField(type.getSuperclass(), propertyName);
        }
    }

    private void setProperties(MetaDataProvider instance, Map<String, String> properties) throws MojoExecutionException {
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String propertyName = entry.getKey();
                if ("runAtBuildPoint".equals(propertyName)) continue;
                String propertyValue = entry.getValue();
                this.setProperty(instance, propertyName, propertyValue);
            }
        }
    }

    private void setProperty(MetaDataProvider instance, String propertyName, String propertyValue) throws MojoExecutionException {
        Class<?> metaDataProviderClass = instance.getClass();
        try {
            Field field = this.findField(metaDataProviderClass, propertyName);
            field.setAccessible(true);
            Class<?> type = field.getType();
            Object typedPropertyValue = ConvertUtils.convert((String)propertyValue, type);
            field.set(instance, typedPropertyValue);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot set property '" + propertyName + "' to value '" + propertyValue + "' for the instance of class '" + metaDataProviderClass.getName() + "'.", e);
        }
    }
}

