/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.io;

import com.redhat.rcm.maven.plugin.buildmetadata.common.MojoUtils;
import com.redhat.rcm.maven.plugin.buildmetadata.common.Property;
import com.redhat.rcm.maven.plugin.buildmetadata.io.SdocBuilder;
import com.redhat.rcm.maven.plugin.buildmetadata.util.FilePathNormalizer;
import com.redhat.rcm.maven.plugin.buildmetadata.util.MojoIoUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.IOUtil;
import org.w3c.dom.Document;

public final class BuildXmlFileHelper {
    private final String projectRootPath;
    private final Log log;
    private final File xmlOutputFile;
    private final List<Property> selectedProperties;

    public BuildXmlFileHelper(String projectRootPath, Log log, File xmlOutputFile, List<Property> selectedProperties) {
        this.projectRootPath = projectRootPath;
        this.log = log;
        this.xmlOutputFile = xmlOutputFile;
        this.selectedProperties = selectedProperties;
    }

    public File writeXmlFile(Properties buildMetaDataProperties) throws MojoExecutionException {
        File buildMetaDataFile = this.createBuildMetaDataFile(this.xmlOutputFile);
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)("Writing XML report '" + buildMetaDataFile.getAbsolutePath() + "'..."));
        }
        this.writeContent(buildMetaDataProperties, buildMetaDataFile);
        return buildMetaDataFile;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeContent(Properties buildMetaDataProperties, File buildMetaDataFile) throws MojoExecutionException {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(buildMetaDataFile));
            this.serializeDocument(buildMetaDataProperties, out);
        }
        catch (FileNotFoundException e) {
            try {
                String message = "Cannot find file '" + buildMetaDataFile + "' to write XML report to.";
                throw MojoUtils.createException(this.log, e, message);
                catch (IOException e2) {
                    message = "Cannot write XML report to file '" + buildMetaDataFile + "'.";
                    throw MojoUtils.createException(this.log, e2, message);
                }
                catch (ParserConfigurationException e3) {
                    message = "Cannot create XML report to write to file '" + buildMetaDataFile + "'.";
                    throw MojoUtils.createException(this.log, e3, message);
                }
                catch (TransformerException e4) {
                    message = "Cannot transform build meta data to XML to write to file '" + buildMetaDataFile + "'.";
                    throw MojoUtils.createException(this.log, e4, message);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)out);
    }

    private void serializeDocument(Properties buildMetaDataProperties, OutputStream out) throws ParserConfigurationException, IOException, TransformerException {
        Document document = this.createDocument();
        SdocBuilder builder = new SdocBuilder(new FilePathNormalizer(this.projectRootPath), document, buildMetaDataProperties, this.selectedProperties);
        builder.writeDocumentContent();
        MojoIoUtils.serialize(document, out);
    }

    private File createBuildMetaDataFile(File propertiesOutputFile) throws MojoExecutionException {
        boolean created;
        File outputDirectory = propertiesOutputFile.getParentFile();
        if (!outputDirectory.exists() && !(created = outputDirectory.mkdirs())) {
            throw new MojoExecutionException("Cannot create output directory '" + outputDirectory + "'.");
        }
        return propertiesOutputFile;
    }

    private Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        return document;
    }
}

