/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.scm.maven;

import com.redhat.rcm.maven.plugin.buildmetadata.AbstractBuildMojo;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.LocallyModifiedInfo;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.Revision;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.RevisionNumberFetcher;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.ScmException;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.maven.ScmAccessInfo;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.maven.ScmConnectionInfo;
import com.redhat.rcm.maven.plugin.buildmetadata.scm.maven.StringRevision;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.StringUtils;

public final class MavenScmRevisionNumberFetcher
extends AbstractBuildMojo
implements RevisionNumberFetcher {
    private final ScmManager scmManager;
    private final ScmConnectionInfo scmConnectionInfo;
    private final ScmAccessInfo scmAccessInfo;

    public MavenScmRevisionNumberFetcher(ScmManager scmManager, ScmConnectionInfo scmConnectionInfo, ScmAccessInfo scmAccessInfo) {
        this.scmManager = scmManager;
        this.scmConnectionInfo = scmConnectionInfo;
        this.scmAccessInfo = scmAccessInfo;
    }

    @Override
    public Revision fetchLatestRevisionNumber() throws ScmException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("  Fetching latest revision number.\n    " + this.scmConnectionInfo + "\n    " + this.scmAccessInfo));
        }
        ScmRepository repository = this.scmConnectionInfo.createRepository(this.scmManager);
        ScmProvider provider = this.createScmProvider(repository);
        ChangeLogScmResult result = this.scmAccessInfo.fetchChangeLog(repository, provider);
        StringRevision revision = null;
        if (result != null && result.isSuccess()) {
            List changeLogSets = result.getChangeLog().getChangeSets();
            if (changeLogSets.size() > 0) {
                revision = new StringRevision(((ChangeSet)changeLogSets.get(0)).getRevision(), ((ChangeSet)changeLogSets.get(0)).getDate());
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Found revision '" + revision + "'."));
                }
            }
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"No revision information found.");
        }
        return revision;
    }

    @Override
    public LocallyModifiedInfo containsModifications(ScmFileSet fileSet) throws ScmException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("  Fetching modification information.\n    " + this.scmConnectionInfo + "\n    " + this.scmAccessInfo));
        }
        try {
            ScmRepository repository = this.scmConnectionInfo.createRepository(this.scmManager);
            ScmProvider provider = this.createScmProvider(repository);
            ScmResultWrapper result = this.execute(fileSet, repository, provider);
            if (result.isSuccess()) {
                return this.createLocallyModifiedInfo(result);
            }
            String message = result.toString();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)message);
            }
            throw new ScmException(message);
        }
        catch (org.apache.maven.scm.ScmException e) {
            throw new ScmException(e);
        }
    }

    private ScmResultWrapper execute(ScmFileSet fileSet, ScmRepository repository, ScmProvider provider) throws org.apache.maven.scm.ScmException {
        ScmResultWrapper result;
        ScmVersion remoteVersion = this.scmConnectionInfo.getRemoteVersion();
        if (remoteVersion != null) {
            ScmVersion localVersion = null;
            result = this.createScmDiffResultWrapper(provider.diff(repository, fileSet, remoteVersion, localVersion));
        } else {
            result = this.createScmStatusResultWrapper(provider.status(repository, fileSet));
        }
        return result;
    }

    private ScmResultWrapper createScmDiffResultWrapper(final DiffScmResult diff) {
        return new AbstractScmResultWrapper((ScmResult)diff){

            @Override
            public List<ScmFile> getChangedFiles() {
                return diff.getChangedFiles();
            }
        };
    }

    private ScmResultWrapper createScmStatusResultWrapper(final StatusScmResult diff) {
        return new AbstractScmResultWrapper((ScmResult)diff){

            @Override
            public List<ScmFile> getChangedFiles() {
                return diff.getChangedFiles();
            }
        };
    }

    private LocallyModifiedInfo createLocallyModifiedInfo(ScmResultWrapper result) {
        boolean locallyModified;
        List<ScmFile> changedFiles = this.filter(result.getChangedFiles());
        boolean bl = locallyModified = !changedFiles.isEmpty();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("  Modifications have" + (locallyModified ? "" : " not") + " been found."));
        }
        return new LocallyModifiedInfo(locallyModified, locallyModified ? this.toString(MavenScmRevisionNumberFetcher.createSortedFiles(changedFiles)) : null);
    }

    private static Set<ScmFile> createSortedFiles(List<ScmFile> changedFiles) {
        TreeSet<ScmFile> set = new TreeSet<ScmFile>(new Comparator<ScmFile>(){

            @Override
            public int compare(ScmFile o1, ScmFile o2) {
                return o2.compareTo(o1);
            }
        });
        set.addAll(changedFiles);
        return set;
    }

    private List<ScmFile> filter(List<ScmFile> files) {
        if (this.scmAccessInfo.isIgnoreDotFilesInBaseDir()) {
            this.filterDotFiles(files);
        }
        return files;
    }

    private void filterDotFiles(List<ScmFile> files) {
        Iterator<ScmFile> i = files.iterator();
        while (i.hasNext()) {
            ScmFile file = i.next();
            String path = file.getPath();
            if (path.length() <= 0 || path.charAt(0) != '.') continue;
            i.remove();
        }
    }

    private String toString(Collection<?> items) {
        StringBuilder buffer = new StringBuilder(512);
        for (Object item : items) {
            buffer.append(item).append(' ');
        }
        return StringUtils.chomp((String)buffer.toString());
    }

    private ScmProvider createScmProvider(ScmRepository repository) throws ScmException {
        try {
            ScmProvider provider = this.scmManager.getProviderByRepository(repository);
            return provider;
        }
        catch (NoSuchScmProviderException e) {
            throw new ScmException("Cannot create SCM provider.", e);
        }
    }

    private static abstract class AbstractScmResultWrapper
    implements ScmResultWrapper {
        private final ScmResult result;

        protected AbstractScmResultWrapper(ScmResult result) {
            this.result = result;
        }

        @Override
        public boolean isSuccess() {
            return this.result.isSuccess();
        }

        public String toString() {
            return this.result.getProviderMessage() + ": " + this.result.getCommandOutput();
        }
    }

    private static interface ScmResultWrapper {
        public boolean isSuccess();

        public List<ScmFile> getChangedFiles();
    }
}

