/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.ObjectUtils;
import org.codehaus.plexus.util.StringUtils;

public class ManifestHelper {
    private static final int MANIFEST_KEY_MAX_LENGTH = 70;
    private final File manifestFile;
    private final String manifestSection;

    public ManifestHelper(File manifestFile, String manifestSection) {
        this.manifestFile = manifestFile;
        this.manifestSection = manifestSection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createManifest(Properties buildMetaDataProperties) throws IOException {
        Manifest manifest = this.createManifestInstance(buildMetaDataProperties);
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(this.manifestFile));
            manifest.write(out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    private Manifest createManifestInstance(Properties buildMetaDataProperties) {
        Manifest manifest = new Manifest();
        Attributes attributes = this.fetchAttributes(manifest);
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        for (Map.Entry<Object, Object> entry : buildMetaDataProperties.entrySet()) {
            String key = ObjectUtils.toString((Object)entry.getKey(), null);
            if (key.length() > 70) continue;
            String normalizedKey = ManifestHelper.normalize(key);
            String value = ObjectUtils.toString((Object)entry.getValue(), null);
            attributes.putValue(normalizedKey, value);
        }
        return manifest;
    }

    private Attributes fetchAttributes(Manifest manifest) {
        if (StringUtils.isBlank((String)this.manifestSection) || "Main".equals(this.manifestSection)) {
            return manifest.getMainAttributes();
        }
        Attributes attributes = manifest.getAttributes(this.manifestSection);
        if (attributes == null) {
            attributes = new Attributes();
            manifest.getEntries().put(this.manifestSection, attributes);
        }
        return attributes;
    }

    private static String normalize(String key) {
        int length = key.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char ch = key.charAt(i);
            if (CharUtils.isAsciiAlphanumeric((char)ch) || ch == '-' || ch == '_') {
                buffer.append(ch);
                continue;
            }
            buffer.append('_');
        }
        return buffer.toString();
    }
}

