/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.resilience.otel;

import com.redhat.resilience.otel.internal.EnvarExtractingPropagator;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OTelCLIHelper {
    private static final Logger log = LoggerFactory.getLogger(OTelCLIHelper.class);
    private static SpanProcessor spanProcessor;
    private static Span root;

    public static SpanExporter defaultSpanExporter(String endpoint) {
        return OtlpGrpcSpanExporter.builder().setEndpoint(endpoint).build();
    }

    public static SpanProcessor defaultSpanProcessor(SpanExporter exporter) {
        return BatchSpanProcessor.builder((SpanExporter)exporter).build();
    }

    public static void startOTel(String serviceName, SpanProcessor processor) {
        OTelCLIHelper.startOTel(serviceName, "cli-execution", processor);
    }

    public static void startOTel(String serviceName, String commandName, SpanProcessor processor) {
        if (spanProcessor != null) {
            throw new IllegalStateException("startOTel has already been called");
        }
        if (serviceName == null) {
            throw new RuntimeException("serviceName must be passed in");
        }
        if (commandName == null) {
            commandName = serviceName;
        }
        spanProcessor = processor;
        Resource resource = Resource.getDefault().merge(Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)serviceName)));
        SdkTracerProvider sdkTracerProvider = SdkTracerProvider.builder().addSpanProcessor(processor).setResource(resource).build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setTracerProvider(sdkTracerProvider).setPropagators(ContextPropagators.create((TextMapPropagator)EnvarExtractingPropagator.getInstance())).buildAndRegisterGlobal();
        Context parentContext = EnvarExtractingPropagator.getInstance().extract(Context.current(), null, null);
        root = openTelemetry.getTracer(serviceName).spanBuilder(commandName).setParent(parentContext).startSpan();
        root.makeCurrent();
        log.debug("Running with traceId {} spanId {}", (Object)Span.current().getSpanContext().getTraceId(), (Object)Span.current().getSpanContext().getSpanId());
    }

    public static boolean otelEnabled() {
        return spanProcessor != null;
    }

    public static void stopOTel() {
        if (OTelCLIHelper.otelEnabled()) {
            log.debug("Finishing OpenTelemetry instrumentation for {}", (Object)root);
            if (root != null) {
                root.end();
            }
            spanProcessor.close();
            spanProcessor = null;
        }
    }

    private OTelCLIHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        root = null;
    }
}

