/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.resilience.otel.internal;

import com.redhat.resilience.otel.internal.OTelContextUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvarExtractingPropagator
implements TextMapPropagator {
    private static final Logger log = LoggerFactory.getLogger(EnvarExtractingPropagator.class);
    private static final String ENVAR_TRACE_PARENT = "TRACEPARENT";
    private static final String ENVAR_TRACE_STATE = "TRACESTATE";
    private static final String ENVAR_TRACE_ID = "TRACE_ID";
    private static final String ENVAR_SPAN_ID = "SPAN_ID";
    private static final EnvarExtractingPropagator INSTANCE = new EnvarExtractingPropagator();

    private EnvarExtractingPropagator() {
    }

    public static EnvarExtractingPropagator getInstance() {
        return INSTANCE;
    }

    public Collection<String> fields() {
        return W3CTraceContextPropagator.getInstance().fields();
    }

    public <C> void inject(Context context, C c, TextMapSetter<C> textMapSetter) {
        W3CTraceContextPropagator.getInstance().inject(context, c, textMapSetter);
    }

    public <C> Context extract(Context context, C carrier, TextMapGetter<C> getter) {
        SpanContext spanContext;
        if (context == null) {
            context = Context.root();
        }
        if (!(spanContext = EnvarExtractingPropagator.extractFromEnvars()).isValid()) {
            return context;
        }
        return context.with((ImplicitContextKeyed)Span.wrap((SpanContext)spanContext));
    }

    private static <C> SpanContext extractFromEnvars() {
        Map<String, String> envMap = System.getenv();
        SpanContext contextFromParent = null;
        String traceParentValue = EnvarExtractingPropagator.parseURL(envMap.get(ENVAR_TRACE_PARENT));
        log.info("Trace parent: {}", (Object)traceParentValue);
        if (traceParentValue != null) {
            contextFromParent = OTelContextUtil.extractContextFromTraceParent(traceParentValue);
        }
        if (contextFromParent == null) {
            String traceId = EnvarExtractingPropagator.parseURL(envMap.get(ENVAR_TRACE_ID));
            String parentSpanId = EnvarExtractingPropagator.parseURL(envMap.get(ENVAR_SPAN_ID));
            log.debug("Trace ID: {}, Span ID: {}", (Object)traceId, (Object)parentSpanId);
            if (traceId != null && !traceId.isEmpty() && parentSpanId != null && !parentSpanId.isEmpty()) {
                contextFromParent = SpanContext.createFromRemoteParent((String)traceId, (String)parentSpanId, (TraceFlags)TraceFlags.getDefault(), (TraceState)TraceState.getDefault());
            }
        }
        if (contextFromParent == null) {
            return SpanContext.getInvalid();
        }
        if (!contextFromParent.isValid()) {
            return contextFromParent;
        }
        String traceStateValue = EnvarExtractingPropagator.parseURL(envMap.get(ENVAR_TRACE_STATE));
        log.debug("Trace state: {}", (Object)traceStateValue);
        if (traceStateValue == null || traceStateValue.isEmpty()) {
            return contextFromParent;
        }
        try {
            TraceState traceState = OTelContextUtil.extractTraceState(traceStateValue);
            return SpanContext.createFromRemoteParent((String)contextFromParent.getTraceId(), (String)contextFromParent.getSpanId(), (TraceFlags)contextFromParent.getTraceFlags(), (TraceState)traceState);
        }
        catch (IllegalArgumentException e) {
            log.debug("Unparseable tracestate header. Returning span context without state.");
            return contextFromParent;
        }
    }

    public static String parseURL(String value) {
        String result = value;
        if (result != null && (result.startsWith("http") || result.startsWith("file"))) {
            try {
                URLConnection conn = new URL(result).openConnection();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                    result = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

