/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.resilience.otel.internal;

import io.opentelemetry.api.internal.OtelEncodingUtils;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.TraceStateBuilder;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OTelContextUtil {
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = TraceId.getLength();
    private static final int SPAN_ID_HEX_SIZE = SpanId.getLength();
    private static final int TRACE_OPTION_HEX_SIZE = TraceFlags.getLength();
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET = 3 + TRACE_ID_HEX_SIZE + 1;
    private static final int TRACE_OPTION_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
    private static final int TRACEPARENT_HEADER_SIZE = TRACE_OPTION_OFFSET + TRACE_OPTION_HEX_SIZE;
    private static final int TRACESTATE_MAX_MEMBERS = 32;
    private static final char TRACESTATE_KEY_VALUE_DELIMITER = '=';
    private static final char TRACESTATE_ENTRY_DELIMITER = ',';
    private static final Pattern TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN = Pattern.compile("[ \t]*,[ \t]*");
    private static final Set<String> VALID_VERSIONS = new HashSet<String>();
    private static final String VERSION_00 = "00";

    private OTelContextUtil() {
    }

    public static SpanContext extractContextFromTraceParent(String traceparent) {
        boolean isValid;
        Logger logger = LoggerFactory.getLogger(OTelContextUtil.class);
        boolean bl = isValid = (traceparent.length() == TRACEPARENT_HEADER_SIZE || traceparent.length() > TRACEPARENT_HEADER_SIZE && traceparent.charAt(TRACEPARENT_HEADER_SIZE) == '-') && traceparent.charAt(2) == '-' && traceparent.charAt(SPAN_ID_OFFSET - 1) == '-' && traceparent.charAt(TRACE_OPTION_OFFSET - 1) == '-';
        if (!isValid) {
            logger.debug("Unparseable traceparent header. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String version = traceparent.substring(0, 2);
        if (!VALID_VERSIONS.contains(version)) {
            return SpanContext.getInvalid();
        }
        if (version.equals(VERSION_00) && traceparent.length() > TRACEPARENT_HEADER_SIZE) {
            return SpanContext.getInvalid();
        }
        String traceId = traceparent.substring(3, 3 + TraceId.getLength());
        String spanId = traceparent.substring(SPAN_ID_OFFSET, SPAN_ID_OFFSET + SpanId.getLength());
        char firstTraceFlagsChar = traceparent.charAt(TRACE_OPTION_OFFSET);
        char secondTraceFlagsChar = traceparent.charAt(TRACE_OPTION_OFFSET + 1);
        if (!OtelEncodingUtils.isValidBase16Character((char)firstTraceFlagsChar) || !OtelEncodingUtils.isValidBase16Character((char)secondTraceFlagsChar)) {
            return SpanContext.getInvalid();
        }
        TraceFlags traceFlags = TraceFlags.fromByte((byte)OtelEncodingUtils.byteFromBase16((char)firstTraceFlagsChar, (char)secondTraceFlagsChar));
        return SpanContext.createFromRemoteParent((String)traceId, (String)spanId, (TraceFlags)traceFlags, (TraceState)TraceState.getDefault());
    }

    public static TraceState extractTraceState(String traceStateHeader) {
        TraceStateBuilder traceStateBuilder = TraceState.builder();
        String[] listMembers = TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN.split(traceStateHeader);
        Utils.checkArgument((listMembers.length <= 32 ? 1 : 0) != 0, (String)"TraceState has too many elements.");
        for (int i = listMembers.length - 1; i >= 0; --i) {
            String listMember = listMembers[i];
            int index = listMember.indexOf(61);
            Utils.checkArgument((index != -1 ? 1 : 0) != 0, (String)"Invalid TraceState list-member format.");
            traceStateBuilder.put(listMember.substring(0, index), listMember.substring(index + 1));
        }
        TraceState traceState = traceStateBuilder.build();
        if (traceState.size() != listMembers.length) {
            return TraceState.getDefault();
        }
        return traceState;
    }

    static {
        for (int i = 0; i < 255; ++i) {
            String version = Long.toHexString(i);
            if (version.length() < 2) {
                version = '0' + version;
            }
            VALID_VERSIONS.add(version);
        }
    }
}

