/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims;

import com.redhat.victims.ArtifactCollector;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseArtifactCollector
implements ArtifactCollector {
    protected EnforcerRuleHelper helper;
    protected HashSet<Artifact> artifacts;
    protected MavenProject project;

    BaseArtifactCollector() {
    }

    private void reset() {
        this.artifacts = new HashSet();
        try {
            this.project = (MavenProject)this.helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException expressionEvaluationException) {
            // empty catch block
        }
    }

    protected void gatherArtifacts() {
        for (Object a : this.project.getArtifacts()) {
            if (!(a instanceof Artifact)) continue;
            Artifact artifact = (Artifact)a;
            this.artifacts.add(artifact);
            this.helper.getLog().debug((CharSequence)("[victims-enforcer] adding project dependency " + artifact.toString()));
        }
    }

    @Override
    public ArtifactCollector with(EnforcerRuleHelper helper) {
        this.helper = helper;
        return this;
    }

    @Override
    public Set<Artifact> getArtifacts() {
        if (this.helper != null && (this.artifacts == null || this.artifacts.size() == 0)) {
            this.reset();
            this.gatherArtifacts();
        }
        return this.artifacts;
    }
}

