/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextUI {
    public static String repeat(char c, int n) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            buf.append(c);
        }
        return buf.toString();
    }

    public static String box(String word) {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("%n", new Object[0]));
        buf.append("+");
        buf.append(TextUI.repeat('=', word.length()));
        buf.append("+");
        buf.append(String.format("%n", new Object[0]));
        buf.append("|");
        buf.append(word.toUpperCase());
        buf.append("|");
        buf.append(String.format("%n", new Object[0]));
        buf.append("+");
        buf.append(TextUI.repeat('=', word.length()));
        buf.append("+");
        buf.append(String.format("%n", new Object[0]));
        return buf.toString();
    }

    public static String indent(int amount, String str) {
        StringBuilder buf = new StringBuilder();
        StringTokenizer toks = new StringTokenizer(str, "\n");
        while (toks.hasMoreTokens()) {
            buf.append(toks.nextToken());
            buf.append(String.format("%n", new Object[0]));
            buf.append(TextUI.repeat(' ', amount));
        }
        return buf.toString();
    }

    public static String wrap(int limit, String str) {
        StringBuilder buf = new StringBuilder();
        int pos = 0;
        int edge = Math.round(0.1f * (float)limit);
        while (pos < str.length()) {
            String addition;
            int end = pos + limit;
            if (end > str.length()) {
                end = str.length();
            }
            String chunk = str.substring(pos, end);
            int newline = chunk.indexOf(10);
            int space = chunk.lastIndexOf(32);
            int len = chunk.length();
            if (newline > 0) {
                addition = chunk.substring(0, newline);
                buf.append(addition.trim());
                pos += addition.length();
                continue;
            }
            if (len - edge > 0 && space > len - edge) {
                addition = chunk.substring(0, space);
                buf.append(addition.trim());
                buf.append(String.format("%n", new Object[0]));
                pos += addition.length() + 1;
                continue;
            }
            buf.append(chunk.trim());
            buf.append(String.format("%n", new Object[0]));
            pos += limit;
        }
        return buf.toString();
    }

    public static String truncate(int n, String str) {
        if (str.length() <= n) {
            return str;
        }
        return str.substring(0, n).concat("...");
    }

    public static String join(Iterable<String> items) {
        return TextUI.join(items, " ");
    }

    public static String join(Iterable<String> items, String sep) {
        StringBuilder sb = new StringBuilder();
        for (String item : items) {
            sb.append(item);
            sb.append(sep);
        }
        String rv = sb.toString();
        return rv.substring(0, rv.length() - sep.length());
    }

    public static String fmt(String key, Object ... args) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.redhat.victims.Resources");
        String formatting = bundle.getString(key);
        return String.format(formatting, args);
    }

    public static void report(Log l, String mode, String msg) {
        String level = mode.equals("fatal") ? "error" : (mode.equals("warning") ? "warn" : "info");
        try {
            Class[] args = new Class[]{CharSequence.class};
            Method m = l.getClass().getDeclaredMethod(level, args);
            m.invoke((Object)l, msg);
        }
        catch (NoSuchMethodException e) {
            l.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            l.error((Throwable)e);
        }
        catch (InvocationTargetException e) {
            l.error((Throwable)e);
        }
    }
}

