/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims;

import com.redhat.victims.VictimsException;
import com.redhat.victims.database.VictimsDB;
import com.redhat.victims.fingerprint.Algorithms;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class VictimsConfig {
    protected static String DEFAULT_ALGORITHM_STRING = "SHA512";
    public static final HashMap<String, String> DEFAULT_PROPS = new HashMap();

    public static Algorithms getDefaultAlgorithm() {
        return Algorithms.valueOf(DEFAULT_ALGORITHM_STRING);
    }

    private static String getPropertyValue(String key) {
        String env = System.getProperty(key);
        if (env == null) {
            if (DEFAULT_PROPS.containsKey(key)) {
                return DEFAULT_PROPS.get(key);
            }
            return null;
        }
        return env;
    }

    public static Charset charset() {
        String enc = VictimsConfig.getPropertyValue("victims.encoding");
        return Charset.forName(enc);
    }

    public static String uri() {
        return VictimsConfig.getPropertyValue("victims.service.uri");
    }

    public static String entry() {
        return VictimsConfig.getPropertyValue("victims.service.entry");
    }

    public static String serviceURI() throws VictimsException {
        try {
            URL merged = new URL(new URL(VictimsConfig.uri()), VictimsConfig.entry());
            return merged.toString();
        }
        catch (MalformedURLException e) {
            throw new VictimsException("Invalid configuration for service URI.", e);
        }
    }

    public static File home() throws VictimsException {
        File directory = new File(VictimsConfig.getPropertyValue("victims.home"));
        if (!directory.exists()) {
            try {
                FileUtils.forceMkdir((File)directory);
            }
            catch (IOException e) {
                throw new VictimsException("Could not create home directory.", e);
            }
        }
        return directory;
    }

    public static ArrayList<Algorithms> algorithms() {
        ArrayList<Algorithms> algorithms = new ArrayList<Algorithms>();
        for (String alg : VictimsConfig.getPropertyValue("victims.algorithms").split(",")) {
            alg = alg.trim();
            try {
                algorithms.add(Algorithms.valueOf(alg));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!algorithms.contains((Object)VictimsConfig.getDefaultAlgorithm())) {
            algorithms.add(VictimsConfig.getDefaultAlgorithm());
        }
        return algorithms;
    }

    public static String dbDriver() {
        return VictimsConfig.getPropertyValue("victims.db.driver");
    }

    public static String dbUrl() {
        String dbUrl = VictimsConfig.getPropertyValue("victims.db.url");
        if (dbUrl == null) {
            if (VictimsDB.Driver.exists(VictimsConfig.dbDriver())) {
                return VictimsDB.defaultURL(VictimsConfig.dbDriver());
            }
            return VictimsDB.defaultURL();
        }
        return dbUrl;
    }

    public static String dbUser() {
        return VictimsConfig.getPropertyValue("victims.db.user");
    }

    public static String dbPass() {
        return VictimsConfig.getPropertyValue("victims.db.pass");
    }

    public static boolean forcedUpdate() {
        return Boolean.getBoolean("victims.db.purge");
    }

    public static boolean purgeCache() {
        return Boolean.getBoolean("victims.cache.purge");
    }

    static {
        DEFAULT_PROPS.put("victims.service.uri", "http://www.victi.ms/");
        DEFAULT_PROPS.put("victims.service.entry", "service/");
        DEFAULT_PROPS.put("victims.encoding", "UTF-8");
        DEFAULT_PROPS.put("victims.home", FilenameUtils.concat((String)FileUtils.getUserDirectory().getAbsolutePath(), (String)".victims"));
        DEFAULT_PROPS.put("victims.algorithms", DEFAULT_ALGORITHM_STRING);
        DEFAULT_PROPS.put("victims.db.driver", VictimsDB.defaultDriver());
        DEFAULT_PROPS.put("victims.db.user", "victims");
        DEFAULT_PROPS.put("victims.db.pass", "victims");
    }

    public static class Key {
        public static final String URI = "victims.service.uri";
        public static final String ENTRY = "victims.service.entry";
        public static final String ENCODING = "victims.encoding";
        public static final String HOME = "victims.home";
        public static final String PURGE_CACHE = "victims.cache.purge";
        public static final String ALGORITHMS = "victims.algorithms";
        public static final String DB_DRIVER = "victims.db.driver";
        public static final String DB_URL = "victims.db.url";
        public static final String DB_USER = "victims.db.user";
        public static final String DB_PASS = "victims.db.pass";
        public static final String DB_PURGE = "victims.db.purge";
    }
}

