/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims.fingerprint;

import com.redhat.victims.VictimsConfig;
import com.redhat.victims.fingerprint.AbstractFile;
import com.redhat.victims.fingerprint.Algorithms;
import com.redhat.victims.fingerprint.Artifact;
import com.redhat.victims.fingerprint.ClassFile;
import com.redhat.victims.fingerprint.File;
import com.redhat.victims.fingerprint.Fingerprint;
import com.redhat.victims.fingerprint.FingerprintInterface;
import com.redhat.victims.fingerprint.JarFile;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;

public class Processor {
    private static DefaultHashMap<String, Class<?>> TYPE_MAP = new DefaultHashMap(File.class);
    public static String CONTENT_KEY = "content";
    public static String CONTENT_FINGERPRINT_KEY = "content-fingerprint";
    public static String FINGERPRINT_KEY = "fingerprint";
    public static String METADATA_KEY = "metadata";
    public static String FILENAME_KEY = "filename";

    public static Class<?> getProcessor(String filetype) {
        return TYPE_MAP.get(filetype.toLowerCase());
    }

    public static boolean isKnownType(String fileType) {
        return TYPE_MAP.containsKey(fileType);
    }

    public static Artifact process(byte[] bytes, String fileName, Boolean knownTypesOnly) {
        Class<?> cls;
        String fileType = Processor.getFileType(fileName);
        if ((!knownTypesOnly.booleanValue() || knownTypesOnly.booleanValue() && Processor.isKnownType(fileType)) && AbstractFile.class.isAssignableFrom(cls = Processor.getProcessor(fileType))) {
            try {
                Constructor<?> ctor = cls.getConstructor(byte[].class, String.class);
                Object object = ctor.newInstance(bytes, fileName);
                return ((FingerprintInterface)object).getRecord();
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public static Artifact process(byte[] bytes, String fileName) {
        return Processor.process(bytes, fileName, false);
    }

    public static Artifact process(InputStream is, String fileName) throws IOException {
        return Processor.process(IOUtils.toByteArray((InputStream)is), fileName);
    }

    public static Artifact process(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        return Processor.process(fis, fileName);
    }

    protected static String getFileType(String name) {
        String[] tokens = name.split("\\.(?=[^\\.]+$)");
        if (tokens.length > 1) {
            return "." + tokens[tokens.length - 1].toLowerCase();
        }
        return "";
    }

    public static Fingerprint fingerprint(byte[] bytes) {
        Fingerprint fingerprint = new Fingerprint();
        for (Algorithms algorithm : VictimsConfig.algorithms()) {
            try {
                MessageDigest md = MessageDigest.getInstance(algorithm.toString().toUpperCase());
                fingerprint.put(algorithm, new String(Hex.encodeHex((byte[])md.digest(bytes))));
            }
            catch (NoSuchAlgorithmException e) {}
        }
        return fingerprint;
    }

    static {
        TYPE_MAP.put(".class", ClassFile.class);
        TYPE_MAP.put(".jar", JarFile.class);
    }

    protected static class DefaultHashMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 1L;
        protected V defaultValue;

        public DefaultHashMap(V defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public V get(Object k) {
            Object v = super.get(k);
            return v == null && !this.containsKey(k) ? this.defaultValue : v;
        }
    }
}

