/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandArgs;
import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.AggregateOperation;
import com.redis.lettucemod.search.Apply;
import com.redis.lettucemod.search.Filter;
import com.redis.lettucemod.search.Group;
import com.redis.lettucemod.search.Limit;
import com.redis.lettucemod.search.RediSearchArgument;
import com.redis.lettucemod.search.Sort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AggregateOptions<K, V>
implements RediSearchArgument<K, V> {
    private final List<AggregateOperation<K, V>> operations;
    private final List<String> loads;
    private final boolean verbatim;

    public AggregateOptions(List<AggregateOperation<K, V>> operations, List<String> loads, boolean verbatim) {
        this.operations = operations;
        this.loads = loads;
        this.verbatim = verbatim;
    }

    @Override
    public void build(SearchCommandArgs<K, V> args) {
        if (this.verbatim) {
            args.add(SearchCommandKeyword.VERBATIM);
        }
        if (!this.loads.isEmpty()) {
            args.add(SearchCommandKeyword.LOAD);
            args.add(this.loads.size());
            for (String load : this.loads) {
                args.addProperty(load);
            }
        }
        for (AggregateOperation<K, V> operation : this.operations) {
            operation.build(args);
        }
    }

    public static <K, V> AggregateOptionsBuilder<K, V> builder() {
        return new AggregateOptionsBuilder();
    }

    public static <K, V> AggregateOptionsBuilder<K, V> apply(Apply<K, V> apply) {
        return AggregateOptions.operation(apply);
    }

    public static <K, V> AggregateOptionsBuilder<K, V> filter(Filter<V> filter) {
        return AggregateOptions.operation(filter);
    }

    public static <K, V> AggregateOptionsBuilder<K, V> group(Group group) {
        return AggregateOptions.operation(group);
    }

    public static <K, V> AggregateOptionsBuilder<K, V> limit(Limit limit) {
        return AggregateOptions.operation(limit);
    }

    public static <K, V> AggregateOptionsBuilder<K, V> sort(Sort sort) {
        return AggregateOptions.operation(sort);
    }

    public static <K, V> AggregateOptionsBuilder<K, V> operation(AggregateOperation<K, V> operation) {
        return new AggregateOptionsBuilder<K, V>(operation);
    }

    public static class AggregateOptionsBuilder<K, V> {
        private final List<AggregateOperation<K, V>> operations = new ArrayList<AggregateOperation<K, V>>();
        private final List<String> loads = new ArrayList<String>();
        private boolean verbatim;

        public AggregateOptionsBuilder() {
        }

        public AggregateOptionsBuilder(AggregateOperation<K, V> operation) {
            this.operations.add(operation);
        }

        public AggregateOptionsBuilder<K, V> apply(Apply<K, V> apply) {
            this.operations.add(apply);
            return this;
        }

        public AggregateOptionsBuilder<K, V> filter(Filter<V> filter) {
            this.operations.add(filter);
            return this;
        }

        public AggregateOptionsBuilder<K, V> group(Group group) {
            this.operations.add(group);
            return this;
        }

        public AggregateOptionsBuilder<K, V> limit(Limit limit) {
            this.operations.add(limit);
            return this;
        }

        public AggregateOptionsBuilder<K, V> sort(Sort sort) {
            this.operations.add(sort);
            return this;
        }

        public AggregateOptionsBuilder<K, V> load(String load) {
            this.loads.add(load);
            return this;
        }

        public AggregateOptionsBuilder<K, V> loads(String ... loads) {
            this.loads.addAll(Arrays.asList(loads));
            return this;
        }

        public AggregateOptionsBuilder<K, V> verbatim(boolean verbatim) {
            this.verbatim = verbatim;
            return this;
        }

        public AggregateOptions<K, V> build() {
            return new AggregateOptions<K, V>(this.operations, this.loads, this.verbatim);
        }
    }
}

