/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandArgs;
import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.RediSearchArgument;
import io.lettuce.core.internal.LettuceAssert;

public abstract class Field
implements RediSearchArgument {
    private final Type type;
    private final String name;
    private String as;
    private boolean sortable;
    private boolean unNormalizedForm;
    private boolean noIndex;

    protected Field(Type type, String name) {
        LettuceAssert.notNull((Object)((Object)type), (String)"A type is required");
        LettuceAssert.notNull((Object)name, (String)"A name is required");
        this.type = type;
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getAs() {
        return this.as;
    }

    public void setAs(String as) {
        this.as = as;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public boolean isUnNormalizedForm() {
        return this.unNormalizedForm;
    }

    public void setUnNormalizedForm(boolean unNormalizedForm) {
        this.unNormalizedForm = unNormalizedForm;
    }

    public boolean isNoIndex() {
        return this.noIndex;
    }

    public void setNoIndex(boolean noIndex) {
        this.noIndex = noIndex;
    }

    public void build(SearchCommandArgs args) {
        args.add(this.name);
        if (this.as != null) {
            args.add(SearchCommandKeyword.AS);
            args.add(this.as);
        }
        this.buildField(args);
        if (this.sortable) {
            args.add(SearchCommandKeyword.SORTABLE);
            if (this.unNormalizedForm) {
                args.add(SearchCommandKeyword.UNF);
            }
        }
        if (this.noIndex) {
            args.add(SearchCommandKeyword.NOINDEX);
        }
    }

    protected abstract void buildField(SearchCommandArgs var1);

    public static TextField.TextFieldBuilder text(String name) {
        return TextField.builder(name);
    }

    public static GeoField.GeoFieldBuilder geo(String name) {
        return GeoField.builder(name);
    }

    public static TagField.TagFieldBuilder tag(String name) {
        return TagField.builder(name);
    }

    public static NumericField.NumericFieldBuilder numeric(String name) {
        return NumericField.builder(name);
    }

    public static enum Type {
        TEXT,
        NUMERIC,
        GEO,
        TAG;

    }

    public static class TextField
    extends Field {
        private Double weight;
        private boolean noStem;
        private PhoneticMatcher matcher;

        public TextField(String name) {
            super(Type.TEXT, name);
        }

        public Double getWeight() {
            return this.weight;
        }

        public void setWeight(Double weight) {
            this.weight = weight;
        }

        public boolean isNoStem() {
            return this.noStem;
        }

        public void setNoStem(boolean noStem) {
            this.noStem = noStem;
        }

        public PhoneticMatcher getMatcher() {
            return this.matcher;
        }

        public void setMatcher(PhoneticMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        protected void buildField(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.TEXT);
            if (this.noStem) {
                args.add(SearchCommandKeyword.NOSTEM);
            }
            if (this.weight != null) {
                args.add(SearchCommandKeyword.WEIGHT);
                args.add(this.weight);
            }
            if (this.matcher != null) {
                args.add(SearchCommandKeyword.PHONETIC);
                args.add(this.matcher.getCode());
            }
        }

        public static TextFieldBuilder builder(String name) {
            return new TextFieldBuilder(name);
        }

        public static enum PhoneticMatcher {
            ENGLISH("dm:en"),
            FRENCH("dm:fr"),
            PORTUGUESE("dm:pt"),
            SPANISH("dm:es");

            private final String code;

            private PhoneticMatcher(String code) {
                this.code = code;
            }

            public String getCode() {
                return this.code;
            }
        }

        public static class TextFieldBuilder
        extends FieldBuilder<TextField, TextFieldBuilder> {
            private boolean noStem;
            private Double weight;
            private PhoneticMatcher matcher;

            public TextFieldBuilder(String name) {
                super(name);
            }

            public TextFieldBuilder noStem() {
                this.noStem = true;
                return this;
            }

            public TextFieldBuilder weight(double weight) {
                this.weight = weight;
                return this;
            }

            public TextFieldBuilder matcher(PhoneticMatcher matcher) {
                this.matcher = matcher;
                return this;
            }

            @Override
            public TextField newField() {
                TextField field = new TextField(this.name);
                field.setNoStem(this.noStem);
                field.setWeight(this.weight);
                field.setMatcher(this.matcher);
                return field;
            }
        }
    }

    public static class TagField
    extends Field {
        private String separator;
        private boolean caseSensitive;

        public TagField(String name) {
            super(Type.TAG, name);
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String separator) {
            this.separator = separator;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        @Override
        protected void buildField(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.TAG);
            if (this.separator != null) {
                args.add(SearchCommandKeyword.SEPARATOR);
                args.add(this.separator);
            }
            if (this.caseSensitive) {
                args.add(SearchCommandKeyword.CASESENSITIVE);
            }
        }

        public static TagFieldBuilder builder(String name) {
            return new TagFieldBuilder(name);
        }

        public static class TagFieldBuilder
        extends FieldBuilder<TagField, TagFieldBuilder> {
            private String separator;
            private boolean caseSensitive;

            public TagFieldBuilder(String name) {
                super(name);
            }

            public TagFieldBuilder separator(String separator) {
                this.separator = separator;
                return this;
            }

            public TagFieldBuilder caseSensitive() {
                this.caseSensitive = true;
                return this;
            }

            @Override
            public TagField newField() {
                TagField field = new TagField(this.name);
                field.setSeparator(this.separator);
                field.setCaseSensitive(this.caseSensitive);
                return field;
            }
        }
    }

    public static class NumericField
    extends Field {
        public NumericField(String name) {
            super(Type.NUMERIC, name);
        }

        @Override
        protected void buildField(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.NUMERIC);
        }

        public static NumericFieldBuilder builder(String name) {
            return new NumericFieldBuilder(name);
        }

        public static class NumericFieldBuilder
        extends FieldBuilder<NumericField, NumericFieldBuilder> {
            public NumericFieldBuilder(String name) {
                super(name);
            }

            @Override
            public NumericField newField() {
                return new NumericField(this.name);
            }
        }
    }

    public static class GeoField
    extends Field {
        public GeoField(String name) {
            super(Type.GEO, name);
        }

        @Override
        protected void buildField(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.GEO);
        }

        public static GeoFieldBuilder builder(String name) {
            return new GeoFieldBuilder(name);
        }

        public static class GeoFieldBuilder
        extends FieldBuilder<GeoField, GeoFieldBuilder> {
            public GeoFieldBuilder(String name) {
                super(name);
            }

            @Override
            public GeoField newField() {
                return new GeoField(this.name);
            }
        }
    }

    protected static abstract class FieldBuilder<F extends Field, B extends FieldBuilder<F, B>> {
        protected final String name;
        private String as;
        private boolean sortable;
        private boolean unNormalizedForm;
        private boolean noIndex;

        protected FieldBuilder(String name) {
            this.name = name;
        }

        public B as(String as) {
            this.as = as;
            return (B)this;
        }

        public B sortable() {
            this.sortable = true;
            return (B)this;
        }

        public B unNormalizedForm() {
            this.sortable = true;
            this.unNormalizedForm = true;
            return (B)this;
        }

        public B noIndex() {
            this.noIndex = true;
            return (B)this;
        }

        public abstract F newField();

        public F build() {
            F field = this.newField();
            ((Field)field).setAs(this.as);
            ((Field)field).setSortable(this.sortable);
            ((Field)field).setUnNormalizedForm(this.unNormalizedForm);
            ((Field)field).setNoIndex(this.noIndex);
            return field;
        }
    }
}

