/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.timeseries;

import com.redis.lettucemod.RedisModulesCommandBuilder;
import com.redis.lettucemod.output.GetOutput;
import com.redis.lettucemod.output.RangeOutput;
import com.redis.lettucemod.output.SampleListOutput;
import com.redis.lettucemod.output.SampleOutput;
import com.redis.lettucemod.protocol.TimeSeriesCommandKeyword;
import com.redis.lettucemod.protocol.TimeSeriesCommandType;
import com.redis.lettucemod.timeseries.Aggregation;
import com.redis.lettucemod.timeseries.CreateOptions;
import com.redis.lettucemod.timeseries.GetResult;
import com.redis.lettucemod.timeseries.KeySample;
import com.redis.lettucemod.timeseries.RangeOptions;
import com.redis.lettucemod.timeseries.RangeResult;
import com.redis.lettucemod.timeseries.Sample;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.IntegerListOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.NestedMultiOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.List;

public class RedisTimeSeriesCommandBuilder<K, V>
extends RedisModulesCommandBuilder<K, V> {
    private static final String AUTO_TIMESTAMP = "*";

    public RedisTimeSeriesCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    protected <A, B, T> Command<A, B, T> createCommand(TimeSeriesCommandType type, CommandOutput<A, B, T> output, CommandArgs<A, B> args) {
        return new Command((ProtocolKeyword)type, output, args);
    }

    public Command<K, V, String> create(K key, CreateOptions<K, V> options) {
        CommandArgs args = this.args(key);
        if (options != null) {
            options.build(args);
        }
        return this.createCommand(TimeSeriesCommandType.CREATE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> alter(K key, CreateOptions<K, V> options) {
        CommandArgs args = this.args(key);
        if (options != null) {
            options.build(args);
        }
        return this.createCommand(TimeSeriesCommandType.ALTER, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> add(K key, Sample sample) {
        return this.add(key, sample, null);
    }

    public Command<K, V, Long> add(K key, Sample sample, CreateOptions<K, V> options) {
        RedisTimeSeriesCommandBuilder.notNull(sample, "Sample");
        return this.doAdd(key, sample.getTimestamp(), sample.getValue(), options);
    }

    public Command<K, V, Long> add(K key, long timestamp, double value) {
        return this.doAdd(key, timestamp, value, null);
    }

    public Command<K, V, Long> add(K key, long timestamp, double value, CreateOptions<K, V> options) {
        return this.doAdd(key, timestamp, value, options);
    }

    public Command<K, V, Long> addAutoTimestamp(K key, double value) {
        return this.addAutoTimestamp(key, value, null);
    }

    public Command<K, V, Long> addAutoTimestamp(K key, double value, CreateOptions<K, V> options) {
        return this.doAdd(key, 0L, value, options);
    }

    private Command<K, V, Long> doAdd(K key, long timestamp, double value, CreateOptions<K, V> options) {
        CommandArgs args = this.args(key);
        this.add(args, timestamp, value);
        if (options != null) {
            options.build(args);
        }
        return this.createCommand(TimeSeriesCommandType.ADD, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    private void add(CommandArgs<K, V> args, long timestamp, double value) {
        if (timestamp == 0L) {
            args.add(AUTO_TIMESTAMP);
        } else {
            args.add(timestamp);
        }
        args.add(value);
    }

    public Command<K, V, List<Long>> madd(KeySample<K> ... samples) {
        RedisTimeSeriesCommandBuilder.notEmpty(samples, "Samples");
        CommandArgs args = new CommandArgs(this.codec);
        for (KeySample<K> sample : samples) {
            args.addKey(sample.getKey());
            this.add(args, sample.getTimestamp(), sample.getValue());
        }
        return this.createCommand(TimeSeriesCommandType.MADD, (CommandOutput)new IntegerListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> incrbyAutoTimestamp(K key, double value, CreateOptions<K, V> options) {
        return this.deincrby(TimeSeriesCommandType.INCRBY, key, value, null, true, options);
    }

    public Command<K, V, Long> decrbyAutoTimestamp(K key, double value, CreateOptions<K, V> options) {
        return this.deincrby(TimeSeriesCommandType.DECRBY, key, value, null, true, options);
    }

    public Command<K, V, Long> incrby(K key, double value, Long timestamp, CreateOptions<K, V> options) {
        return this.deincrby(TimeSeriesCommandType.INCRBY, key, value, timestamp, false, options);
    }

    public Command<K, V, Long> decrby(K key, double value, Long timestamp, CreateOptions<K, V> options) {
        return this.deincrby(TimeSeriesCommandType.DECRBY, key, value, timestamp, false, options);
    }

    private Command<K, V, Long> deincrby(TimeSeriesCommandType commandType, K key, double value, Long timestamp, boolean autoTimestamp, CreateOptions<K, V> options) {
        CommandArgs args = this.args(key);
        args.add(value);
        if (autoTimestamp) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.TIMESTAMP);
            args.add(AUTO_TIMESTAMP);
        } else if (timestamp != null) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.TIMESTAMP);
            args.add(timestamp.longValue());
        }
        if (options != null) {
            options.build(args);
        }
        return this.createCommand(commandType, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> createRule(K sourceKey, K destKey, Aggregation aggregation) {
        RedisTimeSeriesCommandBuilder.notNull(sourceKey, "Source key");
        RedisTimeSeriesCommandBuilder.notNull(destKey, "Destination key");
        RedisTimeSeriesCommandBuilder.notNull(aggregation, "Aggregation");
        CommandArgs args = this.args(sourceKey);
        args.addKey(destKey);
        aggregation.build(args);
        return this.createCommand(TimeSeriesCommandType.CREATERULE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> deleteRule(K sourceKey, K destKey) {
        RedisTimeSeriesCommandBuilder.notNull(sourceKey, "Source key");
        RedisTimeSeriesCommandBuilder.notNull(destKey, "Destination key");
        CommandArgs args = this.args(sourceKey);
        args.addKey(destKey);
        return this.createCommand(TimeSeriesCommandType.DELETERULE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Sample>> range(K key, RangeOptions options) {
        return this.range(TimeSeriesCommandType.RANGE, key, options);
    }

    public Command<K, V, List<Sample>> revrange(K key, RangeOptions options) {
        return this.range(TimeSeriesCommandType.REVRANGE, key, options);
    }

    private Command<K, V, List<Sample>> range(TimeSeriesCommandType commandType, K key, RangeOptions options) {
        RedisTimeSeriesCommandBuilder.notNull(options, "Options");
        CommandArgs args = this.args(key);
        options.build(args);
        return this.createCommand(commandType, new SampleListOutput(this.codec), args);
    }

    public Command<K, V, List<RangeResult<K, V>>> mrange(RangeOptions options, V ... filters) {
        return this.mrange(false, false, options, filters);
    }

    public Command<K, V, List<RangeResult<K, V>>> mrangeWithLabels(RangeOptions options, V ... filters) {
        return this.mrange(false, true, options, filters);
    }

    public Command<K, V, List<RangeResult<K, V>>> mrevrange(RangeOptions options, V ... filters) {
        return this.mrange(true, false, options, filters);
    }

    public Command<K, V, List<RangeResult<K, V>>> mrevrangeWithLabels(RangeOptions options, V ... filters) {
        return this.mrange(true, true, options, filters);
    }

    private Command<K, V, List<RangeResult<K, V>>> mrange(boolean reverse, boolean withLabels, RangeOptions options, V ... filters) {
        RedisTimeSeriesCommandBuilder.notNull(options, "Options");
        RedisTimeSeriesCommandBuilder.notEmpty(filters, "Filters");
        CommandArgs args = new CommandArgs(this.codec);
        options.build(args);
        if (withLabels) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.WITHLABELS);
        }
        args.add((ProtocolKeyword)TimeSeriesCommandKeyword.FILTER);
        args.addValues((Object[])filters);
        return this.createCommand(reverse ? TimeSeriesCommandType.MREVRANGE : TimeSeriesCommandType.MRANGE, new RangeOutput(this.codec), args);
    }

    public Command<K, V, Sample> get(K key) {
        return this.createCommand(TimeSeriesCommandType.GET, new SampleOutput(this.codec), this.args(key));
    }

    public Command<K, V, List<GetResult<K, V>>> mget(boolean withLabels, V ... filters) {
        CommandArgs args = new CommandArgs(this.codec);
        if (withLabels) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.WITHLABELS);
        }
        args.add((ProtocolKeyword)TimeSeriesCommandKeyword.FILTER);
        args.addValues((Object[])filters);
        return this.createCommand(TimeSeriesCommandType.MGET, new GetOutput(this.codec), args);
    }

    public Command<K, V, List<Object>> info(K key, boolean debug) {
        RedisTimeSeriesCommandBuilder.notNullKey(key);
        CommandArgs args = this.args(key);
        if (debug) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.DEBUG);
        }
        return this.createCommand(TimeSeriesCommandType.INFO, (CommandOutput)new NestedMultiOutput(this.codec), (CommandArgs)args);
    }
}

