/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.gears;

import com.redis.lettucemod.RedisModulesCommandBuilder;
import com.redis.lettucemod.gears.Execution;
import com.redis.lettucemod.gears.ExecutionDetails;
import com.redis.lettucemod.gears.ExecutionMode;
import com.redis.lettucemod.gears.Registration;
import com.redis.lettucemod.output.ExecutionDetailsOutput;
import com.redis.lettucemod.output.ExecutionListOutput;
import com.redis.lettucemod.output.ExecutionResults;
import com.redis.lettucemod.output.ExecutionResultsOutput;
import com.redis.lettucemod.output.RegistrationListOutput;
import com.redis.lettucemod.protocol.GearsCommandKeyword;
import com.redis.lettucemod.protocol.GearsCommandType;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.ArrayOutput;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.output.ValueListOutput;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.List;
import java.util.Map;

public class RedisGearsCommandBuilder<K, V>
extends RedisModulesCommandBuilder<K, V> {
    private static final String EXECUTION_ID = "Execution ID";

    public RedisGearsCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    protected <A, B, T> Command<A, B, T> createCommand(GearsCommandType type, CommandOutput<A, B, T> output) {
        return new Command((ProtocolKeyword)type, output);
    }

    protected <A, B, T> Command<A, B, T> createCommand(GearsCommandType type, CommandOutput<A, B, T> output, CommandArgs<A, B> args) {
        return new Command((ProtocolKeyword)type, output, args);
    }

    private CommandArgs<K, V> args() {
        return new CommandArgs(this.codec);
    }

    public Command<K, V, String> abortExecution(String id) {
        RedisGearsCommandBuilder.notNull(id, EXECUTION_ID);
        CommandArgs<K, V> args = this.args();
        args.add(id);
        return this.createCommand(GearsCommandType.ABORTEXECUTION, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<V>> configGet(K ... keys) {
        LettuceAssert.notEmpty((Object[])keys, (String)"At least one key is required.");
        CommandArgs<K, V> args = this.args();
        for (K key : keys) {
            args.addKey(key);
        }
        return this.createCommand(GearsCommandType.CONFIGGET, (CommandOutput)new ValueListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<V>> configSet(Map<K, V> map) {
        RedisGearsCommandBuilder.notNull(map, "Map");
        LettuceAssert.isTrue((!map.isEmpty() ? 1 : 0) != 0, (String)"At least one key/value is required.");
        CommandArgs<K, V> args = this.args();
        args.add(map);
        return this.createCommand(GearsCommandType.CONFIGSET, (CommandOutput)new ValueListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> dropExecution(String id) {
        RedisGearsCommandBuilder.notNull(id, EXECUTION_ID);
        CommandArgs<K, V> args = this.args();
        args.add(id);
        return this.createCommand(GearsCommandType.DROPEXECUTION, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Execution>> dumpExecutions() {
        return this.createCommand(GearsCommandType.DUMPEXECUTIONS, new ExecutionListOutput(this.codec));
    }

    public Command<K, V, List<Registration>> dumpRegistrations() {
        return this.createCommand(GearsCommandType.DUMPREGISTRATIONS, new RegistrationListOutput(this.codec));
    }

    public Command<K, V, ExecutionDetails> getExecution(String id) {
        return this.getExecution(id, null);
    }

    public Command<K, V, ExecutionDetails> getExecution(String id, ExecutionMode mode) {
        RedisGearsCommandBuilder.notNull(id, EXECUTION_ID);
        CommandArgs<K, V> args = this.args();
        args.add(id);
        if (mode != null) {
            args.add((ProtocolKeyword)(mode == ExecutionMode.SHARD ? GearsCommandKeyword.SHARD : GearsCommandKeyword.CLUSTER));
        }
        return this.createCommand(GearsCommandType.GETEXECUTION, new ExecutionDetailsOutput(this.codec), args);
    }

    public Command<K, V, ExecutionResults> getResults(String id) {
        return this.getResults(id, false);
    }

    public Command<K, V, ExecutionResults> getResultsBlocking(String id) {
        return this.getResults(id, true);
    }

    private Command<K, V, ExecutionResults> getResults(String id, boolean blocking) {
        RedisGearsCommandBuilder.notNull(id, EXECUTION_ID);
        CommandArgs<K, V> args = this.args();
        args.add(id);
        return this.createCommand(blocking ? GearsCommandType.GETRESULTSBLOCKING : GearsCommandType.GETRESULTS, new ExecutionResultsOutput(this.codec), args);
    }

    public Command<K, V, ExecutionResults> pyExecute(String function, V ... requirements) {
        CommandArgs<K, V> args = this.pyExecuteArgs(function, false, requirements);
        return this.createCommand(GearsCommandType.PYEXECUTE, new ExecutionResultsOutput(this.codec), args);
    }

    public Command<K, V, String> pyExecuteUnblocking(String function, V ... requirements) {
        CommandArgs<K, V> args = this.pyExecuteArgs(function, true, requirements);
        return this.createCommand(GearsCommandType.PYEXECUTE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    private CommandArgs<K, V> pyExecuteArgs(String function, boolean unblocking, V ... requirements) {
        RedisGearsCommandBuilder.notNull(function, "Function");
        RedisGearsCommandBuilder.notNull(requirements, "Requirements");
        CommandArgs<K, V> args = this.args();
        args.add(function);
        if (unblocking) {
            args.add((ProtocolKeyword)GearsCommandKeyword.UNBLOCKING);
        }
        if (requirements.length > 0) {
            args.add((ProtocolKeyword)GearsCommandKeyword.REQUIREMENTS);
            args.addValues((Object[])requirements);
        }
        return args;
    }

    public Command<K, V, List<Object>> trigger(String trigger, V ... args) {
        RedisGearsCommandBuilder.notNull(trigger, "Trigger name");
        CommandArgs<K, V> commandArgs = this.args();
        commandArgs.add(trigger);
        commandArgs.addValues((Object[])args);
        return this.createCommand(GearsCommandType.TRIGGER, (CommandOutput)new ArrayOutput(this.codec), (CommandArgs)commandArgs);
    }

    public Command<K, V, String> unregister(String id) {
        RedisGearsCommandBuilder.notNull(id, "Registration ID");
        CommandArgs<K, V> args = this.args();
        args.add(id);
        return this.createCommand(GearsCommandType.UNREGISTER, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }
}

