/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandArgs;
import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.Language;
import com.redis.lettucemod.search.RediSearchArgument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CreateOptions<K, V>
implements RediSearchArgument<K, V> {
    private DataType on;
    private List<K> prefixes = new ArrayList<K>();
    private V filter;
    private Language defaultLanguage;
    private K languageField;
    private Double defaultScore;
    private K scoreField;
    private K payloadField;
    private boolean maxTextFields;
    private Long temporary;
    private boolean noOffsets;
    private boolean noHL;
    private boolean noFields;
    private boolean noFreqs;
    private boolean noItitialScan;
    private List<V> stopWords;

    private CreateOptions(Builder<K, V> builder) {
        this.on = ((Builder)builder).on;
        this.prefixes = ((Builder)builder).prefixes;
        this.filter = ((Builder)builder).filter;
        this.defaultLanguage = ((Builder)builder).defaultLanguage;
        this.languageField = ((Builder)builder).languageField;
        this.defaultScore = ((Builder)builder).defaultScore;
        this.scoreField = ((Builder)builder).scoreField;
        this.payloadField = ((Builder)builder).payloadField;
        this.maxTextFields = ((Builder)builder).maxTextFields;
        this.temporary = ((Builder)builder).temporary;
        this.noOffsets = ((Builder)builder).noOffsets;
        this.noHL = ((Builder)builder).noHL;
        this.noFields = ((Builder)builder).noFields;
        this.noFreqs = ((Builder)builder).noFreqs;
        this.noItitialScan = ((Builder)builder).noItitialScan;
        this.stopWords = ((Builder)builder).stopWords;
    }

    @Override
    public void build(SearchCommandArgs<K, V> args) {
        if (this.on != null) {
            args.add(SearchCommandKeyword.ON);
            args.add(this.on.name());
        }
        if (this.prefixes != null && !this.prefixes.isEmpty()) {
            args.add(SearchCommandKeyword.PREFIX);
            args.add(this.prefixes.size());
            this.prefixes.forEach(args::addKey);
        }
        if (this.filter != null) {
            args.add(SearchCommandKeyword.FILTER);
            args.addValue((Object)this.filter);
        }
        if (this.defaultLanguage != null) {
            args.add(SearchCommandKeyword.LANGUAGE);
            args.add(this.defaultLanguage.getId());
        }
        if (this.languageField != null) {
            args.add(SearchCommandKeyword.LANGUAGE_FIELD);
            args.addKey((Object)this.languageField);
        }
        if (this.defaultScore != null) {
            args.add(SearchCommandKeyword.SCORE);
            args.add(this.defaultScore);
        }
        if (this.scoreField != null) {
            args.add(SearchCommandKeyword.SCORE_FIELD);
            args.addKey((Object)this.scoreField);
        }
        if (this.payloadField != null) {
            args.add(SearchCommandKeyword.PAYLOAD_FIELD);
            args.addKey((Object)this.payloadField);
        }
        if (this.maxTextFields) {
            args.add(SearchCommandKeyword.MAXTEXTFIELDS);
        }
        if (this.temporary != null) {
            args.add(SearchCommandKeyword.TEMPORARY);
            args.add(this.temporary);
        }
        if (this.noOffsets) {
            args.add(SearchCommandKeyword.NOOFFSETS);
        }
        if (this.noHL) {
            args.add(SearchCommandKeyword.NOHL);
        }
        if (this.noFields) {
            args.add(SearchCommandKeyword.NOFIELDS);
        }
        if (this.noFreqs) {
            args.add(SearchCommandKeyword.NOFREQS);
        }
        if (this.noItitialScan) {
            args.add(SearchCommandKeyword.NOINITIALSCAN);
        }
        if (this.stopWords != null) {
            args.add(SearchCommandKeyword.STOPWORDS);
            args.add(this.stopWords.size());
            this.stopWords.forEach(args::addValue);
        }
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static final class Builder<K, V> {
        private DataType on = DataType.HASH;
        private List<K> prefixes = new ArrayList<K>();
        private V filter;
        private Language defaultLanguage;
        private K languageField;
        private Double defaultScore;
        private K scoreField;
        private K payloadField;
        private boolean maxTextFields;
        private Long temporary;
        private boolean noOffsets;
        private boolean noHL;
        private boolean noFields;
        private boolean noFreqs;
        private boolean noItitialScan;
        private List<V> stopWords = new ArrayList<V>();

        public Builder<K, V> on(DataType on) {
            this.on = on;
            return this;
        }

        public Builder<K, V> prefix(K prefix) {
            this.prefixes.add(prefix);
            return this;
        }

        public Builder<K, V> prefixes(K ... prefixes) {
            this.prefixes.addAll(Arrays.asList(prefixes));
            return this;
        }

        public Builder<K, V> filter(V filter) {
            this.filter = filter;
            return this;
        }

        public Builder<K, V> defaultLanguage(Language defaultLanguage) {
            this.defaultLanguage = defaultLanguage;
            return this;
        }

        public Builder<K, V> languageField(K languageField) {
            this.languageField = languageField;
            return this;
        }

        public Builder<K, V> defaultScore(Double defaultScore) {
            this.defaultScore = defaultScore;
            return this;
        }

        public Builder<K, V> scoreField(K scoreField) {
            this.scoreField = scoreField;
            return this;
        }

        public Builder<K, V> payloadField(K payloadField) {
            this.payloadField = payloadField;
            return this;
        }

        public Builder<K, V> maxTextFields(boolean maxTextFields) {
            this.maxTextFields = maxTextFields;
            return this;
        }

        public Builder<K, V> temporary(Long temporary) {
            this.temporary = temporary;
            return this;
        }

        public Builder<K, V> noOffsets(boolean noOffsets) {
            this.noOffsets = noOffsets;
            return this;
        }

        public Builder<K, V> noHL(boolean noHL) {
            this.noHL = noHL;
            return this;
        }

        public Builder<K, V> noFields(boolean noFields) {
            this.noFields = noFields;
            return this;
        }

        public Builder<K, V> noFreqs(boolean noFreqs) {
            this.noFreqs = noFreqs;
            return this;
        }

        public Builder<K, V> noItitialScan(boolean noItitialScan) {
            this.noItitialScan = noItitialScan;
            return this;
        }

        public Builder<K, V> stopWords(List<V> stopWords) {
            this.stopWords = stopWords;
            return this;
        }

        public CreateOptions<K, V> build() {
            return new CreateOptions(this);
        }
    }

    public static enum DataType {
        HASH,
        JSON;

    }
}

