/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandArgs;
import com.redis.lettucemod.protocol.SearchCommandKeyword;
import java.util.Objects;

public class Cursor {
    private Long count;
    private Long maxIdle;

    public Cursor() {
    }

    public Cursor(Long count, Long maxIdle) {
        this.count = count;
        this.maxIdle = maxIdle;
    }

    public <K, V> void build(SearchCommandArgs<K, V> args) {
        if (this.count != null) {
            args.add(SearchCommandKeyword.COUNT);
            args.add(this.count);
        }
        if (this.maxIdle != null) {
            args.add(SearchCommandKeyword.MAXIDLE);
            args.add(this.maxIdle);
        }
    }

    public int hashCode() {
        return Objects.hash(this.count, this.maxIdle);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cursor other = (Cursor)obj;
        return Objects.equals(this.count, other.count) && Objects.equals(this.maxIdle, other.maxIdle);
    }
}

