/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandArgs;
import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.Language;
import com.redis.lettucemod.search.Order;
import com.redis.lettucemod.search.RediSearchArgument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SearchOptions<K, V>
implements RediSearchArgument<K, V> {
    private boolean noContent;
    private boolean verbatim;
    private boolean noStopWords;
    private boolean withScores;
    private boolean withPayloads;
    private boolean withSortKeys;
    private List<NumericFilter<K, V>> filters = new ArrayList<NumericFilter<K, V>>();
    private GeoFilter<K, V> geoFilter;
    private List<K> inKeys = new ArrayList<K>();
    private List<K> inFields = new ArrayList<K>();
    private List<K> returnFields = new ArrayList<K>();
    private Summarize<K, V> summarize;
    private Highlight<K, V> highlight;
    private Long slop;
    private boolean inOrder;
    private Language language;
    private String expander;
    private String scorer;
    private V payload;
    private SortBy<K> sortBy;
    private Limit limit;

    private SearchOptions(Builder<K, V> builder) {
        this.noContent = ((Builder)builder).noContent;
        this.verbatim = ((Builder)builder).verbatim;
        this.noStopWords = ((Builder)builder).noStopWords;
        this.withScores = ((Builder)builder).withScores;
        this.withPayloads = ((Builder)builder).withPayloads;
        this.withSortKeys = ((Builder)builder).withSortKeys;
        this.filters = ((Builder)builder).filters;
        this.geoFilter = ((Builder)builder).geoFilter;
        this.inKeys = ((Builder)builder).inKeys;
        this.inFields = ((Builder)builder).inFields;
        this.returnFields = ((Builder)builder).returnFields;
        this.summarize = ((Builder)builder).summarize;
        this.highlight = ((Builder)builder).highlight;
        this.slop = ((Builder)builder).slop;
        this.inOrder = ((Builder)builder).inOrder;
        this.language = ((Builder)builder).language;
        this.expander = ((Builder)builder).expander;
        this.scorer = ((Builder)builder).scorer;
        this.payload = ((Builder)builder).payload;
        this.sortBy = ((Builder)builder).sortBy;
        this.limit = ((Builder)builder).limit;
    }

    public boolean isNoContent() {
        return this.noContent;
    }

    public void setNoContent(boolean noContent) {
        this.noContent = noContent;
    }

    public boolean isVerbatim() {
        return this.verbatim;
    }

    public void setVerbatim(boolean verbatim) {
        this.verbatim = verbatim;
    }

    public boolean isNoStopWords() {
        return this.noStopWords;
    }

    public void setNoStopWords(boolean noStopWords) {
        this.noStopWords = noStopWords;
    }

    public boolean isWithScores() {
        return this.withScores;
    }

    public void setWithScores(boolean withScores) {
        this.withScores = withScores;
    }

    public boolean isWithPayloads() {
        return this.withPayloads;
    }

    public void setWithPayloads(boolean withPayloads) {
        this.withPayloads = withPayloads;
    }

    public boolean isWithSortKeys() {
        return this.withSortKeys;
    }

    public void setWithSortKeys(boolean withSortKeys) {
        this.withSortKeys = withSortKeys;
    }

    public List<NumericFilter<K, V>> getFilters() {
        return this.filters;
    }

    public void setFilters(List<NumericFilter<K, V>> filters) {
        this.filters = filters;
    }

    public GeoFilter<K, V> getGeoFilter() {
        return this.geoFilter;
    }

    public void setGeoFilter(GeoFilter<K, V> geoFilter) {
        this.geoFilter = geoFilter;
    }

    public List<K> getInKeys() {
        return this.inKeys;
    }

    public void setInKeys(List<K> inKeys) {
        this.inKeys = inKeys;
    }

    public List<K> getInFields() {
        return this.inFields;
    }

    public void setInFields(List<K> inFields) {
        this.inFields = inFields;
    }

    public List<K> getReturnFields() {
        return this.returnFields;
    }

    public void setReturnFields(List<K> returnFields) {
        this.returnFields = returnFields;
    }

    public Summarize<K, V> getSummarize() {
        return this.summarize;
    }

    public void setSummarize(Summarize<K, V> summarize) {
        this.summarize = summarize;
    }

    public Highlight<K, V> getHighlight() {
        return this.highlight;
    }

    public void setHighlight(Highlight<K, V> highlight) {
        this.highlight = highlight;
    }

    public Long getSlop() {
        return this.slop;
    }

    public void setSlop(Long slop) {
        this.slop = slop;
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    public void setInOrder(boolean inOrder) {
        this.inOrder = inOrder;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String getExpander() {
        return this.expander;
    }

    public void setExpander(String expander) {
        this.expander = expander;
    }

    public String getScorer() {
        return this.scorer;
    }

    public void setScorer(String scorer) {
        this.scorer = scorer;
    }

    public V getPayload() {
        return this.payload;
    }

    public void setPayload(V payload) {
        this.payload = payload;
    }

    public SortBy<K> getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(SortBy<K> sortBy) {
        this.sortBy = sortBy;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    @Override
    public void build(SearchCommandArgs<K, V> args) {
        if (this.noContent) {
            args.add(SearchCommandKeyword.NOCONTENT);
        }
        if (this.verbatim) {
            args.add(SearchCommandKeyword.VERBATIM);
        }
        if (this.noStopWords) {
            args.add(SearchCommandKeyword.NOSTOPWORDS);
        }
        if (this.withScores) {
            args.add(SearchCommandKeyword.WITHSCORES);
        }
        if (this.withPayloads) {
            args.add(SearchCommandKeyword.WITHPAYLOADS);
        }
        if (this.withSortKeys) {
            args.add(SearchCommandKeyword.WITHSORTKEYS);
        }
        for (NumericFilter<K, V> filter : this.filters) {
            args.add(SearchCommandKeyword.FILTER);
            filter.build(args);
        }
        if (this.geoFilter != null) {
            args.add(SearchCommandKeyword.GEOFILTER);
            this.geoFilter.build(args);
        }
        if (!this.inKeys.isEmpty()) {
            args.add(SearchCommandKeyword.INKEYS);
            args.add(this.inKeys.size());
            this.inKeys.forEach(args::addKey);
        }
        if (!this.inFields.isEmpty()) {
            args.add(SearchCommandKeyword.INFIELDS);
            args.add(this.inFields.size());
            this.inFields.forEach(args::addKey);
        }
        if (!this.returnFields.isEmpty()) {
            args.add(SearchCommandKeyword.RETURN);
            args.add(this.returnFields.size());
            this.returnFields.forEach(args::addKey);
        }
        if (this.summarize != null) {
            args.add(SearchCommandKeyword.SUMMARIZE);
            this.summarize.build(args);
        }
        if (this.highlight != null) {
            args.add(SearchCommandKeyword.HIGHLIGHT);
            this.highlight.build(args);
        }
        if (this.slop != null) {
            args.add(SearchCommandKeyword.SLOP);
            args.add(this.slop);
        }
        if (this.inOrder) {
            args.add(SearchCommandKeyword.INORDER);
        }
        if (this.language != null) {
            args.add(SearchCommandKeyword.LANGUAGE);
            args.add(this.language.getId());
        }
        if (this.expander != null) {
            args.add(SearchCommandKeyword.EXPANDER);
            args.add(this.expander);
        }
        if (this.scorer != null) {
            args.add(SearchCommandKeyword.SCORER);
            args.add(this.scorer);
        }
        if (this.payload != null) {
            args.add(SearchCommandKeyword.PAYLOAD);
            args.addValue((Object)this.payload);
        }
        if (this.sortBy != null) {
            args.add(SearchCommandKeyword.SORTBY);
            args.addKey((Object)this.sortBy.getField());
            args.add(this.sortBy.getDirection() == Order.ASC ? SearchCommandKeyword.ASC : SearchCommandKeyword.DESC);
        }
        if (this.limit != null) {
            this.limit.build((SearchCommandArgs)args);
        }
    }

    public static Limit limit(long offset, long num) {
        return new Limit(offset, num);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static final class Builder<K, V> {
        private boolean noContent;
        private boolean verbatim;
        private boolean noStopWords;
        private boolean withScores;
        private boolean withPayloads;
        private boolean withSortKeys;
        private List<NumericFilter<K, V>> filters = new ArrayList<NumericFilter<K, V>>();
        private GeoFilter<K, V> geoFilter;
        private List<K> inKeys = new ArrayList<K>();
        private List<K> inFields = new ArrayList<K>();
        private List<K> returnFields = new ArrayList<K>();
        private Summarize<K, V> summarize;
        private Highlight<K, V> highlight;
        private Long slop;
        private boolean inOrder;
        private Language language;
        private String expander;
        private String scorer;
        private V payload;
        private SortBy<K> sortBy;
        private Limit limit;

        private Builder() {
        }

        public Builder<K, V> noContent(boolean noContent) {
            this.noContent = noContent;
            return this;
        }

        public Builder<K, V> verbatim(boolean verbatim) {
            this.verbatim = verbatim;
            return this;
        }

        public Builder<K, V> noStopWords(boolean noStopWords) {
            this.noStopWords = noStopWords;
            return this;
        }

        public Builder<K, V> withScores(boolean withScores) {
            this.withScores = withScores;
            return this;
        }

        public Builder<K, V> withPayloads(boolean withPayloads) {
            this.withPayloads = withPayloads;
            return this;
        }

        public Builder<K, V> withSortKeys(boolean withSortKeys) {
            this.withSortKeys = withSortKeys;
            return this;
        }

        public Builder<K, V> filter(NumericFilter<K, V> filter) {
            this.filters.add(filter);
            return this;
        }

        public Builder<K, V> filters(NumericFilter<K, V> ... filters) {
            this.filters.addAll(Arrays.asList(filters));
            return this;
        }

        public Builder<K, V> geoFilter(GeoFilter<K, V> geoFilter) {
            this.geoFilter = geoFilter;
            return this;
        }

        public Builder<K, V> inKey(K inKey) {
            this.inKeys.add(inKey);
            return this;
        }

        public Builder<K, V> inKeys(K ... inKeys) {
            this.inKeys.addAll(Arrays.asList(inKeys));
            return this;
        }

        public Builder<K, V> inField(K inField) {
            this.inFields.add(inField);
            return this;
        }

        public Builder<K, V> inFields(K ... inFields) {
            this.inFields.addAll(Arrays.asList(inFields));
            return this;
        }

        public Builder<K, V> returnField(K returnField) {
            this.returnFields.add(returnField);
            return this;
        }

        public Builder<K, V> returnFields(K ... returnFields) {
            this.returnFields.addAll(Arrays.asList(returnFields));
            return this;
        }

        public Builder<K, V> summarize(Summarize<K, V> summarize) {
            this.summarize = summarize;
            return this;
        }

        public Builder<K, V> highlight(Highlight<K, V> highlight) {
            this.highlight = highlight;
            return this;
        }

        public Builder<K, V> slop(Long slop) {
            this.slop = slop;
            return this;
        }

        public Builder<K, V> inOrder(boolean inOrder) {
            this.inOrder = inOrder;
            return this;
        }

        public Builder<K, V> language(Language language) {
            this.language = language;
            return this;
        }

        public Builder<K, V> expander(String expander) {
            this.expander = expander;
            return this;
        }

        public Builder<K, V> scorer(String scorer) {
            this.scorer = scorer;
            return this;
        }

        public Builder<K, V> payload(V payload) {
            this.payload = payload;
            return this;
        }

        public Builder<K, V> sortBy(SortBy<K> sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder<K, V> limit(Limit limit) {
            this.limit = limit;
            return this;
        }

        public SearchOptions<K, V> build() {
            return new SearchOptions(this);
        }
    }

    public static class SortBy<K> {
        private final K field;
        private final Order direction;

        public SortBy(K field, Order direction) {
            this.field = field;
            this.direction = direction;
        }

        public K getField() {
            return this.field;
        }

        public Order getDirection() {
            return this.direction;
        }

        public static <K> SortBy<K> asc(K field) {
            return new SortBy<K>(field, Order.ASC);
        }

        public static <K> SortBy<K> desc(K field) {
            return new SortBy<K>(field, Order.DESC);
        }
    }

    public static class Summarize<K, V>
    implements RediSearchArgument<K, V> {
        private List<K> fields = new ArrayList<K>();
        private Long frags;
        private Long length;
        private V separator;

        public List<K> getFields() {
            return this.fields;
        }

        public void setFields(List<K> fields) {
            this.fields = fields;
        }

        public Long getFrags() {
            return this.frags;
        }

        public void setFrags(Long frags) {
            this.frags = frags;
        }

        public Long getLength() {
            return this.length;
        }

        public void setLength(Long length) {
            this.length = length;
        }

        public V getSeparator() {
            return this.separator;
        }

        public void setSeparator(V separator) {
            this.separator = separator;
        }

        @Override
        public void build(SearchCommandArgs<K, V> args) {
            if (!this.fields.isEmpty()) {
                args.add(SearchCommandKeyword.FIELDS);
                args.add(this.fields.size());
                this.fields.forEach(args::addKey);
            }
            if (this.frags != null) {
                args.add(SearchCommandKeyword.FRAGS);
                args.add(this.frags);
            }
            if (this.length != null) {
                args.add(SearchCommandKeyword.LEN);
                args.add(this.length);
            }
            if (this.separator != null) {
                args.add(SearchCommandKeyword.SEPARATOR);
                args.addValue((Object)this.separator);
            }
        }
    }

    public static class Highlight<K, V>
    implements RediSearchArgument<K, V> {
        private List<K> fields = new ArrayList<K>();
        private Tags<V> tags;

        private Highlight(Builder<K, V> builder) {
            this.fields = ((Builder)builder).fields;
            this.tags = ((Builder)builder).tags;
        }

        public static <K, V> Builder<K, V> builder() {
            return new Builder();
        }

        @Override
        public void build(SearchCommandArgs<K, V> args) {
            if (!this.fields.isEmpty()) {
                args.add(SearchCommandKeyword.FIELDS);
                args.add(this.fields.size());
                this.fields.forEach(args::addKey);
            }
            if (this.tags != null) {
                args.add(SearchCommandKeyword.TAGS);
                args.addValue((Object)this.tags.getOpen());
                args.addValue((Object)this.tags.getClose());
            }
        }

        public static class Tags<V> {
            private V open;
            private V close;

            public Tags(V open, V close) {
                this.open = open;
                this.close = close;
            }

            public V getOpen() {
                return this.open;
            }

            public void setOpen(V open) {
                this.open = open;
            }

            public V getClose() {
                return this.close;
            }

            public void setClose(V close) {
                this.close = close;
            }
        }

        public static class Builder<K, V> {
            private List<K> fields = new ArrayList<K>();
            private Tags<V> tags;

            public Builder<K, V> field(K field) {
                this.fields.add(field);
                return this;
            }

            public Builder<K, V> fields(K ... fields) {
                this.fields.addAll(Arrays.asList(fields));
                return this;
            }

            public Builder<K, V> tags(Tags<V> tags) {
                this.tags = tags;
                return this;
            }

            public Builder<K, V> tags(V open, V close) {
                this.tags = new Tags<V>(open, close);
                return this;
            }

            public Highlight<K, V> build() {
                return new Highlight(this);
            }
        }
    }

    public static class GeoFilter<K, V>
    implements RediSearchArgument<K, V> {
        private K field;
        private double longitude;
        private double latitude;
        private double radius;
        private String unit;

        public GeoFilter() {
        }

        public GeoFilter(K field, double longitude, double latitude, double radius, String unit) {
            this.field = field;
            this.longitude = longitude;
            this.latitude = latitude;
            this.radius = radius;
            this.unit = unit;
        }

        public K getField() {
            return this.field;
        }

        public void setField(K field) {
            this.field = field;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }

        public double getLatitude() {
            return this.latitude;
        }

        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        public double getRadius() {
            return this.radius;
        }

        public void setRadius(double radius) {
            this.radius = radius;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public void build(SearchCommandArgs<K, V> args) {
            args.addKey((Object)this.field);
            args.add(this.longitude);
            args.add(this.latitude);
            args.add(this.radius);
            args.add(this.unit);
        }

        public static <K, V> GeoFilterBuilder<K, V> field(K field) {
            return new GeoFilterBuilder(field);
        }

        public static class GeoFilterBuilder<K, V> {
            private final K field;
            private double longitude;
            private double latitude;
            private double radius;
            private String unit;

            public GeoFilterBuilder(K field) {
                this.field = field;
            }

            public GeoFilterBuilder<K, V> longitude(double longitude) {
                this.longitude = longitude;
                return this;
            }

            public GeoFilterBuilder<K, V> latitude(double latitude) {
                this.latitude = latitude;
                return this;
            }

            public GeoFilterBuilder<K, V> radius(double radius) {
                this.radius = radius;
                return this;
            }

            public GeoFilterBuilder<K, V> unit(String unit) {
                this.unit = unit;
                return this;
            }

            public GeoFilter<K, V> build() {
                return new GeoFilter(this.field, this.longitude, this.latitude, this.radius, this.unit);
            }
        }
    }

    public static class NumericFilter<K, V>
    implements RediSearchArgument<K, V> {
        private final K field;
        private final double min;
        private final double max;

        public NumericFilter(K field, double min, double max) {
            this.field = field;
            this.min = min;
            this.max = max;
        }

        @Override
        public void build(SearchCommandArgs<K, V> args) {
            args.addKey((Object)this.field);
            args.add(this.min);
            args.add(this.max);
        }

        public static <K, V> NumericFilterBuilder<K, V> field(K field) {
            return new NumericFilterBuilder(field);
        }

        public static class MinNumericFilterBuilder<K, V> {
            private final K field;
            private final double min;

            public MinNumericFilterBuilder(K field, double min) {
                this.field = field;
                this.min = min;
            }

            public NumericFilter<K, V> max(double max) {
                return new NumericFilter(this.field, this.min, max);
            }
        }

        public static class NumericFilterBuilder<K, V> {
            private final K field;

            public NumericFilterBuilder(K field) {
                this.field = field;
            }

            public MinNumericFilterBuilder<K, V> min(double min) {
                return new MinNumericFilterBuilder(this.field, min);
            }
        }
    }

    public static class Limit
    implements RediSearchArgument {
        private final long offset;
        private final long num;

        public Limit(long offset, long num) {
            this.offset = offset;
            this.num = num;
        }

        public static Limit of(long offset, long num) {
            return new Limit(offset, num);
        }

        public void build(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.LIMIT);
            args.add(this.offset);
            args.add(this.num);
        }
    }
}

