/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.timeseries;

import com.redis.lettucemod.protocol.TimeSeriesCommandKeyword;
import io.lettuce.core.CompositeArgument;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.LinkedHashMap;
import java.util.Map;

public class CreateOptions<K, V>
implements CompositeArgument {
    private Long retentionTime;
    private boolean uncompressed;
    private Long chunkSize;
    private DuplicatePolicy policy;
    private Map<K, V> labels = new LinkedHashMap();

    private CreateOptions(Builder<K, V> builder) {
        this.retentionTime = ((Builder)builder).retentionTime;
        this.uncompressed = ((Builder)builder).uncompressed;
        this.chunkSize = ((Builder)builder).chunkSize;
        this.policy = ((Builder)builder).policy;
        this.labels = ((Builder)builder).labels;
    }

    public <L, W> void build(CommandArgs<L, W> args) {
        if (this.retentionTime != null) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.RETENTION);
            args.add(this.retentionTime.longValue());
        }
        if (this.uncompressed) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.UNCOMPRESSED);
        }
        if (this.chunkSize != null) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.CHUNK_SIZE);
            args.add(this.chunkSize.longValue());
        }
        if (this.policy != null) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.ON_DUPLICATE);
            args.add(this.policy.name());
        }
        if (this.labels != null) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.LABELS);
            this.labels.forEach((k, v) -> args.addKey(k).addValue(v));
        }
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static final class Builder<K, V> {
        private Long retentionTime;
        private boolean uncompressed;
        private Long chunkSize;
        private DuplicatePolicy policy;
        private Map<K, V> labels = new LinkedHashMap();

        private Builder() {
        }

        public Builder<K, V> retentionTime(long retentionTime) {
            this.retentionTime = retentionTime;
            return this;
        }

        public Builder<K, V> uncompressed(boolean uncompressed) {
            this.uncompressed = uncompressed;
            return this;
        }

        public Builder<K, V> chunkSize(long chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public Builder<K, V> policy(DuplicatePolicy policy) {
            this.policy = policy;
            return this;
        }

        public Builder<K, V> label(K key, V value) {
            this.labels.put(key, value);
            return this;
        }

        public Builder<K, V> labels(Map<K, V> labels) {
            this.labels = labels;
            return this;
        }

        public CreateOptions<K, V> build() {
            return new CreateOptions(this);
        }
    }

    public static enum DuplicatePolicy {
        BLOCK,
        FIRST,
        LAST,
        MIN,
        MAX,
        SUM;

    }
}

