/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod;

import com.redis.lettucemod.api.StatefulRedisModulesConnection;
import com.redis.lettucemod.api.reactive.RedisModulesReactiveCommands;
import com.redis.lettucemod.gears.Execution;
import com.redis.lettucemod.gears.ExecutionDetails;
import com.redis.lettucemod.gears.ExecutionMode;
import com.redis.lettucemod.gears.RedisGearsCommandBuilder;
import com.redis.lettucemod.gears.Registration;
import com.redis.lettucemod.json.GetOptions;
import com.redis.lettucemod.json.RedisJSONCommandBuilder;
import com.redis.lettucemod.json.SetMode;
import com.redis.lettucemod.output.ExecutionResults;
import com.redis.lettucemod.search.AggregateOptions;
import com.redis.lettucemod.search.AggregateResults;
import com.redis.lettucemod.search.AggregateWithCursorResults;
import com.redis.lettucemod.search.CursorOptions;
import com.redis.lettucemod.search.Field;
import com.redis.lettucemod.search.RediSearchCommandBuilder;
import com.redis.lettucemod.search.SearchOptions;
import com.redis.lettucemod.search.SearchResults;
import com.redis.lettucemod.search.Suggestion;
import com.redis.lettucemod.search.SuggetOptions;
import com.redis.lettucemod.timeseries.Aggregation;
import com.redis.lettucemod.timeseries.CreateOptions;
import com.redis.lettucemod.timeseries.GetResult;
import com.redis.lettucemod.timeseries.KeySample;
import com.redis.lettucemod.timeseries.RangeOptions;
import com.redis.lettucemod.timeseries.RangeResult;
import com.redis.lettucemod.timeseries.RedisTimeSeriesCommandBuilder;
import com.redis.lettucemod.timeseries.Sample;
import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisReactiveCommandsImpl;
import io.lettuce.core.codec.RedisCodec;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedisModulesReactiveCommandsImpl<K, V>
extends RedisReactiveCommandsImpl<K, V>
implements RedisModulesReactiveCommands<K, V> {
    private final StatefulRedisModulesConnection<K, V> connection;
    private final RedisTimeSeriesCommandBuilder<K, V> timeSeriesCommandBuilder;
    private final RedisGearsCommandBuilder<K, V> gearsCommandBuilder;
    private final RediSearchCommandBuilder<K, V> searchCommandBuilder;
    private final RedisJSONCommandBuilder<K, V> jsonCommandBuilder;

    public RedisModulesReactiveCommandsImpl(StatefulRedisModulesConnection<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
        this.connection = connection;
        this.gearsCommandBuilder = new RedisGearsCommandBuilder<K, V>(codec);
        this.timeSeriesCommandBuilder = new RedisTimeSeriesCommandBuilder<K, V>(codec);
        this.searchCommandBuilder = new RediSearchCommandBuilder<K, V>(codec);
        this.jsonCommandBuilder = new RedisJSONCommandBuilder<K, V>(codec);
    }

    @Override
    public StatefulRedisModulesConnection<K, V> getStatefulConnection() {
        return this.connection;
    }

    @Override
    public Mono<ExecutionResults> pyexecute(String function, V ... requirements) {
        return this.createMono(() -> this.gearsCommandBuilder.pyExecute(function, requirements));
    }

    @Override
    public Mono<String> pyexecuteUnblocking(String function, V ... requirements) {
        return this.createMono(() -> this.gearsCommandBuilder.pyExecuteUnblocking(function, requirements));
    }

    @Override
    public Flux<Object> trigger(String trigger, V ... args) {
        return this.createDissolvingFlux(() -> this.gearsCommandBuilder.trigger(trigger, args));
    }

    @Override
    public Mono<String> unregister(String id) {
        return this.createMono(() -> this.gearsCommandBuilder.unregister(id));
    }

    @Override
    public Mono<String> abortexecution(String id) {
        return this.createMono(() -> this.gearsCommandBuilder.abortExecution(id));
    }

    @Override
    public Flux<V> configget(K ... keys) {
        return this.createDissolvingFlux(() -> this.gearsCommandBuilder.configGet(keys));
    }

    @Override
    public Flux<V> configset(Map<K, V> map) {
        return this.createDissolvingFlux(() -> this.gearsCommandBuilder.configSet(map));
    }

    @Override
    public Mono<String> dropexecution(String id) {
        return this.createMono(() -> this.gearsCommandBuilder.dropExecution(id));
    }

    @Override
    public Flux<Execution> dumpexecutions() {
        return this.createDissolvingFlux(this.gearsCommandBuilder::dumpExecutions);
    }

    @Override
    public Flux<Registration> dumpregistrations() {
        return this.createDissolvingFlux(this.gearsCommandBuilder::dumpRegistrations);
    }

    @Override
    public Mono<ExecutionDetails> getexecution(String id) {
        return this.createMono(() -> this.gearsCommandBuilder.getExecution(id));
    }

    @Override
    public Mono<ExecutionDetails> getexecution(String id, ExecutionMode mode) {
        return this.createMono(() -> this.gearsCommandBuilder.getExecution(id, mode));
    }

    @Override
    public Mono<ExecutionResults> getresults(String id) {
        return this.createMono(() -> this.gearsCommandBuilder.getResults(id));
    }

    @Override
    public Mono<ExecutionResults> getresultsBlocking(String id) {
        return this.createMono(() -> this.gearsCommandBuilder.getResultsBlocking(id));
    }

    @Override
    public Mono<String> create(K key, CreateOptions<K, V> options) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.create(key, options));
    }

    @Override
    public Mono<String> alter(K key, CreateOptions<K, V> options) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.alter(key, options));
    }

    @Override
    public Mono<Long> add(K key, long timestamp, double value) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.add(key, timestamp, value));
    }

    @Override
    public Mono<Long> add(K key, long timestamp, double value, CreateOptions<K, V> options) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.add(key, timestamp, value, options));
    }

    @Override
    public Mono<Long> addAutoTimestamp(K key, double value) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.addAutoTimestamp(key, value));
    }

    @Override
    public Mono<Long> addAutoTimestamp(K key, double value, CreateOptions<K, V> options) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.addAutoTimestamp(key, value, options));
    }

    @Override
    public Mono<Long> add(K key, Sample sample) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.add(key, sample));
    }

    @Override
    public Mono<Long> add(K key, Sample sample, CreateOptions<K, V> options) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.add(key, sample, options));
    }

    @Override
    public Mono<Long> incrby(K key, double value, Long timestamp, CreateOptions<K, V> options) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.incrby(key, value, timestamp, options));
    }

    @Override
    public Mono<Long> decrby(K key, double value, Long timestamp, CreateOptions<K, V> options) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.decrby(key, value, timestamp, options));
    }

    @Override
    public Mono<Long> incrbyAutoTimestamp(K key, double value, CreateOptions<K, V> options) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.incrbyAutoTimestamp(key, value, options));
    }

    @Override
    public Mono<Long> decrbyAutoTimestamp(K key, double value, CreateOptions<K, V> options) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.decrbyAutoTimestamp(key, value, options));
    }

    @Override
    public Flux<Long> madd(KeySample<K> ... samples) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.madd(samples));
    }

    @Override
    public Mono<String> createrule(K sourceKey, K destKey, Aggregation aggregation) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.createRule(sourceKey, destKey, aggregation));
    }

    @Override
    public Mono<String> deleterule(K sourceKey, K destKey) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.deleteRule(sourceKey, destKey));
    }

    @Override
    public Flux<Sample> range(K key, RangeOptions options) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.range(key, options));
    }

    @Override
    public Flux<Sample> revrange(K key, RangeOptions options) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.revrange(key, options));
    }

    @Override
    public Flux<RangeResult<K, V>> mrange(RangeOptions options, V ... filters) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.mrange(options, filters));
    }

    @Override
    public Flux<RangeResult<K, V>> mrevrange(RangeOptions options, V ... filters) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.mrevrange(options, filters));
    }

    @Override
    public Flux<RangeResult<K, V>> mrangeWithLabels(RangeOptions options, V ... filters) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.mrangeWithLabels(options, filters));
    }

    @Override
    public Flux<RangeResult<K, V>> mrevrangeWithLabels(RangeOptions options, V ... filters) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.mrevrangeWithLabels(options, filters));
    }

    @Override
    public Mono<Sample> tsGet(K key) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.get(key));
    }

    @Override
    public Flux<GetResult<K, V>> tsMget(V ... filters) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.mget(false, filters));
    }

    @Override
    public Flux<GetResult<K, V>> tsMgetWithLabels(V ... filters) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.mget(true, filters));
    }

    @Override
    public Flux<Object> tsInfo(K key) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.info(key, false));
    }

    @Override
    public Flux<Object> tsInfoDebug(K key) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.info(key, true));
    }

    @Override
    public Mono<String> create(K index, Field ... fields) {
        return this.create(index, (com.redis.lettucemod.search.CreateOptions<K, V>)null, fields);
    }

    @Override
    public Mono<String> create(K index, com.redis.lettucemod.search.CreateOptions<K, V> options, Field ... fields) {
        return this.createMono(() -> this.searchCommandBuilder.create(index, options, fields));
    }

    @Override
    public Mono<String> dropindex(K index) {
        return this.createMono(() -> this.searchCommandBuilder.dropIndex(index, false));
    }

    @Override
    public Mono<String> dropindexDeleteDocs(K index) {
        return this.createMono(() -> this.searchCommandBuilder.dropIndex(index, true));
    }

    @Override
    public Flux<Object> indexInfo(K index) {
        return this.createDissolvingFlux(() -> this.searchCommandBuilder.info(index));
    }

    @Override
    public Mono<SearchResults<K, V>> search(K index, V query) {
        return this.createMono(() -> this.searchCommandBuilder.search(index, query, null));
    }

    @Override
    public Mono<SearchResults<K, V>> search(K index, V query, SearchOptions<K, V> options) {
        return this.createMono(() -> this.searchCommandBuilder.search(index, query, options));
    }

    @Override
    public Mono<AggregateResults<K>> aggregate(K index, V query) {
        return this.createMono(() -> this.searchCommandBuilder.aggregate(index, query, null));
    }

    @Override
    public Mono<AggregateResults<K>> aggregate(K index, V query, AggregateOptions<K, V> options) {
        return this.createMono(() -> this.searchCommandBuilder.aggregate(index, query, options));
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> aggregate(K index, V query, CursorOptions cursor) {
        return this.createMono(() -> this.searchCommandBuilder.aggregate(index, query, cursor, null));
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> aggregate(K index, V query, CursorOptions cursor, AggregateOptions<K, V> options) {
        return this.createMono(() -> this.searchCommandBuilder.aggregate(index, query, cursor, options));
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> cursorRead(K index, long cursor) {
        return this.createMono(() -> this.searchCommandBuilder.cursorRead(index, cursor, null));
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> cursorRead(K index, long cursor, long count) {
        return this.createMono(() -> this.searchCommandBuilder.cursorRead(index, cursor, count));
    }

    @Override
    public Mono<String> cursorDelete(K index, long cursor) {
        return this.createMono(() -> this.searchCommandBuilder.cursorDelete(index, cursor));
    }

    @Override
    public Mono<Long> sugadd(K key, V string, double score) {
        return this.createMono(() -> this.searchCommandBuilder.sugadd(key, string, score));
    }

    @Override
    public Mono<Long> sugaddIncr(K key, V string, double score) {
        return this.createMono(() -> this.searchCommandBuilder.sugaddIncr(key, string, score));
    }

    @Override
    public Mono<Long> sugadd(K key, V string, double score, V payload) {
        return this.createMono(() -> this.searchCommandBuilder.sugadd(key, string, score, payload));
    }

    @Override
    public Mono<Long> sugaddIncr(K key, V string, double score, V payload) {
        return this.createMono(() -> this.searchCommandBuilder.sugaddIncr(key, string, score, payload));
    }

    @Override
    public Mono<Long> sugadd(K key, Suggestion<V> suggestion) {
        return this.createMono(() -> this.searchCommandBuilder.sugadd(key, suggestion));
    }

    @Override
    public Mono<Long> sugaddIncr(K key, Suggestion<V> suggestion) {
        return this.createMono(() -> this.searchCommandBuilder.sugaddIncr(key, suggestion));
    }

    @Override
    public Flux<Suggestion<V>> sugget(K key, V prefix) {
        return this.createDissolvingFlux(() -> this.searchCommandBuilder.sugget(key, prefix));
    }

    @Override
    public Flux<Suggestion<V>> sugget(K key, V prefix, SuggetOptions options) {
        return this.createDissolvingFlux(() -> this.searchCommandBuilder.sugget(key, prefix, options));
    }

    @Override
    public Mono<Boolean> sugdel(K key, V string) {
        return this.createMono(() -> this.searchCommandBuilder.sugdel(key, string));
    }

    @Override
    public Mono<Long> suglen(K key) {
        return this.createMono(() -> this.searchCommandBuilder.suglen(key));
    }

    @Override
    public Mono<String> alter(K index, Field field) {
        return this.createMono(() -> this.searchCommandBuilder.alter(index, field));
    }

    @Override
    public Mono<String> aliasadd(K name, K index) {
        return this.createMono(() -> this.searchCommandBuilder.aliasAdd(name, index));
    }

    @Override
    public Mono<String> aliasupdate(K name, K index) {
        return this.createMono(() -> this.searchCommandBuilder.aliasUpdate(name, index));
    }

    @Override
    public Mono<String> aliasdel(K name) {
        return this.createMono(() -> this.searchCommandBuilder.aliasDel(name));
    }

    @Override
    public Flux<K> list() {
        return this.createDissolvingFlux(this.searchCommandBuilder::list);
    }

    @Override
    public Flux<V> tagvals(K index, K field) {
        return this.createDissolvingFlux(() -> this.searchCommandBuilder.tagVals(index, field));
    }

    @Override
    public Mono<Long> dictadd(K dict, V ... terms) {
        return this.createMono(() -> this.searchCommandBuilder.dictadd(dict, terms));
    }

    @Override
    public Mono<Long> dictdel(K dict, V ... terms) {
        return this.createMono(() -> this.searchCommandBuilder.dictdel(dict, terms));
    }

    @Override
    public Flux<V> dictdump(K dict) {
        return this.createDissolvingFlux(() -> this.searchCommandBuilder.dictdump(dict));
    }

    @Override
    public Mono<Long> jsonDel(K key) {
        return this.jsonDel(key, null);
    }

    @Override
    public Mono<Long> jsonDel(K key, K path) {
        return this.createMono(() -> this.jsonCommandBuilder.del(key, path));
    }

    @Override
    public Mono<V> jsonGet(K key, K ... paths) {
        return this.jsonGet(key, null, paths);
    }

    @Override
    public Mono<V> jsonGet(K key, GetOptions options, K ... paths) {
        return this.createMono(() -> this.jsonCommandBuilder.get(key, options, paths));
    }

    @Override
    public Flux<KeyValue<K, V>> jsonMget(K path, K ... keys) {
        return this.createDissolvingFlux(() -> this.jsonCommandBuilder.mget(path, keys));
    }

    public Flux<KeyValue<K, V>> mget(K path, Iterable<K> keys) {
        return this.createDissolvingFlux(() -> this.jsonCommandBuilder.mgetKeyValue(path, keys));
    }

    @Override
    public Mono<String> jsonSet(K key, K path, V json) {
        return this.jsonSet(key, path, json, null);
    }

    @Override
    public Mono<String> jsonSet(K key, K path, V json, SetMode mode) {
        return this.createMono(() -> this.jsonCommandBuilder.set(key, path, json, mode));
    }

    @Override
    public Mono<String> jsonType(K key) {
        return this.jsonType(key, null);
    }

    @Override
    public Mono<String> jsonType(K key, K path) {
        return this.createMono(() -> this.jsonCommandBuilder.type(key, path));
    }

    @Override
    public Mono<V> numincrby(K key, K path, double number) {
        return this.createMono(() -> this.jsonCommandBuilder.numIncrBy(key, path, number));
    }

    @Override
    public Mono<V> nummultby(K key, K path, double number) {
        return this.createMono(() -> this.jsonCommandBuilder.numMultBy(key, path, number));
    }

    @Override
    public Mono<Long> strappend(K key, V json) {
        return this.strappend(key, null, json);
    }

    @Override
    public Mono<Long> strappend(K key, K path, V json) {
        return this.createMono(() -> this.jsonCommandBuilder.strAppend(key, path, json));
    }

    @Override
    public Mono<Long> strlen(K key, K path) {
        return this.createMono(() -> this.jsonCommandBuilder.strLen(key, path));
    }

    @Override
    public Mono<Long> arrappend(K key, K path, V ... jsons) {
        return this.createMono(() -> this.jsonCommandBuilder.arrAppend(key, path, jsons));
    }

    @Override
    public Mono<Long> arrindex(K key, K path, V scalar) {
        return this.createMono(() -> this.jsonCommandBuilder.arrIndex(key, path, scalar, null, null));
    }

    @Override
    public Mono<Long> arrindex(K key, K path, V scalar, long start) {
        return this.createMono(() -> this.jsonCommandBuilder.arrIndex(key, path, scalar, start, null));
    }

    @Override
    public Mono<Long> arrindex(K key, K path, V scalar, long start, long stop) {
        return this.createMono(() -> this.jsonCommandBuilder.arrIndex(key, path, scalar, start, stop));
    }

    @Override
    public Mono<Long> arrinsert(K key, K path, long index, V ... jsons) {
        return this.createMono(() -> this.jsonCommandBuilder.arrInsert(key, path, index, jsons));
    }

    @Override
    public Mono<Long> arrlen(K key) {
        return this.arrlen(key, null);
    }

    @Override
    public Mono<Long> arrlen(K key, K path) {
        return this.createMono(() -> this.jsonCommandBuilder.arrLen(key, path));
    }

    @Override
    public Mono<V> arrpop(K key) {
        return this.arrpop(key, null);
    }

    @Override
    public Mono<V> arrpop(K key, K path) {
        return this.createMono(() -> this.jsonCommandBuilder.arrPop(key, path, null));
    }

    @Override
    public Mono<V> arrpop(K key, K path, long index) {
        return this.createMono(() -> this.jsonCommandBuilder.arrPop(key, path, index));
    }

    @Override
    public Mono<Long> arrtrim(K key, K path, long start, long stop) {
        return this.createMono(() -> this.jsonCommandBuilder.arrTrim(key, path, start, stop));
    }

    @Override
    public Flux<K> objkeys(K key) {
        return this.objkeys(key, null);
    }

    @Override
    public Flux<K> objkeys(K key, K path) {
        return this.createDissolvingFlux(() -> this.jsonCommandBuilder.objKeys(key, path));
    }

    @Override
    public Mono<Long> objlen(K key) {
        return this.objlen(key, null);
    }

    @Override
    public Mono<Long> objlen(K key, K path) {
        return this.createMono(() -> this.jsonCommandBuilder.objLen(key, path));
    }
}

