/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandArgs;
import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.As;
import com.redis.lettucemod.search.RediSearchArgument;
import io.lettuce.core.internal.LettuceAssert;
import java.util.Optional;
import java.util.OptionalDouble;

public abstract class Field
implements RediSearchArgument {
    private final Type type;
    private final String name;
    protected Optional<As> as = Optional.empty();
    protected boolean sortable;
    protected boolean unNormalizedForm;
    protected boolean noIndex;

    protected Field(Type type, String name) {
        LettuceAssert.notNull((Object)((Object)type), (String)"A type is required");
        LettuceAssert.notNull((Object)name, (String)"A name is required");
        this.type = type;
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getAs() {
        return this.as.map(As::getField);
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public boolean isUnNormalizedForm() {
        return this.unNormalizedForm;
    }

    public void setUnNormalizedForm(boolean unNormalizedForm) {
        this.unNormalizedForm = unNormalizedForm;
    }

    public boolean isNoIndex() {
        return this.noIndex;
    }

    public void setNoIndex(boolean noIndex) {
        this.noIndex = noIndex;
    }

    public void build(SearchCommandArgs args) {
        args.add(this.name);
        this.as.ifPresent(a -> a.build(args));
        this.buildField(args);
        if (this.sortable) {
            args.add(SearchCommandKeyword.SORTABLE);
            if (this.unNormalizedForm) {
                args.add(SearchCommandKeyword.UNF);
            }
        }
        if (this.noIndex) {
            args.add(SearchCommandKeyword.NOINDEX);
        }
    }

    protected abstract void buildField(SearchCommandArgs var1);

    public static TextField.Builder text(String name) {
        return TextField.builder(name);
    }

    public static GeoField.Builder geo(String name) {
        return GeoField.builder(name);
    }

    public static TagField.Builder tag(String name) {
        return TagField.builder(name);
    }

    public static NumericField.Builder numeric(String name) {
        return NumericField.builder(name);
    }

    public static enum Type {
        TEXT,
        NUMERIC,
        GEO,
        TAG;

    }

    public static class TextField
    extends Field {
        private OptionalDouble weight = OptionalDouble.empty();
        private boolean noStem;
        private Optional<PhoneticMatcher> matcher = Optional.empty();

        public TextField(String name) {
            super(Type.TEXT, name);
        }

        public OptionalDouble getWeight() {
            return this.weight;
        }

        public void setWeight(Double weight) {
            this.weight = OptionalDouble.of(weight);
        }

        public boolean isNoStem() {
            return this.noStem;
        }

        public void setNoStem(boolean noStem) {
            this.noStem = noStem;
        }

        public Optional<PhoneticMatcher> getMatcher() {
            return this.matcher;
        }

        public void setMatcher(PhoneticMatcher matcher) {
            this.matcher = Optional.of(matcher);
        }

        @Override
        protected void buildField(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.TEXT);
            if (this.noStem) {
                args.add(SearchCommandKeyword.NOSTEM);
            }
            this.weight.ifPresent(w -> args.add(SearchCommandKeyword.WEIGHT).add(w));
            this.matcher.ifPresent(m -> args.add(SearchCommandKeyword.PHONETIC).add(m.getCode()));
        }

        public static Builder builder(String name) {
            return new Builder(name);
        }

        public static enum PhoneticMatcher {
            ENGLISH("dm:en"),
            FRENCH("dm:fr"),
            PORTUGUESE("dm:pt"),
            SPANISH("dm:es");

            private final String code;

            private PhoneticMatcher(String code) {
                this.code = code;
            }

            public String getCode() {
                return this.code;
            }
        }

        public static class Builder
        extends AbstractBuilder<TextField, Builder> {
            private boolean noStem;
            private OptionalDouble weight = OptionalDouble.empty();
            private Optional<PhoneticMatcher> matcher = Optional.empty();

            public Builder(String name) {
                super(name);
            }

            public Builder noStem() {
                this.noStem = true;
                return this;
            }

            public Builder weight(double weight) {
                this.weight = OptionalDouble.of(weight);
                return this;
            }

            public Builder matcher(PhoneticMatcher matcher) {
                this.matcher = Optional.of(matcher);
                return this;
            }

            @Override
            public TextField newField() {
                TextField field = new TextField(this.name);
                field.setNoStem(this.noStem);
                this.weight.ifPresent(field::setWeight);
                this.matcher.ifPresent(field::setMatcher);
                return field;
            }
        }
    }

    public static class TagField
    extends Field {
        private Optional<String> separator = Optional.empty();
        private boolean caseSensitive;

        public TagField(String name) {
            super(Type.TAG, name);
        }

        public Optional<String> getSeparator() {
            return this.separator;
        }

        public void setSeparator(String separator) {
            this.separator = Optional.of(separator);
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        @Override
        protected void buildField(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.TAG);
            this.separator.ifPresent(s -> args.add(SearchCommandKeyword.SEPARATOR).add((String)s));
            if (this.caseSensitive) {
                args.add(SearchCommandKeyword.CASESENSITIVE);
            }
        }

        public static Builder builder(String name) {
            return new Builder(name);
        }

        public static class Builder
        extends AbstractBuilder<TagField, Builder> {
            private Optional<String> separator = Optional.empty();
            private boolean caseSensitive;

            public Builder(String name) {
                super(name);
            }

            public Builder separator(String separator) {
                this.separator = Optional.of(separator);
                return this;
            }

            public Builder caseSensitive() {
                this.caseSensitive = true;
                return this;
            }

            @Override
            public TagField newField() {
                TagField field = new TagField(this.name);
                this.separator.ifPresent(field::setSeparator);
                field.setCaseSensitive(this.caseSensitive);
                return field;
            }
        }
    }

    public static class NumericField
    extends Field {
        public NumericField(String name) {
            super(Type.NUMERIC, name);
        }

        @Override
        protected void buildField(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.NUMERIC);
        }

        public static Builder builder(String name) {
            return new Builder(name);
        }

        public static class Builder
        extends AbstractBuilder<NumericField, Builder> {
            public Builder(String name) {
                super(name);
            }

            @Override
            public NumericField newField() {
                return new NumericField(this.name);
            }
        }
    }

    public static class GeoField
    extends Field {
        public GeoField(String name) {
            super(Type.GEO, name);
        }

        @Override
        protected void buildField(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.GEO);
        }

        public static Builder builder(String name) {
            return new Builder(name);
        }

        public static class Builder
        extends AbstractBuilder<GeoField, Builder> {
            public Builder(String name) {
                super(name);
            }

            @Override
            public GeoField newField() {
                return new GeoField(this.name);
            }
        }
    }

    protected static abstract class AbstractBuilder<F extends Field, B extends AbstractBuilder<F, B>> {
        protected final String name;
        private Optional<As> as = Optional.empty();
        private boolean sortable;
        private boolean unNormalizedForm;
        private boolean noIndex;

        protected AbstractBuilder(String name) {
            this.name = name;
        }

        public B as(String as) {
            this.as = Optional.of(new As(as));
            return (B)this;
        }

        public B sortable() {
            this.sortable = true;
            return (B)this;
        }

        public B unNormalizedForm() {
            this.sortable = true;
            this.unNormalizedForm = true;
            return (B)this;
        }

        public B noIndex() {
            this.noIndex = true;
            return (B)this;
        }

        protected abstract F newField();

        public F build() {
            F field = this.newField();
            ((Field)field).as = this.as;
            ((Field)field).sortable = this.sortable;
            ((Field)field).unNormalizedForm = this.unNormalizedForm;
            ((Field)field).noIndex = this.noIndex;
            return field;
        }
    }
}

