/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.timeseries;

import com.redis.lettucemod.protocol.TimeSeriesCommandKeyword;
import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;

public class CreateOptions<K, V>
implements CompositeArgument {
    private OptionalLong retentionTime = OptionalLong.empty();
    private boolean uncompressed;
    private OptionalLong chunkSize = OptionalLong.empty();
    private Optional<DuplicatePolicy> policy = Optional.empty();
    private final Map<K, V> labels;

    private CreateOptions(Builder<K, V> builder) {
        this.retentionTime = ((Builder)builder).retentionTime;
        this.uncompressed = ((Builder)builder).uncompressed;
        this.chunkSize = ((Builder)builder).chunkSize;
        this.policy = ((Builder)builder).policy;
        this.labels = ((Builder)builder).labels;
    }

    public <L, W> void build(CommandArgs<L, W> args) {
        this.retentionTime.ifPresent(t -> args.add((ProtocolKeyword)TimeSeriesCommandKeyword.RETENTION).add(t));
        if (this.uncompressed) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.UNCOMPRESSED);
        }
        this.chunkSize.ifPresent(s -> args.add((ProtocolKeyword)TimeSeriesCommandKeyword.CHUNK_SIZE).add(s));
        this.policy.ifPresent(p -> args.add((ProtocolKeyword)TimeSeriesCommandKeyword.ON_DUPLICATE).add(p.name()));
        if (!this.labels.isEmpty()) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.LABELS);
            this.labels.forEach((k, v) -> args.addKey(k).addValue(v));
        }
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static final class Builder<K, V> {
        private OptionalLong retentionTime = OptionalLong.empty();
        private boolean uncompressed;
        private OptionalLong chunkSize = OptionalLong.empty();
        private Optional<DuplicatePolicy> policy = Optional.empty();
        private Map<K, V> labels = new LinkedHashMap();

        private Builder() {
        }

        public Builder<K, V> retentionTime(long retentionTime) {
            this.retentionTime = OptionalLong.of(retentionTime);
            return this;
        }

        public Builder<K, V> uncompressed(boolean uncompressed) {
            this.uncompressed = uncompressed;
            return this;
        }

        public Builder<K, V> chunkSize(long chunkSize) {
            this.chunkSize = OptionalLong.of(chunkSize);
            return this;
        }

        public Builder<K, V> policy(DuplicatePolicy policy) {
            this.policy = Optional.of(policy);
            return this;
        }

        public Builder<K, V> label(K key, V value) {
            this.labels.put(key, value);
            return this;
        }

        public Builder<K, V> labels(Map<K, V> labels) {
            LettuceAssert.notNull(labels, (String)"Labels must not be null");
            this.labels = labels;
            return this;
        }

        public CreateOptions<K, V> build() {
            return new CreateOptions(this);
        }
    }

    public static enum DuplicatePolicy {
        BLOCK,
        FIRST,
        LAST,
        MIN,
        MAX,
        SUM;

    }
}

