/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.Language;
import com.redis.lettucemod.search.RediSearchArgument;
import com.redis.lettucemod.search.SearchCommandArgs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;

public class CreateOptions<K, V>
implements RediSearchArgument<K, V> {
    private Optional<DataType> on = Optional.empty();
    private final List<K> prefixes;
    private Optional<V> filter = Optional.empty();
    private Optional<Language> defaultLanguage = Optional.empty();
    private Optional<K> languageField = Optional.empty();
    private OptionalDouble defaultScore = OptionalDouble.empty();
    private Optional<K> scoreField = Optional.empty();
    private Optional<K> payloadField = Optional.empty();
    private boolean maxTextFields;
    private OptionalLong temporary = OptionalLong.empty();
    private boolean noOffsets;
    private boolean noHL;
    private boolean noFields;
    private boolean noFreqs;
    private boolean noItitialScan;
    private Optional<List<V>> stopWords = Optional.empty();

    private CreateOptions(Builder<K, V> builder) {
        this.on = ((Builder)builder).on;
        this.prefixes = ((Builder)builder).prefixes;
        this.filter = ((Builder)builder).filter;
        this.defaultLanguage = ((Builder)builder).defaultLanguage;
        this.languageField = ((Builder)builder).languageField;
        this.defaultScore = ((Builder)builder).defaultScore;
        this.scoreField = ((Builder)builder).scoreField;
        this.payloadField = ((Builder)builder).payloadField;
        this.maxTextFields = ((Builder)builder).maxTextFields;
        this.temporary = ((Builder)builder).temporary;
        this.noOffsets = ((Builder)builder).noOffsets;
        this.noHL = ((Builder)builder).noHL;
        this.noFields = ((Builder)builder).noFields;
        this.noFreqs = ((Builder)builder).noFreqs;
        this.noItitialScan = ((Builder)builder).noItitialScan;
        this.stopWords = ((Builder)builder).stopWords;
    }

    @Override
    public void build(SearchCommandArgs<K, V> args) {
        this.on.ifPresent(o -> args.add(SearchCommandKeyword.ON).add(o.name()));
        if (!this.prefixes.isEmpty()) {
            args.add(SearchCommandKeyword.PREFIX);
            args.add(this.prefixes.size());
            this.prefixes.forEach(args::addKey);
        }
        this.filter.ifPresent(f -> args.add(SearchCommandKeyword.FILTER).addValue(f));
        this.defaultLanguage.ifPresent(l -> args.add(SearchCommandKeyword.LANGUAGE).add(l.getId()));
        this.languageField.ifPresent(f -> args.add(SearchCommandKeyword.LANGUAGE_FIELD).addKey(f));
        this.defaultScore.ifPresent(s -> args.add(SearchCommandKeyword.SCORE).add(s));
        this.scoreField.ifPresent(f -> args.add(SearchCommandKeyword.SCORE_FIELD).addKey(f));
        this.payloadField.ifPresent(f -> args.add(SearchCommandKeyword.PAYLOAD_FIELD).addKey(f));
        if (this.maxTextFields) {
            args.add(SearchCommandKeyword.MAXTEXTFIELDS);
        }
        this.temporary.ifPresent(t -> args.add(SearchCommandKeyword.TEMPORARY).add(t));
        if (this.noOffsets) {
            args.add(SearchCommandKeyword.NOOFFSETS);
        }
        if (this.noHL) {
            args.add(SearchCommandKeyword.NOHL);
        }
        if (this.noFields) {
            args.add(SearchCommandKeyword.NOFIELDS);
        }
        if (this.noFreqs) {
            args.add(SearchCommandKeyword.NOFREQS);
        }
        if (this.noItitialScan) {
            args.add(SearchCommandKeyword.NOINITIALSCAN);
        }
        this.stopWords.ifPresent(w -> {
            args.add(SearchCommandKeyword.STOPWORDS).add(w.size());
            w.forEach(args::addValue);
        });
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static final class Builder<K, V> {
        private Optional<DataType> on = Optional.of(DataType.HASH);
        private final List<K> prefixes = new ArrayList<K>();
        private Optional<V> filter = Optional.empty();
        private Optional<Language> defaultLanguage = Optional.empty();
        private Optional<K> languageField = Optional.empty();
        private OptionalDouble defaultScore = OptionalDouble.empty();
        private Optional<K> scoreField = Optional.empty();
        private Optional<K> payloadField = Optional.empty();
        private boolean maxTextFields;
        private OptionalLong temporary = OptionalLong.empty();
        private boolean noOffsets;
        private boolean noHL;
        private boolean noFields;
        private boolean noFreqs;
        private boolean noItitialScan;
        private Optional<List<V>> stopWords = Optional.empty();

        public Builder<K, V> on(DataType on) {
            this.on = Optional.of(on);
            return this;
        }

        public Builder<K, V> prefix(K prefix) {
            this.prefixes.add(prefix);
            return this;
        }

        public Builder<K, V> prefixes(K ... prefixes) {
            this.prefixes.addAll(Arrays.asList(prefixes));
            return this;
        }

        public Builder<K, V> filter(V filter) {
            this.filter = Optional.of(filter);
            return this;
        }

        public Builder<K, V> defaultLanguage(Language defaultLanguage) {
            this.defaultLanguage = Optional.of(defaultLanguage);
            return this;
        }

        public Builder<K, V> languageField(K languageField) {
            this.languageField = Optional.of(languageField);
            return this;
        }

        public Builder<K, V> defaultScore(double defaultScore) {
            this.defaultScore = OptionalDouble.of(defaultScore);
            return this;
        }

        public Builder<K, V> scoreField(K scoreField) {
            this.scoreField = Optional.of(scoreField);
            return this;
        }

        public Builder<K, V> payloadField(K payloadField) {
            this.payloadField = Optional.of(payloadField);
            return this;
        }

        public Builder<K, V> maxTextFields(boolean maxTextFields) {
            this.maxTextFields = maxTextFields;
            return this;
        }

        public Builder<K, V> temporary(long temporary) {
            this.temporary = OptionalLong.of(temporary);
            return this;
        }

        public Builder<K, V> noOffsets(boolean noOffsets) {
            this.noOffsets = noOffsets;
            return this;
        }

        public Builder<K, V> noHL(boolean noHL) {
            this.noHL = noHL;
            return this;
        }

        public Builder<K, V> noFields(boolean noFields) {
            this.noFields = noFields;
            return this;
        }

        public Builder<K, V> noFreqs(boolean noFreqs) {
            this.noFreqs = noFreqs;
            return this;
        }

        public Builder<K, V> noItitialScan(boolean noItitialScan) {
            this.noItitialScan = noItitialScan;
            return this;
        }

        public Builder<K, V> stopWords(List<V> stopWords) {
            this.stopWords = Optional.of(stopWords);
            return this;
        }

        public CreateOptions<K, V> build() {
            return new CreateOptions(this);
        }
    }

    public static enum DataType {
        HASH,
        JSON;

    }
}

