/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.GeoField;
import com.redis.lettucemod.search.NumericField;
import com.redis.lettucemod.search.RediSearchArgument;
import com.redis.lettucemod.search.SearchCommandArgs;
import com.redis.lettucemod.search.TagField;
import com.redis.lettucemod.search.TextField;
import java.util.Optional;

public abstract class Field<K>
implements RediSearchArgument<K, Object> {
    private final Type type;
    private final K name;
    protected Optional<K> as = Optional.empty();
    protected boolean sortable;
    protected boolean unNormalizedForm;
    protected boolean noIndex;

    protected Field(Type type, Builder<K, ?> builder) {
        this.type = type;
        this.name = builder.name;
        this.as = ((Builder)builder).as;
        this.sortable = ((Builder)builder).sortable;
        this.unNormalizedForm = ((Builder)builder).unNormalizedForm;
        this.noIndex = ((Builder)builder).noIndex;
    }

    public Type getType() {
        return this.type;
    }

    public K getName() {
        return this.name;
    }

    public Optional<K> getAs() {
        return this.as;
    }

    public void setAs(K as) {
        this.as = Optional.of(as);
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public boolean isUnNormalizedForm() {
        return this.unNormalizedForm;
    }

    public void setUnNormalizedForm(boolean unNormalizedForm) {
        this.unNormalizedForm = unNormalizedForm;
    }

    public boolean isNoIndex() {
        return this.noIndex;
    }

    public void setNoIndex(boolean noIndex) {
        this.noIndex = noIndex;
    }

    @Override
    public void build(SearchCommandArgs<K, Object> args) {
        args.addKey((Object)this.name);
        this.as.ifPresent(a -> args.add(SearchCommandKeyword.AS).addKey(a));
        this.buildField(args);
        if (this.sortable) {
            args.add(SearchCommandKeyword.SORTABLE);
            if (this.unNormalizedForm) {
                args.add(SearchCommandKeyword.UNF);
            }
        }
        if (this.noIndex) {
            args.add(SearchCommandKeyword.NOINDEX);
        }
    }

    protected abstract void buildField(SearchCommandArgs<K, Object> var1);

    public static <K> TextField.Builder<K> text(K name) {
        return TextField.name(name);
    }

    public static <K> GeoField.Builder<K> geo(K name) {
        return GeoField.name(name);
    }

    public static <K> TagField.Builder<K> tag(K name) {
        return TagField.name(name);
    }

    public static <K> NumericField.Builder<K> numeric(K name) {
        return NumericField.name(name);
    }

    public static enum Type {
        TEXT,
        NUMERIC,
        GEO,
        TAG;

    }

    public static class Builder<K, B extends Builder<K, B>> {
        protected final K name;
        private Optional<K> as = Optional.empty();
        private boolean sortable;
        private boolean unNormalizedForm;
        private boolean noIndex;

        protected Builder(K name) {
            this.name = name;
        }

        public B as(K as) {
            this.as = Optional.of(as);
            return (B)this;
        }

        public B sortable() {
            this.sortable = true;
            return (B)this;
        }

        public B unNormalizedForm() {
            this.sortable = true;
            this.unNormalizedForm = true;
            return (B)this;
        }

        public B noIndex() {
            this.noIndex = true;
            return (B)this;
        }
    }
}

