/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.AggregateOperation;
import com.redis.lettucemod.search.Max;
import com.redis.lettucemod.search.Order;
import com.redis.lettucemod.search.RediSearchArgument;
import com.redis.lettucemod.search.SearchCommandArgs;
import io.lettuce.core.internal.LettuceAssert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Sort
implements AggregateOperation<Object, Object> {
    private final List<Property> properties;
    private final Optional<Max> max;

    private Sort(Builder builder) {
        this.properties = builder.properties;
        this.max = builder.max;
    }

    @Override
    public void build(SearchCommandArgs<Object, Object> args) {
        args.add(SearchCommandKeyword.SORTBY);
        args.add((long)this.properties.size() * 2L);
        for (Property property : this.properties) {
            property.build(args);
        }
        this.max.ifPresent(m -> m.build(args));
    }

    public String toString() {
        StringBuilder string = new StringBuilder("SORT [properties=").append(this.properties);
        this.max.ifPresent(m -> string.append(", max=").append(m));
        string.append("]");
        return string.toString();
    }

    public static Builder by(Property ... properties) {
        return new Builder(properties);
    }

    public static class Property
    implements RediSearchArgument<Object, Object> {
        private final String name;
        private final Order order;

        private Property(String name, Order order) {
            LettuceAssert.notNull((Object)name, (String)"Name is required");
            LettuceAssert.notNull((Object)((Object)order), (String)"Order is required");
            this.name = name;
            this.order = order;
        }

        public String toString() {
            return "Property [name=" + this.name + ", order=" + (Object)((Object)this.order) + "]";
        }

        public static Property of(String name, Order order) {
            return new Property(name, order);
        }

        public static Property asc(String name) {
            return new Property(name, Order.ASC);
        }

        public static Property desc(String name) {
            return new Property(name, Order.DESC);
        }

        @Override
        public void build(SearchCommandArgs<Object, Object> args) {
            args.addProperty(this.name);
            args.add(this.order.getKeyword());
        }
    }

    public static class Builder {
        private final List<Property> properties = new ArrayList<Property>();
        private Optional<Max> max = Optional.empty();

        public Builder(Property ... properties) {
            Collections.addAll(this.properties, properties);
        }

        public Builder by(Property property) {
            return this.by(property);
        }

        public Builder max(long max) {
            this.max = Optional.of(new Max(max));
            return this;
        }

        public Sort build() {
            return new Sort(this);
        }
    }
}

