/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.Max;
import com.redis.lettucemod.search.RediSearchArgument;
import com.redis.lettucemod.search.SearchCommandArgs;
import java.util.Optional;

public class SuggetOptions
implements RediSearchArgument<Object, Object> {
    private boolean fuzzy;
    private boolean withScores;
    private boolean withPayloads;
    private Optional<Max> max = Optional.empty();

    private SuggetOptions(Builder builder) {
        this.fuzzy = builder.fuzzy;
        this.withScores = builder.withScores;
        this.withPayloads = builder.withPayloads;
        this.max = builder.max;
    }

    public boolean isFuzzy() {
        return this.fuzzy;
    }

    public void setFuzzy(boolean fuzzy) {
        this.fuzzy = fuzzy;
    }

    public boolean isWithScores() {
        return this.withScores;
    }

    public void setWithScores(boolean withScores) {
        this.withScores = withScores;
    }

    public boolean isWithPayloads() {
        return this.withPayloads;
    }

    public void setWithPayloads(boolean withPayloads) {
        this.withPayloads = withPayloads;
    }

    public Optional<Max> getMax() {
        return this.max;
    }

    public void setMax(long max) {
        this.max = Optional.of(new Max(max));
    }

    @Override
    public void build(SearchCommandArgs<Object, Object> args) {
        if (this.fuzzy) {
            args.add(SearchCommandKeyword.FUZZY);
        }
        if (this.withScores) {
            args.add(SearchCommandKeyword.WITHSCORES);
        }
        if (this.withPayloads) {
            args.add(SearchCommandKeyword.WITHPAYLOADS);
        }
        this.max.ifPresent(m -> m.build(args));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean fuzzy;
        private boolean withScores;
        private boolean withPayloads;
        private Optional<Max> max = Optional.empty();

        private Builder() {
        }

        public Builder fuzzy(boolean fuzzy) {
            this.fuzzy = fuzzy;
            return this;
        }

        public Builder withScores(boolean withScores) {
            this.withScores = withScores;
            return this;
        }

        public Builder withPayloads(boolean withPayloads) {
            this.withPayloads = withPayloads;
            return this;
        }

        public Builder max(long max) {
            this.max = Optional.of(new Max(max));
            return this;
        }

        public SuggetOptions build() {
            return new SuggetOptions(this);
        }
    }
}

