/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.Field;
import com.redis.lettucemod.search.SearchCommandArgs;
import java.util.Optional;

public class TagField<K>
extends Field<K> {
    private Optional<String> separator = Optional.empty();
    private boolean caseSensitive;

    private TagField(Builder<K> builder) {
        super(Field.Type.TAG, builder);
        this.separator = ((Builder)builder).separator;
        this.caseSensitive = ((Builder)builder).caseSensitive;
    }

    public Optional<String> getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = Optional.of(separator);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    protected void buildField(SearchCommandArgs<K, Object> args) {
        args.add(SearchCommandKeyword.TAG);
        this.separator.ifPresent(s -> args.add(SearchCommandKeyword.SEPARATOR).add((String)s));
        if (this.caseSensitive) {
            args.add(SearchCommandKeyword.CASESENSITIVE);
        }
    }

    public static <K> Builder<K> name(K name) {
        return new Builder<K>(name);
    }

    public static class Builder<K>
    extends Field.Builder<K, Builder<K>> {
        private Optional<String> separator = Optional.empty();
        private boolean caseSensitive;

        public Builder(K name) {
            super(name);
        }

        public Builder<K> separator(String separator) {
            this.separator = Optional.of(separator);
            return this;
        }

        public Builder<K> caseSensitive() {
            this.caseSensitive = true;
            return this;
        }

        public TagField<K> build() {
            return new TagField(this);
        }
    }
}

