/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.timeseries;

import com.redis.lettucemod.protocol.TimeSeriesCommandKeyword;
import com.redis.lettucemod.timeseries.AbstractAddAlterCreateIncrbyOptions;
import com.redis.lettucemod.timeseries.TimeSeriesCommandBuilder;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.OptionalLong;

public class IncrbyOptions<K, V>
extends AbstractAddAlterCreateIncrbyOptions<K, V> {
    private final boolean uncompressed;
    private final OptionalLong timestamp;

    private IncrbyOptions(Builder<K, V> builder) {
        super(builder);
        this.uncompressed = ((Builder)builder).uncompressed;
        this.timestamp = ((Builder)builder).timestamp;
    }

    public <L, W> void build(CommandArgs<L, W> args) {
        this.timestamp.ifPresent(t -> TimeSeriesCommandBuilder.addTimestamp(args.add((ProtocolKeyword)TimeSeriesCommandKeyword.TIMESTAMP), t));
        this.buildRetentionPeriod(args);
        if (this.uncompressed) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.UNCOMPRESSED);
        }
        this.buildChunkSize(args);
        this.buildLabels(args);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static class Builder<K, V>
    extends AbstractAddAlterCreateIncrbyOptions.Builder<K, V, Builder<K, V>> {
        private OptionalLong timestamp = OptionalLong.empty();
        private boolean uncompressed;

        public IncrbyOptions<K, V> build() {
            return new IncrbyOptions(this);
        }

        public Builder<K, V> uncompressed(boolean uncompressed) {
            this.uncompressed = uncompressed;
            return this;
        }

        public Builder<K, V> timestamp(long timestamp) {
            this.timestamp = OptionalLong.of(timestamp);
            return this;
        }

        public Builder<K, V> autoTimestamp() {
            this.timestamp = OptionalLong.of(0L);
            return this;
        }
    }
}

