/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.timeseries;

import com.redis.lettucemod.protocol.TimeSeriesCommandKeyword;
import com.redis.lettucemod.timeseries.BaseRangeOptions;
import io.lettuce.core.CompositeArgument;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class MRangeOptions<K, V>
extends BaseRangeOptions {
    private final Optional<List<K>> withLabels;
    private final List<V> filters;
    private final Optional<GroupBy<K>> groupBy;

    private MRangeOptions(Builder<K, V> builder) {
        super(builder);
        this.withLabels = ((Builder)builder).withLabels;
        this.filters = ((Builder)builder).filters;
        this.groupBy = ((Builder)builder).groupBy;
    }

    public <L, W> void build(CommandArgs<L, W> args) {
        this.buildFilterByTimestamp(args);
        this.buildFilterByValue(args);
        this.withLabels.ifPresent(labels -> {
            if (labels.isEmpty()) {
                args.add((ProtocolKeyword)TimeSeriesCommandKeyword.WITHLABELS);
            } else {
                args.add((ProtocolKeyword)TimeSeriesCommandKeyword.SELECTED_LABELS);
                labels.forEach(l -> args.addKey(l));
            }
        });
        this.buildCount(args);
        this.buildAggregation(args);
        if (!this.filters.isEmpty()) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.FILTER);
            this.filters.forEach(f -> args.addValue(f));
        }
        this.groupBy.ifPresent(g -> g.build(args));
    }

    public static <K, V> Builder<K, V> filters(V ... filters) {
        return new Builder(filters);
    }

    public static class Builder<K, V>
    extends BaseRangeOptions.Builder<Builder<K, V>> {
        private Optional<List<K>> withLabels = Optional.empty();
        private List<V> filters = new ArrayList<V>();
        private Optional<GroupBy<K>> groupBy = Optional.empty();

        public Builder(V ... filters) {
            this.filters.addAll(Arrays.asList(filters));
        }

        public Builder<K, V> filters(V ... filters) {
            this.filters = Arrays.asList(filters);
            return this;
        }

        public Builder<K, V> withLabels() {
            this.withLabels = Optional.of(new ArrayList());
            return this;
        }

        public Builder<K, V> selectedLabels(K ... labels) {
            this.withLabels = Optional.of(Arrays.asList(labels));
            return this;
        }

        public Builder<K, V> groupBy(GroupBy<K> groupBy) {
            this.groupBy = Optional.of(groupBy);
            return this;
        }

        public MRangeOptions<K, V> build() {
            return new MRangeOptions(this);
        }
    }

    public static enum Reducer {
        SUM,
        MIN,
        MAX;

    }

    public static class GroupBy<K>
    implements CompositeArgument {
        private final K label;
        private final Reducer reducer;

        private GroupBy(K label, Reducer reducer) {
            this.label = label;
            this.reducer = reducer;
        }

        public <L, W> void build(CommandArgs<L, W> args) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.GROUPBY);
            args.addKey(this.label);
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.REDUCE);
            args.add(this.reducer.name());
        }

        public static <K> GroupBy<K> of(K label, Reducer reducer) {
            return new GroupBy<K>(label, reducer);
        }
    }
}

