/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.json;

import com.redis.lettucemod.protocol.JsonCommandKeyword;
import io.lettuce.core.CompositeArgument;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.Optional;

public class GetOptions
implements CompositeArgument {
    private Optional<String> indent = Optional.empty();
    private Optional<String> newline = Optional.empty();
    private Optional<String> space = Optional.empty();
    private boolean noEscape;

    public Optional<String> getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = Optional.of(indent);
    }

    public Optional<String> getNewline() {
        return this.newline;
    }

    public void setNewline(String newline) {
        this.newline = Optional.of(newline);
    }

    public Optional<String> getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = Optional.of(space);
    }

    public boolean isNoEscape() {
        return this.noEscape;
    }

    public void setNoEscape(boolean noEscape) {
        this.noEscape = noEscape;
    }

    public static GetOptionsBuilder builder() {
        return new GetOptionsBuilder();
    }

    public <K, V> void build(CommandArgs<K, V> args) {
        this.indent.ifPresent(i -> args.add((ProtocolKeyword)JsonCommandKeyword.INDENT).add(i));
        this.newline.ifPresent(l -> args.add((ProtocolKeyword)JsonCommandKeyword.NEWLINE).add(l));
        this.space.ifPresent(s -> args.add((ProtocolKeyword)JsonCommandKeyword.SPACE).add(s));
        if (this.noEscape) {
            args.add((ProtocolKeyword)JsonCommandKeyword.NOESCAPE);
        }
    }

    public static class GetOptionsBuilder {
        private String indent;
        private String newline;
        private String space;
        private boolean noEscape;

        public GetOptionsBuilder indent(String indent) {
            this.indent = indent;
            return this;
        }

        public GetOptionsBuilder newline(String newline) {
            this.newline = newline;
            return this;
        }

        public GetOptionsBuilder space(String space) {
            this.space = space;
            return this;
        }

        public GetOptionsBuilder noEscape(boolean noEscape) {
            this.noEscape = noEscape;
            return this;
        }

        public GetOptions build() {
            GetOptions options = new GetOptions();
            options.setIndent(this.indent);
            options.setNewline(this.newline);
            options.setSpace(this.space);
            options.setNoEscape(this.noEscape);
            return options;
        }
    }
}

