/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.output;

import com.redis.lettucemod.gears.Registration;
import com.redis.lettucemod.output.OutputFactory;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class RegistrationListOutput<K, V>
extends CommandOutput<K, V, List<Registration>>
implements StreamingOutput<Registration> {
    private static final String FIELD_NUM_TRIGGERED = "numTriggered";
    private static final String FIELD_ID = "id";
    private static final String FIELD_READER = "reader";
    private static final String FIELD_DESC = "desc";
    private static final String FIELD_REGISTRATION_DATA = "RegistrationData";
    private static final String FIELD_MODE = "mode";
    private static final String FIELD_LAST_ERROR = "lastError";
    private static final String FIELD_ARGS = "args";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_PD = "PD";
    private static final String FIELD_NUM_SUCCESS = "numSuccess";
    private static final String FIELD_NUM_FAILURES = "numFailures";
    private static final String FIELD_NUM_ABORTED = "numAborted";
    private static final String FIELD_LAST_RUN_DURATION = "lastRunDurationMS";
    private static final String FIELD_TOTAL_RUN_DURATION = "totalRunDurationMS";
    private static final String FIELD_AVG_RUN_DURATION = "avgRunDurationMS";
    private static final String FIELD_LAST_ESTIMATED_LAG = "lastEstimatedLagMS";
    private static final String FIELD_AVG_ESTIMATED_LAG = "avgEstimatedLagMS";
    private boolean initialized;
    private StreamingOutput.Subscriber<Registration> subscriber;
    private Registration registration;
    private String field;
    private int argSize;

    public RegistrationListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<Registration>)ListSubscriber.instance());
    }

    public void set(ByteBuffer bytes) {
        if (this.field == null) {
            this.field = this.decodeAscii(bytes);
            return;
        }
        if (FIELD_ID.equals(this.field)) {
            this.registration = new Registration();
            this.registration.setId(this.decodeAscii(bytes));
            this.field = null;
            return;
        }
        if (FIELD_READER.equals(this.field)) {
            this.registration.setReader(this.decodeAscii(bytes));
            this.field = null;
            return;
        }
        if (FIELD_DESC.equals(this.field)) {
            this.registration.setDescription(this.decodeAscii(bytes));
            this.field = null;
            return;
        }
        if (FIELD_REGISTRATION_DATA.equals(this.field)) {
            this.registration.setData(new Registration.Data());
            this.field = this.decodeAscii(bytes);
            return;
        }
        if (this.registration != null) {
            if (this.registration.getData() != null) {
                if (FIELD_MODE.equals(this.field)) {
                    this.registration.getData().setMode(this.decodeAscii(bytes));
                    this.field = null;
                    return;
                }
                if (FIELD_LAST_ERROR.equals(this.field)) {
                    this.registration.getData().setLastError(this.decodeAscii(bytes));
                    this.field = null;
                    return;
                }
                if (FIELD_ARGS.equals(this.field)) {
                    this.field = this.decodeAscii(bytes);
                    return;
                }
                if (this.registration.getData().getArgs() != null && this.registration.getData().getArgs().size() < this.argSize) {
                    this.registration.getData().getArgs().put(this.field, this.decodeAscii(bytes));
                    this.field = null;
                    return;
                }
                if (FIELD_STATUS.equals(this.field)) {
                    this.registration.getData().setStatus(this.decodeAscii(bytes));
                    this.field = null;
                    return;
                }
            }
            if (FIELD_PD.equals(this.field)) {
                this.registration.setPrivateData(this.decodeAscii(bytes));
                this.field = null;
                return;
            }
            this.subscriber.onNext((Collection)this.output, (Object)this.registration);
            this.registration = null;
            return;
        }
    }

    public void set(long integer) {
        if (this.registration != null && this.registration.getData() != null) {
            if (FIELD_NUM_TRIGGERED.equals(this.field)) {
                this.registration.getData().setNumTriggered(integer);
                this.field = null;
                return;
            }
            if (FIELD_NUM_SUCCESS.equals(this.field)) {
                this.registration.getData().setNumSuccess(integer);
                this.field = null;
                return;
            }
            if (FIELD_NUM_FAILURES.equals(this.field)) {
                this.registration.getData().setNumFailures(integer);
                this.field = null;
                return;
            }
            if (FIELD_NUM_ABORTED.equals(this.field)) {
                this.registration.getData().setNumAborted(integer);
                this.field = null;
                return;
            }
            if (FIELD_LAST_RUN_DURATION.equals(this.field)) {
                this.registration.getData().setLastRunDurationMS(integer);
                this.field = null;
                return;
            }
            if (FIELD_TOTAL_RUN_DURATION.equals(this.field)) {
                this.registration.getData().setLastRunDurationMS(integer);
                this.field = null;
                return;
            }
            if (FIELD_AVG_RUN_DURATION.equals(this.field)) {
                this.registration.getData().setAvgRunDurationMS(integer);
                this.field = null;
                return;
            }
            if (FIELD_LAST_ESTIMATED_LAG.equals(this.field)) {
                this.registration.getData().setLastEstimatedLagMS(integer);
                this.field = null;
                return;
            }
            if (FIELD_AVG_ESTIMATED_LAG.equals(this.field)) {
                this.registration.getData().setAvgEstimatedLagMS(integer);
                this.field = null;
                return;
            }
            if (this.registration.getData().getArgs() != null && this.registration.getData().getArgs().size() < this.argSize) {
                this.registration.getData().getArgs().put(this.field, integer);
                this.field = null;
                return;
            }
        }
    }

    public void set(double number) {
        if (this.registration != null && this.registration.getData() != null) {
            if (FIELD_LAST_RUN_DURATION.equals(this.field)) {
                this.registration.getData().setLastRunDurationMS(Math.round(number));
                this.field = null;
                return;
            }
            if (FIELD_TOTAL_RUN_DURATION.equals(this.field)) {
                this.registration.getData().setLastRunDurationMS(Math.round(number));
                this.field = null;
                return;
            }
            if (FIELD_AVG_RUN_DURATION.equals(this.field)) {
                this.registration.getData().setAvgRunDurationMS(Math.round(number));
                this.field = null;
                return;
            }
            if (FIELD_LAST_ESTIMATED_LAG.equals(this.field)) {
                this.registration.getData().setLastEstimatedLagMS(Math.round(number));
                this.field = null;
                return;
            }
            if (FIELD_AVG_ESTIMATED_LAG.equals(this.field)) {
                this.registration.getData().setAvgEstimatedLagMS(Math.round(number));
                this.field = null;
                return;
            }
            if (this.registration.getData().getArgs() != null && this.registration.getData().getArgs().size() < this.argSize) {
                this.registration.getData().getArgs().put(this.field, number);
                this.field = null;
                return;
            }
        }
    }

    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
            return;
        }
        if (FIELD_ARGS.equals(this.field) && this.registration != null && this.registration.getData() != null) {
            this.argSize = count / 2;
            this.registration.getData().setArgs(new HashMap<String, Object>(this.argSize));
        }
    }

    public void setSubscriber(StreamingOutput.Subscriber<Registration> subscriber) {
        this.subscriber = subscriber;
    }

    public StreamingOutput.Subscriber<Registration> getSubscriber() {
        return this.subscriber;
    }
}

