/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.timeseries;

import com.redis.lettucemod.protocol.TimeSeriesCommandKeyword;
import com.redis.lettucemod.timeseries.Label;
import io.lettuce.core.CompositeArgument;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalLong;

abstract class AbstractAddAlterCreateIncrbyOptions<K, V>
implements CompositeArgument {
    private final OptionalLong retentionPeriod;
    private final OptionalLong chunkSize;
    private final List<Label<K, V>> labels;

    protected AbstractAddAlterCreateIncrbyOptions(Builder<K, V, ?> builder) {
        this.retentionPeriod = ((Builder)builder).retentionTime;
        this.chunkSize = ((Builder)builder).chunkSize;
        this.labels = ((Builder)builder).labels;
    }

    protected <L, W> void buildRetentionPeriod(CommandArgs<L, W> args) {
        this.retentionPeriod.ifPresent(t -> args.add((ProtocolKeyword)TimeSeriesCommandKeyword.RETENTION).add(t));
    }

    protected <L, W> void buildChunkSize(CommandArgs<L, W> args) {
        this.chunkSize.ifPresent(s -> args.add((ProtocolKeyword)TimeSeriesCommandKeyword.CHUNK_SIZE).add(s));
    }

    protected <L, W> void buildLabels(CommandArgs<L, W> args) {
        if (!this.labels.isEmpty()) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.LABELS);
            this.labels.forEach(l -> args.addKey(l.getLabel()).addValue(l.getValue()));
        }
    }

    public static class Builder<K, V, B extends Builder<K, V, B>> {
        private OptionalLong retentionTime = OptionalLong.empty();
        private OptionalLong chunkSize = OptionalLong.empty();
        private List<Label<K, V>> labels = new ArrayList<Label<K, V>>();

        public B retentionPeriod(long retentionPeriod) {
            this.retentionTime = OptionalLong.of(retentionPeriod);
            return (B)this;
        }

        public B chunkSize(long chunkSize) {
            this.chunkSize = OptionalLong.of(chunkSize);
            return (B)this;
        }

        public B labels(Label<K, V> ... labels) {
            this.labels.addAll(Arrays.asList(labels));
            return (B)this;
        }
    }

    public static enum Encoding {
        COMPRESSED(TimeSeriesCommandKeyword.COMPRESSED),
        UNCOMPRESSED(TimeSeriesCommandKeyword.UNCOMPRESSED);

        private TimeSeriesCommandKeyword keyword;

        private Encoding(TimeSeriesCommandKeyword keyword) {
            this.keyword = keyword;
        }

        public TimeSeriesCommandKeyword getKeyword() {
            return this.keyword;
        }
    }
}

