/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.timeseries;

import com.redis.lettucemod.protocol.TimeSeriesCommandKeyword;
import com.redis.lettucemod.timeseries.Aggregator;
import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.time.Duration;
import java.util.Optional;

public class Aggregation
implements CompositeArgument {
    private final Optional<Align> align;
    private final Aggregator aggregator;
    private final Duration bucketDuration;
    private final Optional<BucketTimestamp> bucketTimestamp;
    private final boolean empty;

    private Aggregation(Builder builder) {
        this.align = builder.align;
        this.aggregator = builder.aggregator;
        this.bucketDuration = builder.bucketDuration;
        this.bucketTimestamp = builder.bucketTimestamp;
        this.empty = builder.empty;
    }

    public <K, V> void build(CommandArgs<K, V> args) {
        this.align.ifPresent(a -> a.build(args));
        this.aggregator.build(args);
        args.add(this.bucketDuration.toMillis());
        this.bucketTimestamp.ifPresent(bt -> bt.build(args));
        if (this.empty) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.EMPTY);
        }
    }

    public static BucketDurationBuilder aggregator(Aggregator aggregator) {
        return new BucketDurationBuilder(aggregator);
    }

    public static class Builder {
        private Optional<Align> align = Optional.empty();
        private final Aggregator aggregator;
        private final Duration bucketDuration;
        private Optional<BucketTimestamp> bucketTimestamp = Optional.empty();
        private boolean empty = false;

        private Builder(Aggregator aggregator, Duration bucketDuration) {
            this.aggregator = aggregator;
            this.bucketDuration = bucketDuration;
        }

        public Builder align(Align align) {
            this.align = Optional.of(align);
            return this;
        }

        public Builder bucketTimestamp(BucketTimestamp bt) {
            this.bucketTimestamp = Optional.of(bt);
            return this;
        }

        public Builder empty(boolean empty) {
            this.empty = empty;
            return this;
        }

        public Aggregation build() {
            return new Aggregation(this);
        }
    }

    public static class BucketDurationBuilder {
        private final Aggregator aggregator;

        public BucketDurationBuilder(Aggregator aggregator) {
            this.aggregator = aggregator;
        }

        public Builder bucketDuration(Duration duration) {
            LettuceAssert.notNull((Object)duration, (String)"Bucket duration must not be null");
            LettuceAssert.isTrue((!duration.isNegative() && !duration.isZero() ? 1 : 0) != 0, (String)"Bucket duration must be positive");
            return new Builder(this.aggregator, duration);
        }
    }

    public static enum BucketTimestamp implements CompositeArgument
    {
        LOW(TimeSeriesCommandKeyword.START),
        HIGH(TimeSeriesCommandKeyword.END),
        MID(TimeSeriesCommandKeyword.MID);

        private final TimeSeriesCommandKeyword keyword;

        private BucketTimestamp(TimeSeriesCommandKeyword keyword) {
            this.keyword = keyword;
        }

        public <K, V> void build(CommandArgs<K, V> args) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.BUCKETTIMESTAMP);
            args.add((ProtocolKeyword)this.keyword);
        }
    }

    public static class Align
    implements CompositeArgument {
        private static final Align START = new Align(0L);
        private static final Align END = new Align(0L);
        private final long value;

        private Align(long value) {
            this.value = value;
        }

        public static Align of(long timestamp) {
            return new Align(timestamp);
        }

        public static Align start() {
            return START;
        }

        public static Align end() {
            return END;
        }

        public <K, V> void build(CommandArgs<K, V> args) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.ALIGN);
            if (this == START) {
                args.add((ProtocolKeyword)TimeSeriesCommandKeyword.START);
            } else if (this == END) {
                args.add((ProtocolKeyword)TimeSeriesCommandKeyword.END);
            } else {
                args.add(this.value);
            }
        }
    }
}

