/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.AggregateOperation;
import com.redis.lettucemod.search.RediSearchArgument;
import com.redis.lettucemod.search.SearchCommandArgs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Stream;

public class AggregateOptions<K, V>
implements RediSearchArgument<K, V> {
    private static final Load LOAD_ALL = Load.identifier("*").build();
    private final List<AggregateOperation<K, V>> operations;
    private final List<Load> loads;
    private final boolean verbatim;
    private final OptionalLong timeout;

    private AggregateOptions(Builder<K, V> builder) {
        this.operations = ((Builder)builder).operations;
        this.loads = ((Builder)builder).loads;
        this.verbatim = ((Builder)builder).verbatim;
        this.timeout = ((Builder)builder).timeout;
    }

    @Override
    public void build(SearchCommandArgs<K, V> args) {
        if (this.verbatim) {
            args.add(SearchCommandKeyword.VERBATIM);
        }
        if (!this.loads.isEmpty()) {
            args.add(SearchCommandKeyword.LOAD);
            if (this.loads.size() == 1 && this.loads.get(0) == LOAD_ALL) {
                args.add(LOAD_ALL.identifier);
            } else {
                args.add(this.loads.stream().mapToInt(Load::getNargs).sum());
                this.loads.forEach(l -> l.build(args));
            }
        }
        this.operations.forEach(op -> op.build(args));
        this.timeout.ifPresent(t -> args.add(SearchCommandKeyword.TIMEOUT).add(t));
    }

    public String toString() {
        StringBuilder string = new StringBuilder("AggregateOptions [");
        string.append("operations=").append(this.operations);
        string.append(", loads=").append(this.loads);
        string.append(", verbatim=").append(this.verbatim);
        this.timeout.ifPresent(t -> string.append(", timeout=").append(t));
        string.append("]");
        return string.toString();
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> Builder<K, V> operation(AggregateOperation operation) {
        return new Builder(operation);
    }

    public static class Builder<K, V> {
        private final List<AggregateOperation<K, V>> operations = new ArrayList<AggregateOperation<K, V>>();
        private List<Load> loads = new ArrayList<Load>();
        private boolean verbatim;
        private OptionalLong timeout = OptionalLong.empty();

        private Builder() {
        }

        private Builder(AggregateOperation<K, V> operation) {
            this.operations.add(operation);
        }

        public Builder<K, V> operation(AggregateOperation operation) {
            this.operations.add(operation);
            return this;
        }

        public Builder<K, V> loadAll() {
            this.loads = Collections.singletonList(LOAD_ALL);
            return this;
        }

        public Builder<K, V> load(String identifier) {
            this.loads.add(Load.identifier(identifier).build());
            return this;
        }

        public Builder<K, V> loads(String ... identifiers) {
            Collections.addAll(this.loads, (Load[])Stream.of(identifiers).map(i -> Load.identifier(i).build()).toArray(Load[]::new));
            return this;
        }

        public Builder<K, V> load(Load load) {
            this.loads.add(load);
            return this;
        }

        public Builder<K, V> loads(Load ... loads) {
            Collections.addAll(this.loads, loads);
            return this;
        }

        public Builder<K, V> verbatim(boolean verbatim) {
            this.verbatim = verbatim;
            return this;
        }

        public Builder<K, V> timeout(long timeout) {
            this.timeout = OptionalLong.of(timeout);
            return this;
        }

        public AggregateOptions<K, V> build() {
            return new AggregateOptions(this);
        }
    }

    public static class Load
    implements RediSearchArgument<Object, Object> {
        private final String identifier;
        private final Optional<String> as;

        private Load(Builder builder) {
            this.identifier = builder.identifier;
            this.as = builder.as;
        }

        public int getNargs() {
            int nargs = 1;
            if (this.as.isPresent()) {
                nargs += 2;
            }
            return nargs;
        }

        public static Builder identifier(String identifier) {
            return new Builder(identifier);
        }

        @Override
        public void build(SearchCommandArgs<Object, Object> args) {
            args.add(this.identifier);
            this.as.ifPresent(a -> args.add(SearchCommandKeyword.AS).add((String)a));
        }

        public static class Builder {
            private final String identifier;
            private Optional<String> as = Optional.empty();

            public Builder(String identifier) {
                this.identifier = identifier;
            }

            public Builder as(String field) {
                this.as = Optional.of(field);
                return this;
            }

            public Load build() {
                return new Load(this);
            }
        }
    }
}

