/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.Language;
import com.redis.lettucemod.search.RediSearchArgument;
import com.redis.lettucemod.search.SearchCommandArgs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;

public class CreateOptions<K, V>
implements RediSearchArgument<K, V> {
    private Optional<DataType> on = Optional.empty();
    private final List<K> prefixes;
    private Optional<V> filter = Optional.empty();
    private Optional<Language> defaultLanguage = Optional.empty();
    private Optional<K> languageField = Optional.empty();
    private OptionalDouble defaultScore = OptionalDouble.empty();
    private Optional<K> scoreField = Optional.empty();
    private Optional<K> payloadField = Optional.empty();
    private boolean maxTextFields;
    private OptionalLong temporary = OptionalLong.empty();
    private boolean noOffsets;
    private boolean noHL;
    private boolean noFields;
    private boolean noFreqs;
    private boolean skipInitialScan;
    private Optional<List<V>> stopWords = Optional.empty();

    private CreateOptions(Builder<K, V> builder) {
        this.on = ((Builder)builder).on;
        this.prefixes = ((Builder)builder).prefixes;
        this.filter = ((Builder)builder).filter;
        this.defaultLanguage = ((Builder)builder).defaultLanguage;
        this.languageField = ((Builder)builder).languageField;
        this.defaultScore = ((Builder)builder).defaultScore;
        this.scoreField = ((Builder)builder).scoreField;
        this.payloadField = ((Builder)builder).payloadField;
        this.maxTextFields = ((Builder)builder).maxTextFields;
        this.temporary = ((Builder)builder).temporary;
        this.noOffsets = ((Builder)builder).noOffsets;
        this.noHL = ((Builder)builder).noHL;
        this.noFields = ((Builder)builder).noFields;
        this.noFreqs = ((Builder)builder).noFreqs;
        this.skipInitialScan = ((Builder)builder).skipInitialScan;
        this.stopWords = ((Builder)builder).stopWords;
    }

    @Override
    public void build(SearchCommandArgs<K, V> args) {
        this.on.ifPresent(o -> args.add(SearchCommandKeyword.ON).add(o.name()));
        if (!this.prefixes.isEmpty()) {
            args.add(SearchCommandKeyword.PREFIX);
            args.add(this.prefixes.size());
            this.prefixes.forEach(args::addKey);
        }
        this.filter.ifPresent(f -> args.add(SearchCommandKeyword.FILTER).addValue(f));
        this.defaultLanguage.ifPresent(l -> args.add(SearchCommandKeyword.LANGUAGE).add(l.getId()));
        this.languageField.ifPresent(f -> args.add(SearchCommandKeyword.LANGUAGE_FIELD).addKey(f));
        this.defaultScore.ifPresent(s -> args.add(SearchCommandKeyword.SCORE).add(s));
        this.scoreField.ifPresent(f -> args.add(SearchCommandKeyword.SCORE_FIELD).addKey(f));
        this.payloadField.ifPresent(f -> args.add(SearchCommandKeyword.PAYLOAD_FIELD).addKey(f));
        if (this.maxTextFields) {
            args.add(SearchCommandKeyword.MAXTEXTFIELDS);
        }
        this.temporary.ifPresent(t -> args.add(SearchCommandKeyword.TEMPORARY).add(t));
        if (this.noOffsets) {
            args.add(SearchCommandKeyword.NOOFFSETS);
        }
        if (this.noHL) {
            args.add(SearchCommandKeyword.NOHL);
        }
        if (this.noFields) {
            args.add(SearchCommandKeyword.NOFIELDS);
        }
        if (this.noFreqs) {
            args.add(SearchCommandKeyword.NOFREQS);
        }
        if (this.skipInitialScan) {
            args.add(SearchCommandKeyword.SKIPINITIALSCAN);
        }
        this.stopWords.ifPresent(w -> {
            args.add(SearchCommandKeyword.STOPWORDS).add(w.size());
            w.forEach(args::addValue);
        });
    }

    public String toString() {
        return "CreateOptions [on=" + this.on + ", prefixes=" + this.prefixes + ", filter=" + this.filter + ", defaultLanguage=" + this.defaultLanguage + ", languageField=" + this.languageField + ", defaultScore=" + this.defaultScore + ", scoreField=" + this.scoreField + ", payloadField=" + this.payloadField + ", maxTextFields=" + this.maxTextFields + ", temporary=" + this.temporary + ", noOffsets=" + this.noOffsets + ", noHL=" + this.noHL + ", noFields=" + this.noFields + ", noFreqs=" + this.noFreqs + ", skipInitialScan=" + this.skipInitialScan + ", stopWords=" + this.stopWords + "]";
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hash(this.defaultLanguage, this.defaultScore, this.filter, this.languageField, this.maxTextFields, this.noFields, this.noFreqs, this.noHL, this.noOffsets, this.on, this.payloadField, this.prefixes, this.scoreField, this.skipInitialScan, this.stopWords, this.temporary);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateOptions other = (CreateOptions)obj;
        return Objects.equals(this.defaultLanguage, other.defaultLanguage) && Objects.equals(this.defaultScore, other.defaultScore) && Objects.equals(this.filter, other.filter) && Objects.equals(this.languageField, other.languageField) && this.maxTextFields == other.maxTextFields && this.noFields == other.noFields && this.noFreqs == other.noFreqs && this.noHL == other.noHL && this.noOffsets == other.noOffsets && Objects.equals(this.on, other.on) && Objects.equals(this.payloadField, other.payloadField) && Objects.equals(this.prefixes, other.prefixes) && Objects.equals(this.scoreField, other.scoreField) && this.skipInitialScan == other.skipInitialScan && Objects.equals(this.stopWords, other.stopWords) && Objects.equals(this.temporary, other.temporary);
    }

    public static final class Builder<K, V> {
        private Optional<DataType> on = Optional.of(DataType.HASH);
        private final List<K> prefixes = new ArrayList<K>();
        private Optional<V> filter = Optional.empty();
        private Optional<Language> defaultLanguage = Optional.empty();
        private Optional<K> languageField = Optional.empty();
        private OptionalDouble defaultScore = OptionalDouble.empty();
        private Optional<K> scoreField = Optional.empty();
        private Optional<K> payloadField = Optional.empty();
        private boolean maxTextFields;
        private OptionalLong temporary = OptionalLong.empty();
        private boolean noOffsets;
        private boolean noHL;
        private boolean noFields;
        private boolean noFreqs;
        private boolean skipInitialScan;
        private Optional<List<V>> stopWords = Optional.empty();

        public Builder<K, V> on(DataType on) {
            this.on = Optional.of(on);
            return this;
        }

        public Builder<K, V> prefix(K prefix) {
            this.prefixes.add(prefix);
            return this;
        }

        public Builder<K, V> prefixes(K ... prefixes) {
            this.prefixes.addAll(Arrays.asList(prefixes));
            return this;
        }

        public Builder<K, V> filter(V filter) {
            this.filter = Optional.of(filter);
            return this;
        }

        public Builder<K, V> defaultLanguage(Language defaultLanguage) {
            this.defaultLanguage = Optional.of(defaultLanguage);
            return this;
        }

        public Builder<K, V> languageField(K languageField) {
            this.languageField = Optional.of(languageField);
            return this;
        }

        public Builder<K, V> defaultScore(double defaultScore) {
            this.defaultScore = OptionalDouble.of(defaultScore);
            return this;
        }

        public Builder<K, V> scoreField(K scoreField) {
            this.scoreField = Optional.of(scoreField);
            return this;
        }

        public Builder<K, V> payloadField(K payloadField) {
            this.payloadField = Optional.of(payloadField);
            return this;
        }

        public Builder<K, V> maxTextFields(boolean maxTextFields) {
            this.maxTextFields = maxTextFields;
            return this;
        }

        public Builder<K, V> temporary(long temporary) {
            this.temporary = OptionalLong.of(temporary);
            return this;
        }

        public Builder<K, V> noOffsets(boolean noOffsets) {
            this.noOffsets = noOffsets;
            return this;
        }

        public Builder<K, V> noHL(boolean noHL) {
            this.noHL = noHL;
            return this;
        }

        public Builder<K, V> noFields(boolean noFields) {
            this.noFields = noFields;
            return this;
        }

        public Builder<K, V> noFreqs(boolean noFreqs) {
            this.noFreqs = noFreqs;
            return this;
        }

        public Builder<K, V> skipInitialScan(boolean skipInitialScan) {
            this.skipInitialScan = skipInitialScan;
            return this;
        }

        public Builder<K, V> stopWords(V ... stopWords) {
            this.stopWords = Optional.of(Arrays.asList(stopWords));
            return this;
        }

        public CreateOptions<K, V> build() {
            return new CreateOptions(this);
        }
    }

    public static enum DataType {
        HASH,
        JSON;

    }
}

