/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.AggregateOperation;
import com.redis.lettucemod.search.SearchCommandArgs;

public class Limit
implements AggregateOperation<Object, Object> {
    private final long offset;
    private final long num;

    public Limit(long offset, long num) {
        this.offset = offset;
        this.num = num;
    }

    @Override
    public void build(SearchCommandArgs<Object, Object> args) {
        args.add(SearchCommandKeyword.LIMIT);
        args.add(this.offset);
        args.add(this.num);
    }

    public String toString() {
        return "LIMIT [offset=" + this.offset + ", num=" + this.num + "]";
    }

    public static INumStage offset(long offset) {
        return new Builder().offset(offset);
    }

    public static final class Builder
    implements IOffsetStage,
    INumStage {
        private long offset;

        private Builder() {
        }

        @Override
        public INumStage offset(long offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public Limit num(long num) {
            return new Limit(this.offset, num);
        }
    }

    public static interface INumStage {
        public Limit num(long var1);
    }

    public static interface IOffsetStage {
        public INumStage offset(long var1);
    }
}

