/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.timeseries;

import com.redis.lettucemod.protocol.TimeSeriesCommandKeyword;
import com.redis.lettucemod.timeseries.AbstractAddAlterCreateIncrbyOptions;
import com.redis.lettucemod.timeseries.DuplicatePolicy;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.Optional;

abstract class AbstractAddCreateOptions<K, V>
extends AbstractAddAlterCreateIncrbyOptions<K, V> {
    private final Optional<AbstractAddAlterCreateIncrbyOptions.Encoding> encoding;
    private final Optional<DuplicatePolicy> duplicatePolicy;

    protected AbstractAddCreateOptions(Builder<K, V, ?> builder) {
        super(builder);
        this.encoding = ((Builder)builder).encoding;
        this.duplicatePolicy = ((Builder)builder).policy;
    }

    protected <L, W> void buildDuplicatePolicy(CommandArgs<L, W> args, TimeSeriesCommandKeyword keyword) {
        this.duplicatePolicy.ifPresent(p -> args.add((ProtocolKeyword)keyword).add((ProtocolKeyword)p.getKeyword()));
    }

    protected <L, W> void buildEncoding(CommandArgs<L, W> args) {
        this.encoding.ifPresent(e -> args.add((ProtocolKeyword)TimeSeriesCommandKeyword.ENCODING).add((ProtocolKeyword)e.getKeyword()));
    }

    public static class Builder<K, V, B extends Builder<K, V, B>>
    extends AbstractAddAlterCreateIncrbyOptions.Builder<K, V, B> {
        private Optional<AbstractAddAlterCreateIncrbyOptions.Encoding> encoding = Optional.empty();
        private Optional<DuplicatePolicy> policy = Optional.empty();

        public B encoding(AbstractAddAlterCreateIncrbyOptions.Encoding encoding) {
            this.encoding = Optional.of(encoding);
            return (B)this;
        }

        public B policy(DuplicatePolicy policy) {
            this.policy = Optional.of(policy);
            return (B)this;
        }
    }
}

