/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.timeseries;

import com.redis.lettucemod.protocol.TimeSeriesCommandKeyword;
import com.redis.lettucemod.timeseries.Aggregation;
import io.lettuce.core.CompositeArgument;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.Optional;
import java.util.OptionalLong;

abstract class BaseRangeOptions
implements CompositeArgument {
    private final Optional<long[]> filterByTimestamp;
    private final Optional<FilterByValue> filterByValue;
    private final OptionalLong count;
    private final Optional<Aggregation> aggregation;

    protected BaseRangeOptions(Builder<?> builder) {
        this.filterByTimestamp = ((Builder)builder).filterByTimestamp;
        this.filterByValue = ((Builder)builder).filterByValue;
        this.count = ((Builder)builder).count;
        this.aggregation = ((Builder)builder).aggregation;
    }

    protected <K, V> void buildCount(CommandArgs<K, V> args) {
        this.count.ifPresent(c -> args.add((ProtocolKeyword)TimeSeriesCommandKeyword.COUNT).add(c));
    }

    protected <K, V> void buildAggregation(CommandArgs<K, V> args) {
        this.aggregation.ifPresent(a -> a.build(args));
    }

    protected <K, V> void buildFilterByTimestamp(CommandArgs<K, V> args) {
        this.filterByTimestamp.ifPresent(f -> {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.FILTER_BY_TS);
            for (long ts : f) {
                args.add(ts);
            }
        });
    }

    protected <K, V> void buildFilterByValue(CommandArgs<K, V> args) {
        this.filterByValue.ifPresent(f -> f.build(args));
    }

    public static class FilterByValue
    implements CompositeArgument {
        private double min;
        private double max;

        public double getMin() {
            return this.min;
        }

        public void setMin(double min) {
            this.min = min;
        }

        public double getMax() {
            return this.max;
        }

        public void setMax(double max) {
            this.max = max;
        }

        public static FilterByValue of(double min, double max) {
            FilterByValue filter = new FilterByValue();
            filter.setMin(min);
            filter.setMax(max);
            return filter;
        }

        public <K, V> void build(CommandArgs<K, V> args) {
            args.add((ProtocolKeyword)TimeSeriesCommandKeyword.FILTER_BY_VALUE);
            args.add(this.min);
            args.add(this.max);
        }
    }

    public static class Builder<B extends Builder<B>> {
        private Optional<long[]> filterByTimestamp = Optional.empty();
        private Optional<FilterByValue> filterByValue = Optional.empty();
        private OptionalLong count = OptionalLong.empty();
        private Optional<Aggregation> aggregation = Optional.empty();

        public B filterByTimestamp(long ... timestamps) {
            this.filterByTimestamp = Optional.of(timestamps);
            return (B)this;
        }

        public B filterByValue(double min, double max) {
            this.filterByValue = Optional.of(FilterByValue.of(min, max));
            return (B)this;
        }

        public B count(long count) {
            this.count = OptionalLong.of(count);
            return (B)this;
        }

        public B aggregation(Aggregation aggregation) {
            this.aggregation = Optional.of(aggregation);
            return (B)this;
        }
    }
}

