/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.util;

import com.redis.lettucemod.search.CreateOptions;
import com.redis.lettucemod.search.Language;
import com.redis.lettucemod.util.RedisModulesUtils;
import java.util.Iterator;
import java.util.List;

public class IndexDefinitionParser {
    private final CreateOptions.Builder<String, String> options;
    private final Iterator<Object> iterator;

    public IndexDefinitionParser(List<Object> list, CreateOptions.Builder<String, String> options) {
        this.iterator = list.iterator();
        this.options = options;
    }

    public CreateOptions<String, String> parse() {
        while (this.iterator.hasNext()) {
            String key = (String)this.iterator.next();
            if (key.equals("key_type")) {
                this.options.on(CreateOptions.DataType.valueOf(this.nextString().toUpperCase()));
                continue;
            }
            if (key.equals("prefixes")) {
                this.options.prefixes((String[])this.nextStringArray());
                continue;
            }
            if (key.equals("filter")) {
                this.options.filter(this.nextString());
                continue;
            }
            if (key.equals("default_language")) {
                this.options.defaultLanguage(Language.valueOf(this.nextString().toUpperCase()));
                continue;
            }
            if (key.equals("language_field")) {
                this.options.languageField(this.nextString());
                continue;
            }
            if (key.equals("default_score")) {
                this.options.defaultScore(this.nextDouble());
                continue;
            }
            if (key.equals("score_field")) {
                this.options.scoreField(this.nextString());
                continue;
            }
            if (!key.equals("payload_field")) continue;
            this.options.payloadField(this.nextString());
        }
        return this.options.build();
    }

    private double nextDouble() {
        return RedisModulesUtils.getDouble(this.iterator.next());
    }

    private String nextString() {
        return (String)this.iterator.next();
    }

    private String[] nextStringArray() {
        return (String[])((List)this.iterator.next()).toArray(String[]::new);
    }
}

