/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.util;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisCredentialsProvider;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SslVerifyMode;
import io.lettuce.core.StaticCredentialsProvider;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.protocol.DecodeBufferPolicies;
import io.lettuce.core.protocol.DecodeBufferPolicy;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Predicate;

public class RedisURIBuilder {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 6379;
    public static final SslVerifyMode DEFAULT_SSL_VERIFY_MODE = SslVerifyMode.FULL;
    public static final boolean DEFAULT_SSL = false;
    public static final boolean DEFAULT_START_TLS = false;
    public static final boolean DEFAULT_AUTO_RECONNECT = true;
    public static final boolean DEFAULT_PUBLISH_ON_SCHEDULER = false;
    public static final ClientOptions.DisconnectedBehavior DEFAULT_DISCONNECTED_BEHAVIOR = ClientOptions.DEFAULT_DISCONNECTED_BEHAVIOR;
    public static final boolean DEFAULT_SUSPEND_RECONNECT_ON_PROTOCOL_FAILURE = false;
    public static final DecodeBufferPolicy DEFAULT_DECODE_BUFFER_POLICY = DecodeBufferPolicies.ratio((float)3.0f);
    public static final int DEFAULT_REQUEST_QUEUE_SIZE = Integer.MAX_VALUE;
    public static final TimeoutOptions DEFAULT_TIMEOUT_OPTIONS = TimeoutOptions.create();
    public static final boolean DEFAULT_SHOW_METRICS = false;
    public static final int DEFAULT_MAX_REDIRECTS = 5;
    public static final boolean DEFAULT_VALIDATE_CLUSTER_MEMBERSHIP = true;
    public static final Predicate<RedisClusterNode> DEFAULT_NODE_FILTER = ClusterClientOptions.DEFAULT_NODE_FILTER;
    private String host = "localhost";
    private int port = 6379;
    private Optional<RedisURI> uri = Optional.empty();
    private boolean ssl = false;
    private boolean startTls = false;
    private SslVerifyMode sslVerifyMode = DEFAULT_SSL_VERIFY_MODE;
    private Optional<String> socket = Optional.empty();
    private String username;
    private char[] password;
    private Optional<RedisCredentialsProvider> credentialsProvider = Optional.empty();
    private int database;
    private Optional<Duration> timeout = Optional.empty();
    private Optional<String> clientName = Optional.empty();

    public RedisURIBuilder host(String host) {
        this.host = host;
        return this;
    }

    public RedisURIBuilder port(int port) {
        this.port = port;
        return this;
    }

    public RedisURIBuilder uri(RedisURI uri) {
        return this.uri(Optional.of(uri));
    }

    public RedisURIBuilder uri(Optional<RedisURI> uri) {
        this.uri = uri;
        return this;
    }

    public RedisURIBuilder uriString(String uri) {
        return this.uri(RedisURI.create((String)uri));
    }

    public RedisURIBuilder uriString(Optional<String> uri) {
        return this.uri(uri.map(RedisURI::create));
    }

    public RedisURIBuilder ssl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public RedisURIBuilder startTls(boolean startTls) {
        this.startTls = startTls;
        return this;
    }

    public RedisURIBuilder sslVerifyMode(SslVerifyMode sslVerifyMode) {
        this.sslVerifyMode = sslVerifyMode;
        return this;
    }

    public RedisURIBuilder socket(String socket) {
        return this.socket(Optional.of(socket));
    }

    public RedisURIBuilder socket(Optional<String> socket) {
        this.socket = socket;
        return this;
    }

    public RedisURIBuilder username(String username) {
        this.username = username;
        return this;
    }

    public RedisURIBuilder password(char[] password) {
        this.password = password;
        return this;
    }

    public RedisURIBuilder credentialsProvider(RedisCredentialsProvider credentialsProvider) {
        return this.credentialsProvider(Optional.of(credentialsProvider));
    }

    public RedisURIBuilder credentialsProvider(Optional<RedisCredentialsProvider> credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public RedisURIBuilder database(int database) {
        this.database = database;
        return this;
    }

    public RedisURIBuilder timeoutInSeconds(long timeout) {
        return this.timeout(Duration.ofSeconds(timeout));
    }

    public RedisURIBuilder timeout(Duration timeout) {
        return this.timeout(Optional.of(timeout));
    }

    public RedisURIBuilder timeout(Optional<Duration> timeout) {
        this.timeout = timeout;
        return this;
    }

    public RedisURIBuilder clientName(String clientName) {
        return this.clientName(Optional.of(clientName));
    }

    public RedisURIBuilder clientName(Optional<String> clientName) {
        this.clientName = clientName;
        return this;
    }

    public RedisURI build() {
        RedisURI redisURI = this.uri.orElse(RedisURI.create((String)this.host, (int)this.port));
        redisURI.setVerifyPeer(this.sslVerifyMode);
        if (this.ssl) {
            redisURI.setSsl(true);
        }
        if (this.startTls) {
            redisURI.setStartTls(true);
        }
        this.socket.ifPresent(arg_0 -> ((RedisURI)redisURI).setSocket(arg_0));
        this.credentialsProvider().ifPresent(arg_0 -> ((RedisURI)redisURI).setCredentialsProvider(arg_0));
        redisURI.setDatabase(this.database);
        this.timeout.ifPresent(arg_0 -> ((RedisURI)redisURI).setTimeout(arg_0));
        this.clientName.ifPresent(arg_0 -> ((RedisURI)redisURI).setClientName(arg_0));
        return redisURI;
    }

    private Optional<RedisCredentialsProvider> credentialsProvider() {
        if (this.credentialsProvider.isPresent()) {
            return this.credentialsProvider;
        }
        if (this.username == null && this.password == null) {
            return Optional.empty();
        }
        return Optional.of(new StaticCredentialsProvider(this.username, this.password));
    }

    public static RedisURIBuilder create() {
        return new RedisURIBuilder();
    }
}

