/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.cluster;

import com.redis.lettucemod.RedisModulesReactiveCommandsImpl;
import com.redis.lettucemod.api.reactive.RedisModulesReactiveCommands;
import com.redis.lettucemod.cluster.api.StatefulRedisModulesClusterConnection;
import com.redis.lettucemod.cluster.api.reactive.RedisModulesAdvancedClusterReactiveCommands;
import com.redis.lettucemod.gears.Execution;
import com.redis.lettucemod.gears.ExecutionDetails;
import com.redis.lettucemod.gears.ExecutionMode;
import com.redis.lettucemod.gears.Registration;
import com.redis.lettucemod.json.ArrpopOptions;
import com.redis.lettucemod.json.GetOptions;
import com.redis.lettucemod.json.SetMode;
import com.redis.lettucemod.json.Slice;
import com.redis.lettucemod.output.ExecutionResults;
import com.redis.lettucemod.search.AggregateOptions;
import com.redis.lettucemod.search.AggregateResults;
import com.redis.lettucemod.search.AggregateWithCursorResults;
import com.redis.lettucemod.search.CursorOptions;
import com.redis.lettucemod.search.Field;
import com.redis.lettucemod.search.SearchOptions;
import com.redis.lettucemod.search.SearchResults;
import com.redis.lettucemod.search.Suggestion;
import com.redis.lettucemod.search.SuggetOptions;
import com.redis.lettucemod.timeseries.AddOptions;
import com.redis.lettucemod.timeseries.AlterOptions;
import com.redis.lettucemod.timeseries.CreateOptions;
import com.redis.lettucemod.timeseries.CreateRuleOptions;
import com.redis.lettucemod.timeseries.GetResult;
import com.redis.lettucemod.timeseries.IncrbyOptions;
import com.redis.lettucemod.timeseries.KeySample;
import com.redis.lettucemod.timeseries.MGetOptions;
import com.redis.lettucemod.timeseries.MRangeOptions;
import com.redis.lettucemod.timeseries.RangeOptions;
import com.redis.lettucemod.timeseries.RangeResult;
import com.redis.lettucemod.timeseries.Sample;
import com.redis.lettucemod.timeseries.TimeRange;
import io.lettuce.core.KeyValue;
import io.lettuce.core.cluster.RedisAdvancedClusterReactiveCommandsImpl;
import io.lettuce.core.cluster.SlotHash;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceLists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedisModulesAdvancedClusterReactiveCommandsImpl<K, V>
extends RedisAdvancedClusterReactiveCommandsImpl<K, V>
implements RedisModulesAdvancedClusterReactiveCommands<K, V> {
    private final RedisModulesReactiveCommandsImpl<K, V> delegate;
    private final RedisCodec<K, V> codec;

    public RedisModulesAdvancedClusterReactiveCommandsImpl(StatefulRedisModulesClusterConnection<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
        this.codec = codec;
        this.delegate = new RedisModulesReactiveCommandsImpl<K, V>(connection, codec);
    }

    @Override
    public RedisModulesAdvancedClusterReactiveCommands<K, V> getConnection(String nodeId) {
        return (RedisModulesAdvancedClusterReactiveCommands)super.getConnection(nodeId);
    }

    @Override
    public RedisModulesAdvancedClusterReactiveCommands<K, V> getConnection(String host, int port) {
        return (RedisModulesAdvancedClusterReactiveCommands)super.getConnection(host, port);
    }

    @Override
    public StatefulRedisModulesClusterConnection<K, V> getStatefulConnection() {
        return (StatefulRedisModulesClusterConnection)super.getStatefulConnection();
    }

    @Override
    public Mono<String> rgAbortexecution(String id) {
        return this.delegate.rgAbortexecution(id);
    }

    @Override
    public Flux<V> rgConfigget(K ... keys) {
        return this.delegate.rgConfigget(keys);
    }

    @Override
    public Flux<V> rgConfigset(Map<K, V> map) {
        return this.delegate.rgConfigset(map);
    }

    @Override
    public Mono<String> rgDropexecution(String id) {
        return this.delegate.rgDropexecution(id);
    }

    @Override
    public Flux<Execution> rgDumpexecutions() {
        return this.delegate.rgDumpexecutions();
    }

    @Override
    public Flux<Registration> rgDumpregistrations() {
        return this.delegate.rgDumpregistrations();
    }

    @Override
    public Mono<ExecutionDetails> rgGetexecution(String id) {
        return this.delegate.rgGetexecution(id);
    }

    @Override
    public Mono<ExecutionDetails> rgGetexecution(String id, ExecutionMode mode) {
        return this.delegate.rgGetexecution(id, mode);
    }

    @Override
    public Mono<ExecutionResults> rgGetresults(String id) {
        return this.delegate.rgGetresults(id);
    }

    @Override
    public Mono<ExecutionResults> rgGetresultsblocking(String id) {
        return this.delegate.rgGetresultsblocking(id);
    }

    @Override
    public Mono<ExecutionResults> rgPyexecute(String function, V ... requirements) {
        return this.delegate.rgPyexecute(function, requirements);
    }

    @Override
    public Mono<String> rgPyexecuteUnblocking(String function, V ... requirements) {
        return this.delegate.rgPyexecuteUnblocking(function, requirements);
    }

    @Override
    public Flux<Object> rgTrigger(String trigger, V ... args) {
        return this.delegate.rgTrigger(trigger, args);
    }

    @Override
    public Mono<String> rgUnregister(String id) {
        return this.delegate.rgUnregister(id);
    }

    @Override
    public Mono<String> ftCreate(K index, Field<K> ... fields) {
        return this.ftCreate(index, (com.redis.lettucemod.search.CreateOptions<K, V>)null, fields);
    }

    @Override
    public Mono<String> ftCreate(K index, com.redis.lettucemod.search.CreateOptions<K, V> options, Field<K> ... fields) {
        Map publishers = this.executeOnUpstream(commands -> ((RedisModulesReactiveCommands)commands).ftCreate(index, options, fields));
        return Flux.merge(publishers.values()).last();
    }

    @Override
    public Mono<String> ftDropindex(K index) {
        Map publishers = this.executeOnUpstream(commands -> ((RedisModulesReactiveCommands)commands).ftDropindex(index));
        return Flux.merge(publishers.values()).last();
    }

    @Override
    public Mono<String> ftDropindexDeleteDocs(K index) {
        Map publishers = this.executeOnUpstream(commands -> ((RedisModulesReactiveCommands)commands).ftDropindexDeleteDocs(index));
        return Flux.merge(publishers.values()).last();
    }

    @Override
    public Mono<String> ftAlter(K index, Field<K> field) {
        Map publishers = this.executeOnUpstream(commands -> ((RedisModulesReactiveCommands)commands).ftAlter(index, field));
        return Flux.merge(publishers.values()).last();
    }

    @Override
    public Flux<Object> ftInfo(K index) {
        return this.delegate.ftInfo(index);
    }

    @Override
    public Mono<String> ftAliasadd(K name, K index) {
        Map publishers = this.executeOnUpstream(commands -> ((RedisModulesReactiveCommands)commands).ftAliasadd(name, index));
        return Flux.merge(publishers.values()).last();
    }

    @Override
    public Mono<String> ftAliasupdate(K name, K index) {
        Map publishers = this.executeOnUpstream(commands -> ((RedisModulesReactiveCommands)commands).ftAliasupdate(name, index));
        return Flux.merge(publishers.values()).last();
    }

    @Override
    public Mono<String> ftAliasdel(K name) {
        Map publishers = this.executeOnUpstream(commands -> ((RedisModulesReactiveCommands)commands).ftAliasdel(name));
        return Flux.merge(publishers.values()).last();
    }

    @Override
    public Flux<K> ftList() {
        return this.delegate.ftList();
    }

    @Override
    public Mono<SearchResults<K, V>> ftSearch(K index, V query) {
        return this.delegate.ftSearch(index, query);
    }

    @Override
    public Mono<SearchResults<K, V>> ftSearch(K index, V query, SearchOptions<K, V> options) {
        return this.delegate.ftSearch(index, query, options);
    }

    @Override
    public Mono<AggregateResults<K>> ftAggregate(K index, V query) {
        return this.delegate.ftAggregate(index, query);
    }

    @Override
    public Mono<AggregateResults<K>> ftAggregate(K index, V query, AggregateOptions<K, V> options) {
        return this.delegate.ftAggregate(index, query, options);
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> ftAggregate(K index, V query, CursorOptions cursor) {
        return this.delegate.ftAggregate(index, query, cursor);
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> ftAggregate(K index, V query, CursorOptions cursor, AggregateOptions<K, V> options) {
        return this.delegate.ftAggregate(index, query, cursor, options);
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> ftCursorRead(K index, long cursor) {
        return this.delegate.ftCursorRead(index, cursor);
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> ftCursorRead(K index, long cursor, long count) {
        return this.delegate.ftCursorRead(index, cursor, count);
    }

    @Override
    public Mono<String> ftCursorDelete(K index, long cursor) {
        return this.delegate.ftCursorDelete(index, cursor);
    }

    @Override
    public Flux<V> ftTagvals(K index, K field) {
        return this.delegate.ftTagvals(index, field);
    }

    @Override
    public Mono<Long> ftSugadd(K key, Suggestion<V> suggestion) {
        return this.delegate.ftSugadd(key, suggestion);
    }

    @Override
    public Mono<Long> ftSugaddIncr(K key, Suggestion<V> suggestion) {
        return this.delegate.ftSugaddIncr(key, suggestion);
    }

    @Override
    public Flux<Suggestion<V>> ftSugget(K key, V prefix) {
        return this.delegate.ftSugget(key, prefix);
    }

    @Override
    public Flux<Suggestion<V>> ftSugget(K key, V prefix, SuggetOptions options) {
        return this.delegate.ftSugget(key, prefix, options);
    }

    @Override
    public Mono<Boolean> ftSugdel(K key, V string) {
        return this.delegate.ftSugdel(key, string);
    }

    @Override
    public Mono<Long> ftSuglen(K key) {
        return this.delegate.ftSuglen(key);
    }

    @Override
    public Mono<Long> ftDictadd(K dict, V ... terms) {
        Map publishers = this.executeOnUpstream(commands -> ((RedisModulesReactiveCommands)commands).ftDictadd(dict, terms));
        return Flux.merge(publishers.values()).last();
    }

    @Override
    public Mono<Long> ftDictdel(K dict, V ... terms) {
        Map publishers = this.executeOnUpstream(commands -> ((RedisModulesReactiveCommands)commands).ftDictdel(dict, terms));
        return Flux.merge(publishers.values()).last();
    }

    @Override
    public Flux<V> ftDictdump(K dict) {
        return this.delegate.ftDictdump(dict);
    }

    @Override
    public Mono<String> tsCreate(K key, CreateOptions<K, V> options) {
        return this.delegate.tsCreate(key, options);
    }

    @Override
    public Mono<String> tsAlter(K key, AlterOptions<K, V> options) {
        return this.delegate.tsAlter(key, options);
    }

    @Override
    public Mono<Long> tsAdd(K key, Sample sample) {
        return this.delegate.tsAdd(key, sample);
    }

    @Override
    public Mono<Long> tsAdd(K key, Sample sample, AddOptions<K, V> options) {
        return this.delegate.tsAdd(key, sample, options);
    }

    @Override
    public Flux<Long> tsMadd(KeySample<K> ... samples) {
        return this.delegate.tsMadd(samples);
    }

    @Override
    public Mono<Long> tsDecrby(K key, double value) {
        return this.delegate.tsDecrby(key, value);
    }

    @Override
    public Mono<Long> tsDecrby(K key, double value, IncrbyOptions<K, V> options) {
        return this.delegate.tsDecrby(key, value, options);
    }

    @Override
    public Mono<Long> tsIncrby(K key, double value) {
        return this.delegate.tsIncrby(key, value);
    }

    @Override
    public Mono<Long> tsIncrby(K key, double value, IncrbyOptions<K, V> options) {
        return this.delegate.tsIncrby(key, value, options);
    }

    @Override
    public Mono<String> tsCreaterule(K sourceKey, K destKey, CreateRuleOptions options) {
        return this.delegate.tsCreaterule(sourceKey, destKey, options);
    }

    @Override
    public Mono<String> tsDeleterule(K sourceKey, K destKey) {
        return this.delegate.tsDeleterule(sourceKey, destKey);
    }

    @Override
    public Flux<Sample> tsRange(K key, TimeRange range) {
        return this.delegate.tsRange(key, range);
    }

    @Override
    public Flux<Sample> tsRange(K key, TimeRange range, RangeOptions options) {
        return this.delegate.tsRange(key, range, options);
    }

    @Override
    public Flux<Sample> tsRevrange(K key, TimeRange range) {
        return this.delegate.tsRevrange(key, range);
    }

    @Override
    public Flux<Sample> tsRevrange(K key, TimeRange range, RangeOptions options) {
        return this.delegate.tsRevrange(key, range, options);
    }

    @Override
    public Flux<RangeResult<K, V>> tsMrange(TimeRange range) {
        return this.delegate.tsMrange(range);
    }

    @Override
    public Flux<RangeResult<K, V>> tsMrange(TimeRange range, MRangeOptions<K, V> options) {
        return this.delegate.tsMrange(range, options);
    }

    @Override
    public Flux<RangeResult<K, V>> tsMrevrange(TimeRange range) {
        return this.delegate.tsMrevrange(range);
    }

    @Override
    public Flux<RangeResult<K, V>> tsMrevrange(TimeRange range, MRangeOptions<K, V> options) {
        return this.delegate.tsMrevrange(range, options);
    }

    @Override
    public Mono<Sample> tsGet(K key) {
        return this.delegate.tsGet(key);
    }

    @Override
    public Flux<GetResult<K, V>> tsMget(MGetOptions<K, V> options) {
        return this.delegate.tsMget(options);
    }

    @Override
    public Flux<GetResult<K, V>> tsMget(V ... filters) {
        return this.delegate.tsMget(filters);
    }

    @Override
    public Flux<GetResult<K, V>> tsMgetWithLabels(V ... filters) {
        return this.delegate.tsMgetWithLabels(filters);
    }

    @Override
    public Flux<Object> tsInfo(K key) {
        return this.delegate.tsInfo(key);
    }

    @Override
    public Flux<Object> tsInfoDebug(K key) {
        return this.delegate.tsInfoDebug(key);
    }

    @Override
    public Mono<Long> jsonDel(K key) {
        return this.delegate.jsonDel(key);
    }

    @Override
    public Mono<Long> jsonDel(K key, String path) {
        return this.delegate.jsonDel(key, path);
    }

    @Override
    public Mono<V> jsonGet(K key, K ... paths) {
        return this.delegate.jsonGet(key, paths);
    }

    @Override
    public Mono<V> jsonGet(K key, GetOptions options, K ... paths) {
        return this.delegate.jsonGet(key, options, paths);
    }

    @Override
    public Flux<KeyValue<K, V>> jsonMget(String path, K ... keys) {
        return this.mget(path, Arrays.asList(keys));
    }

    public Flux<KeyValue<K, V>> mget(String path, Iterable<K> keys) {
        List keyList = LettuceLists.newList(keys);
        Map partitioned = SlotHash.partition(this.codec, (Iterable)keyList);
        if (partitioned.size() < 2) {
            return this.delegate.mget(path, keyList);
        }
        ArrayList<Flux<KeyValue<K, V>>> publishers = new ArrayList<Flux<KeyValue<K, V>>>();
        for (Map.Entry entry : partitioned.entrySet()) {
            publishers.add(this.delegate.mget(path, (Iterable)entry.getValue()));
        }
        Flux fluxes = Flux.concat(publishers);
        Mono map = fluxes.collectList().map(vs -> {
            KeyValue[] values = new KeyValue[vs.size()];
            int offset = 0;
            for (Map.Entry entry : partitioned.entrySet()) {
                for (int i = 0; i < keyList.size(); ++i) {
                    int index = ((List)entry.getValue()).indexOf(keyList.get(i));
                    if (index == -1) continue;
                    values[i] = (KeyValue)vs.get(offset + index);
                }
                offset += ((List)entry.getValue()).size();
            }
            return Arrays.asList(values);
        });
        return map.flatMapIterable(keyValues -> keyValues);
    }

    @Override
    public Mono<String> jsonSet(K key, String path, V json) {
        return this.delegate.jsonSet(key, path, json);
    }

    @Override
    public Mono<String> jsonSet(K key, String path, V json, SetMode mode) {
        return this.delegate.jsonSet(key, path, json, mode);
    }

    @Override
    public Mono<String> jsonType(K key) {
        return this.delegate.jsonType(key);
    }

    @Override
    public Mono<String> jsonType(K key, String path) {
        return this.delegate.jsonType(key, path);
    }

    @Override
    public Mono<V> jsonNumincrby(K key, String path, double number) {
        return this.delegate.jsonNumincrby(key, path, number);
    }

    @Override
    public Mono<V> jsonNummultby(K key, String path, double number) {
        return this.delegate.jsonNummultby(key, path, number);
    }

    @Override
    public Mono<Long> jsonStrappend(K key, V json) {
        return this.delegate.jsonStrappend(key, json);
    }

    @Override
    public Mono<Long> jsonStrappend(K key, String path, V json) {
        return this.delegate.jsonStrappend(key, path, json);
    }

    @Override
    public Mono<Long> jsonStrlen(K key, String path) {
        return this.delegate.jsonStrlen(key, path);
    }

    @Override
    public Mono<Long> jsonArrappend(K key, String path, V ... jsons) {
        return this.delegate.jsonArrappend(key, path, jsons);
    }

    @Override
    public Mono<Long> jsonArrindex(K key, String path, V scalar) {
        return this.delegate.jsonArrindex(key, path, scalar);
    }

    @Override
    public Mono<Long> jsonArrindex(K key, String path, V scalar, Slice slice) {
        return this.delegate.jsonArrindex(key, path, scalar, slice);
    }

    @Override
    public Mono<Long> jsonArrinsert(K key, String path, long index, V ... jsons) {
        return this.delegate.jsonArrinsert(key, path, index, jsons);
    }

    @Override
    public Mono<Long> jsonArrlen(K key) {
        return this.delegate.jsonArrlen(key);
    }

    @Override
    public Mono<Long> jsonArrlen(K key, String path) {
        return this.delegate.jsonArrlen(key, path);
    }

    @Override
    public Mono<V> jsonArrpop(K key) {
        return this.delegate.jsonArrpop(key);
    }

    @Override
    public Mono<V> jsonArrpop(K key, ArrpopOptions<K> options) {
        return this.delegate.jsonArrpop(key, options);
    }

    @Override
    public Mono<Long> jsonArrtrim(K key, String path, long start, long stop) {
        return this.delegate.jsonArrtrim(key, path, start, stop);
    }

    @Override
    public Flux<K> jsonObjkeys(K key) {
        return this.delegate.jsonObjkeys(key);
    }

    @Override
    public Flux<K> jsonObjkeys(K key, String path) {
        return this.delegate.jsonObjkeys(key, path);
    }

    @Override
    public Mono<Long> jsonObjlen(K key) {
        return this.delegate.jsonObjlen(key);
    }

    @Override
    public Mono<Long> jsonObjlen(K key, String path) {
        return this.delegate.jsonObjlen(key, path);
    }
}

