/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search.querybuilder;

import com.redis.lettucemod.search.querybuilder.DisjunctNode;
import com.redis.lettucemod.search.querybuilder.DisjunctUnionNode;
import com.redis.lettucemod.search.querybuilder.IntersectNode;
import com.redis.lettucemod.search.querybuilder.Node;
import com.redis.lettucemod.search.querybuilder.OptionalNode;
import com.redis.lettucemod.search.querybuilder.QueryNode;
import com.redis.lettucemod.search.querybuilder.UnionNode;
import com.redis.lettucemod.search.querybuilder.Value;
import com.redis.lettucemod.search.querybuilder.Values;
import java.util.Arrays;

public class QueryBuilder {
    private QueryBuilder() {
    }

    public static QueryNode intersect(Node ... n) {
        return new IntersectNode().add(n);
    }

    public static QueryNode intersect(String field, Value ... values) {
        return QueryBuilder.intersect(new Node[0]).add(field, values);
    }

    public static QueryNode intersect(String field, String stringValue) {
        return QueryBuilder.intersect(field, Values.value(stringValue));
    }

    public static QueryNode union(Node ... n) {
        return new UnionNode().add(n);
    }

    public static QueryNode union(String field, Value ... values) {
        return QueryBuilder.union(new Node[0]).add(field, values);
    }

    public static QueryNode union(String field, String ... values) {
        return QueryBuilder.union(field, (Value[])Arrays.stream(values).map(Values::value).toArray());
    }

    public static QueryNode disjunct(Node ... n) {
        return new DisjunctNode().add(n);
    }

    public static QueryNode disjunct(String field, Value ... values) {
        return QueryBuilder.disjunct(new Node[0]).add(field, values);
    }

    public static QueryNode disjunct(String field, String ... values) {
        return QueryBuilder.disjunct(field, (Value[])Arrays.stream(values).map(Values::value).toArray());
    }

    public static QueryNode disjunctUnion(Node ... n) {
        return new DisjunctUnionNode().add(n);
    }

    public static QueryNode disjunctUnion(String field, Value ... values) {
        return QueryBuilder.disjunctUnion(new Node[0]).add(field, values);
    }

    public static QueryNode disjunctUnion(String field, String ... values) {
        return QueryBuilder.disjunctUnion(field, (Value[])Arrays.stream(values).map(Values::value).toArray());
    }

    public static QueryNode optional(Node ... n) {
        return new OptionalNode().add(n);
    }

    public static QueryNode optional(String field, Value ... values) {
        return QueryBuilder.optional(new Node[0]).add(field, values);
    }
}

