/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.util;

import io.lettuce.core.RedisCredentialsProvider;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SslVerifyMode;
import java.time.Duration;
import java.util.Optional;

public class RedisURIBuilder {
    public static final String DEFAULT_HOST = "localhost";
    private String host = "localhost";
    private int port;
    private Optional<String> uri = Optional.empty();
    private boolean ssl;
    private boolean startTls;
    private Optional<SslVerifyMode> sslVerifyMode = Optional.empty();
    private Optional<String> socket = Optional.empty();
    private String username;
    private char[] password;
    private Optional<RedisCredentialsProvider> credentialsProvider = Optional.empty();
    private int database;
    private Optional<Duration> timeout = Optional.empty();
    private Optional<String> clientName = Optional.empty();

    public RedisURIBuilder host(String host) {
        this.host = host;
        return this;
    }

    public RedisURIBuilder port(int port) {
        this.port = port;
        return this;
    }

    public RedisURIBuilder uri(String uri) {
        return this.uri(Optional.ofNullable(uri));
    }

    public RedisURIBuilder uri(Optional<String> uri) {
        this.uri = uri;
        return this;
    }

    public RedisURIBuilder ssl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public RedisURIBuilder startTls(boolean startTls) {
        this.startTls = startTls;
        return this;
    }

    public RedisURIBuilder sslVerifyMode(Optional<SslVerifyMode> sslVerifyMode) {
        this.sslVerifyMode = sslVerifyMode;
        return this;
    }

    public RedisURIBuilder sslVerifyMode(SslVerifyMode sslVerifyMode) {
        return this.sslVerifyMode(Optional.of(sslVerifyMode));
    }

    public RedisURIBuilder socket(String socket) {
        return this.socket(Optional.ofNullable(socket));
    }

    public RedisURIBuilder socket(Optional<String> socket) {
        this.socket = socket;
        return this;
    }

    public RedisURIBuilder username(String username) {
        this.username = username;
        return this;
    }

    public RedisURIBuilder password(String password) {
        if (password == null) {
            return this;
        }
        return this.password(password.toCharArray());
    }

    public RedisURIBuilder password(char[] password) {
        this.password = password;
        return this;
    }

    public RedisURIBuilder credentialsProvider(RedisCredentialsProvider credentialsProvider) {
        return this.credentialsProvider(Optional.ofNullable(credentialsProvider));
    }

    public RedisURIBuilder credentialsProvider(Optional<RedisCredentialsProvider> credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public RedisURIBuilder database(int database) {
        this.database = database;
        return this;
    }

    public RedisURIBuilder timeoutInSeconds(long timeout) {
        return this.timeout(Duration.ofSeconds(timeout));
    }

    public RedisURIBuilder timeout(Duration timeout) {
        return this.timeout(Optional.ofNullable(timeout));
    }

    public RedisURIBuilder timeout(Optional<Duration> timeout) {
        this.timeout = timeout;
        return this;
    }

    public RedisURIBuilder clientName(String clientName) {
        return this.clientName(Optional.ofNullable(clientName));
    }

    public RedisURIBuilder clientName(Optional<String> clientName) {
        this.clientName = clientName;
        return this;
    }

    public RedisURI build() {
        RedisURI.Builder builder = this.uri.map(RedisURI::create).map(RedisURI::builder).orElse(RedisURI.builder().withHost(this.host));
        if (this.port > 0) {
            builder.withPort(this.port);
        }
        if (this.database > 0) {
            builder.withDatabase(this.database);
        }
        if (this.ssl) {
            builder.withSsl(this.ssl);
        }
        if (this.startTls) {
            builder.withStartTls(this.startTls);
        }
        this.sslVerifyMode.ifPresent(arg_0 -> ((RedisURI.Builder)builder).withVerifyPeer(arg_0));
        this.credentialsProvider.ifPresent(arg_0 -> ((RedisURI.Builder)builder).withAuthentication(arg_0));
        if (this.password != null && this.password.length > 0) {
            if (this.username == null) {
                builder.withPassword(this.password);
            } else {
                builder.withAuthentication(this.username, this.password);
            }
        }
        this.clientName.ifPresent(arg_0 -> ((RedisURI.Builder)builder).withClientName(arg_0));
        this.timeout.ifPresent(arg_0 -> ((RedisURI.Builder)builder).withTimeout(arg_0));
        RedisURI redisURI = builder.build();
        this.socket.ifPresent(arg_0 -> ((RedisURI)redisURI).setSocket(arg_0));
        return redisURI;
    }

    public static RedisURIBuilder create(String uri) {
        return new RedisURIBuilder().uri(uri);
    }

    public static RedisURIBuilder create() {
        return new RedisURIBuilder();
    }
}

