/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.util;

import com.redis.lettucemod.RedisModulesClient;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SocketOptions;
import io.lettuce.core.SslOptions;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.event.EventPublisherOptions;
import io.lettuce.core.metrics.CommandLatencyRecorder;
import io.lettuce.core.protocol.DecodeBufferPolicies;
import io.lettuce.core.protocol.DecodeBufferPolicy;
import io.lettuce.core.protocol.ProtocolVersion;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import java.io.File;
import java.util.Optional;
import java.util.function.Predicate;

public abstract class AbstractClientBuilder<B extends AbstractClientBuilder<B>> {
    public static final boolean DEFAULT_AUTO_RECONNECT = true;
    public static final boolean DEFAULT_PUBLISH_ON_SCHEDULER = false;
    public static final ClientOptions.DisconnectedBehavior DEFAULT_DISCONNECTED_BEHAVIOR = ClientOptions.DEFAULT_DISCONNECTED_BEHAVIOR;
    public static final boolean DEFAULT_SUSPEND_RECONNECT_ON_PROTOCOL_FAILURE = false;
    public static final DecodeBufferPolicy DEFAULT_DECODE_BUFFER_POLICY = DecodeBufferPolicies.ratio((float)3.0f);
    public static final int DEFAULT_REQUEST_QUEUE_SIZE = Integer.MAX_VALUE;
    public static final TimeoutOptions DEFAULT_TIMEOUT_OPTIONS = TimeoutOptions.create();
    public static final boolean DEFAULT_SHOW_METRICS = false;
    public static final int DEFAULT_MAX_REDIRECTS = 5;
    public static final boolean DEFAULT_VALIDATE_CLUSTER_MEMBERSHIP = true;
    public static final Predicate<RedisClusterNode> DEFAULT_NODE_FILTER = ClusterClientOptions.DEFAULT_NODE_FILTER;
    protected final RedisURI redisURI;
    private ClientOptions.DisconnectedBehavior disconnectedBehavior = DEFAULT_DISCONNECTED_BEHAVIOR;
    private boolean publishOnScheduler = false;
    private boolean autoReconnect = true;
    private boolean suspendReconnectOnProtocolFailure = false;
    private Optional<SocketOptions> socketOptions = Optional.empty();
    private DecodeBufferPolicy decodeBufferPolicy = DEFAULT_DECODE_BUFFER_POLICY;
    private Optional<ProtocolVersion> protocolVersion = Optional.empty();
    private int requestQueueSize = Integer.MAX_VALUE;
    private TimeoutOptions timeoutOptions = DEFAULT_TIMEOUT_OPTIONS;
    private Optional<CommandLatencyRecorder> commandLatencyRecorder = Optional.empty();
    private Optional<EventPublisherOptions> commandLatencyPublisherOptions = Optional.empty();
    private Optional<File> keystore = Optional.empty();
    private char[] keystorePassword;
    private Optional<File> truststore = Optional.empty();
    private char[] truststorePassword;
    private Optional<File> trustManager = Optional.empty();
    private Optional<File> key = Optional.empty();
    private File keyCert;
    private char[] keyPassword;

    protected AbstractClientBuilder(RedisURI redisURI) {
        this.redisURI = redisURI;
    }

    public B disconnectedBehavior(ClientOptions.DisconnectedBehavior disconnectedBehavior) {
        this.disconnectedBehavior = disconnectedBehavior;
        return (B)this;
    }

    public B publishOnScheduler(boolean publishOnScheduler) {
        this.publishOnScheduler = publishOnScheduler;
        return (B)this;
    }

    public B autoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        return (B)this;
    }

    public B suspendReconnectOnProtocolFailure(boolean suspendReconnectOnProtocolFailure) {
        this.suspendReconnectOnProtocolFailure = suspendReconnectOnProtocolFailure;
        return (B)this;
    }

    public B socketOptions(SocketOptions socketOptions) {
        return this.socketOptions(Optional.of(socketOptions));
    }

    public B socketOptions(Optional<SocketOptions> socketOptions) {
        this.socketOptions = socketOptions;
        return (B)this;
    }

    public B decodeBufferPolicy(DecodeBufferPolicy decodeBufferPolicy) {
        this.decodeBufferPolicy = decodeBufferPolicy;
        return (B)this;
    }

    public B protocolVersion(ProtocolVersion protocolVersion) {
        return this.protocolVersion(Optional.of(protocolVersion));
    }

    public B protocolVersion(Optional<ProtocolVersion> protocolVersion) {
        this.protocolVersion = protocolVersion;
        return (B)this;
    }

    public B requestQueueSize(int requestQueueSize) {
        this.requestQueueSize = requestQueueSize;
        return (B)this;
    }

    public B timeoutOptions(TimeoutOptions timeoutOptions) {
        this.timeoutOptions = timeoutOptions;
        return (B)this;
    }

    public B commandLatencyRecorder(CommandLatencyRecorder commandLatencyRecorder) {
        return this.commandLatencyRecorder(Optional.of(commandLatencyRecorder));
    }

    public B commandLatencyRecorder(Optional<CommandLatencyRecorder> commandLatencyRecorder) {
        this.commandLatencyRecorder = commandLatencyRecorder;
        return (B)this;
    }

    public B commandLatencyPublisherOptions(EventPublisherOptions commandLatencyPublisherOptions) {
        return this.commandLatencyPublisherOptions(Optional.of(commandLatencyPublisherOptions));
    }

    public B commandLatencyPublisherOptions(Optional<EventPublisherOptions> commandLatencyPublisherOptions) {
        this.commandLatencyPublisherOptions = commandLatencyPublisherOptions;
        return (B)this;
    }

    public B key(File key) {
        return this.key(Optional.of(key));
    }

    public B key(Optional<File> key) {
        this.key = key;
        return (B)this;
    }

    public B keyCert(File cert) {
        this.keyCert = cert;
        return (B)this;
    }

    public B keyPassword(char[] password) {
        this.keyPassword = password;
        return (B)this;
    }

    public B keystore(File keystore) {
        return this.keystore(Optional.of(keystore));
    }

    public B keystore(Optional<File> keystore) {
        this.keystore = keystore;
        return (B)this;
    }

    public B keystorePassword(char[] password) {
        this.keystorePassword = password;
        return (B)this;
    }

    public B truststore(File truststore) {
        return this.truststore(Optional.of(truststore));
    }

    public B truststore(Optional<File> truststore) {
        this.truststore = truststore;
        return (B)this;
    }

    public B truststorePassword(char[] password) {
        this.truststorePassword = password;
        return (B)this;
    }

    public B trustManager(File trustManager) {
        return this.trustManager(Optional.of(trustManager));
    }

    public B trustManager(Optional<File> trustManager) {
        this.trustManager = trustManager;
        return (B)this;
    }

    public ClientResources clientResources() {
        DefaultClientResources.Builder builder = DefaultClientResources.builder();
        this.commandLatencyRecorder.ifPresent(arg_0 -> ((DefaultClientResources.Builder)builder).commandLatencyRecorder(arg_0));
        this.commandLatencyPublisherOptions.ifPresent(arg_0 -> ((DefaultClientResources.Builder)builder).commandLatencyPublisherOptions(arg_0));
        return builder.build();
    }

    protected <C extends ClientOptions.Builder> C configure(C builder) {
        builder.autoReconnect(this.autoReconnect).decodeBufferPolicy(this.decodeBufferPolicy).disconnectedBehavior(this.disconnectedBehavior).publishOnScheduler(this.publishOnScheduler).sslOptions(this.sslOptions()).suspendReconnectOnProtocolFailure(this.suspendReconnectOnProtocolFailure).requestQueueSize(this.requestQueueSize).timeoutOptions(this.timeoutOptions);
        this.protocolVersion.ifPresent(arg_0 -> builder.protocolVersion(arg_0));
        this.socketOptions.ifPresent(arg_0 -> builder.socketOptions(arg_0));
        return builder;
    }

    public SslOptions sslOptions() {
        SslOptions.Builder ssl = SslOptions.builder();
        this.key.ifPresent(k -> ssl.keyManager(this.keyCert, k, this.keyPassword));
        this.keystore.ifPresent(s -> ssl.keystore(s, this.keystorePassword));
        this.truststore.ifPresent(s -> ssl.truststore(SslOptions.Resource.from((File)s), this.truststorePassword));
        this.trustManager.ifPresent(arg_0 -> ((SslOptions.Builder)ssl).trustManager(arg_0));
        return ssl.build();
    }

    protected RedisModulesClient client() {
        RedisModulesClient client = RedisModulesClient.create(this.clientResources(), this.redisURI);
        client.setOptions(this.configure(ClientOptions.builder()).build());
        return client;
    }

    public abstract AbstractRedisClient build();
}

