/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod;

import com.redis.lettucemod.api.StatefulRedisModulesConnection;
import com.redis.lettucemod.api.async.RedisModulesAsyncCommands;
import com.redis.lettucemod.bloom.BloomCommandBuilder;
import com.redis.lettucemod.bloom.BloomFilterInfo;
import com.redis.lettucemod.bloom.BloomFilterInfoType;
import com.redis.lettucemod.bloom.BloomFilterInsertOptions;
import com.redis.lettucemod.bloom.BloomFilterReserveOptions;
import com.redis.lettucemod.bloom.CmsInfo;
import com.redis.lettucemod.bloom.CuckooFilter;
import com.redis.lettucemod.bloom.CuckooFilterInsertOptions;
import com.redis.lettucemod.bloom.CuckooFilterReserveOptions;
import com.redis.lettucemod.bloom.LongScoredValue;
import com.redis.lettucemod.bloom.TDigestInfo;
import com.redis.lettucemod.bloom.TDigestMergeOptions;
import com.redis.lettucemod.bloom.TopKInfo;
import com.redis.lettucemod.gears.Execution;
import com.redis.lettucemod.gears.ExecutionDetails;
import com.redis.lettucemod.gears.ExecutionMode;
import com.redis.lettucemod.gears.GearsCommandBuilder;
import com.redis.lettucemod.gears.Registration;
import com.redis.lettucemod.json.ArrpopOptions;
import com.redis.lettucemod.json.GetOptions;
import com.redis.lettucemod.json.JSONCommandBuilder;
import com.redis.lettucemod.json.SetMode;
import com.redis.lettucemod.json.Slice;
import com.redis.lettucemod.output.ExecutionResults;
import com.redis.lettucemod.search.AggregateOptions;
import com.redis.lettucemod.search.AggregateResults;
import com.redis.lettucemod.search.AggregateWithCursorResults;
import com.redis.lettucemod.search.CursorOptions;
import com.redis.lettucemod.search.Field;
import com.redis.lettucemod.search.SearchCommandBuilder;
import com.redis.lettucemod.search.SearchOptions;
import com.redis.lettucemod.search.SearchResults;
import com.redis.lettucemod.search.Suggestion;
import com.redis.lettucemod.search.SuggetOptions;
import com.redis.lettucemod.timeseries.AddOptions;
import com.redis.lettucemod.timeseries.AlterOptions;
import com.redis.lettucemod.timeseries.CreateOptions;
import com.redis.lettucemod.timeseries.CreateRuleOptions;
import com.redis.lettucemod.timeseries.GetResult;
import com.redis.lettucemod.timeseries.IncrbyOptions;
import com.redis.lettucemod.timeseries.KeySample;
import com.redis.lettucemod.timeseries.MGetOptions;
import com.redis.lettucemod.timeseries.MRangeOptions;
import com.redis.lettucemod.timeseries.RangeOptions;
import com.redis.lettucemod.timeseries.RangeResult;
import com.redis.lettucemod.timeseries.Sample;
import com.redis.lettucemod.timeseries.TimeRange;
import com.redis.lettucemod.timeseries.TimeSeriesCommandBuilder;
import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisAsyncCommandsImpl;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.Value;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.KeyValueStreamingChannel;
import io.lettuce.core.protocol.RedisCommand;
import java.util.List;
import java.util.Map;

public class RedisModulesAsyncCommandsImpl<K, V>
extends RedisAsyncCommandsImpl<K, V>
implements RedisModulesAsyncCommands<K, V> {
    private final GearsCommandBuilder<K, V> gearsCommandBuilder;
    private final TimeSeriesCommandBuilder<K, V> timeSeriesCommandBuilder;
    private final SearchCommandBuilder<K, V> searchCommandBuilder;
    private final JSONCommandBuilder<K, V> jsonCommandBuilder;
    private final BloomCommandBuilder<K, V> bloomCommandBuilder;

    public RedisModulesAsyncCommandsImpl(StatefulRedisModulesConnection<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
        this.gearsCommandBuilder = new GearsCommandBuilder<K, V>(codec);
        this.timeSeriesCommandBuilder = new TimeSeriesCommandBuilder<K, V>(codec);
        this.searchCommandBuilder = new SearchCommandBuilder<K, V>(codec);
        this.jsonCommandBuilder = new JSONCommandBuilder<K, V>(codec);
        this.bloomCommandBuilder = new BloomCommandBuilder<K, V>(codec);
    }

    @Override
    public StatefulRedisModulesConnection<K, V> getStatefulConnection() {
        return (StatefulRedisModulesConnection)super.getStatefulConnection();
    }

    @Override
    public RedisFuture<String> rgAbortexecution(String id) {
        return this.dispatch((RedisCommand)this.gearsCommandBuilder.abortExecution(id));
    }

    @Override
    public RedisFuture<List<V>> rgConfigget(K ... keys) {
        return this.dispatch((RedisCommand)this.gearsCommandBuilder.configGet(keys));
    }

    @Override
    public RedisFuture<List<V>> rgConfigset(Map<K, V> map) {
        return this.dispatch((RedisCommand)this.gearsCommandBuilder.configSet(map));
    }

    @Override
    public RedisFuture<String> rgDropexecution(String id) {
        return this.dispatch((RedisCommand)this.gearsCommandBuilder.dropExecution(id));
    }

    @Override
    public RedisFuture<List<Execution>> rgDumpexecutions() {
        return this.dispatch((RedisCommand)this.gearsCommandBuilder.dumpExecutions());
    }

    @Override
    public RedisFuture<ExecutionResults> rgPyexecute(String function, V ... requirements) {
        return this.dispatch((RedisCommand)this.gearsCommandBuilder.pyExecute(function, requirements));
    }

    @Override
    public RedisFuture<String> rgPyexecuteUnblocking(String function, V ... requirements) {
        return this.dispatch((RedisCommand)this.gearsCommandBuilder.pyExecuteUnblocking(function, requirements));
    }

    @Override
    public RedisFuture<List<Object>> rgTrigger(String trigger, V ... args) {
        return this.dispatch((RedisCommand)this.gearsCommandBuilder.trigger(trigger, args));
    }

    @Override
    public RedisFuture<String> rgUnregister(String id) {
        return this.dispatch((RedisCommand)this.gearsCommandBuilder.unregister(id));
    }

    @Override
    public RedisFuture<List<Registration>> rgDumpregistrations() {
        return this.dispatch((RedisCommand)this.gearsCommandBuilder.dumpRegistrations());
    }

    @Override
    public RedisFuture<ExecutionDetails> rgGetexecution(String id) {
        return this.dispatch((RedisCommand)this.gearsCommandBuilder.getExecution(id));
    }

    @Override
    public RedisFuture<ExecutionDetails> rgGetexecution(String id, ExecutionMode mode) {
        return this.dispatch((RedisCommand)this.gearsCommandBuilder.getExecution(id, mode));
    }

    @Override
    public RedisFuture<ExecutionResults> rgGetresults(String id) {
        return this.dispatch((RedisCommand)this.gearsCommandBuilder.getResults(id));
    }

    @Override
    public RedisFuture<ExecutionResults> rgGetresultsblocking(String id) {
        return this.dispatch((RedisCommand)this.gearsCommandBuilder.getResultsBlocking(id));
    }

    @Override
    public RedisFuture<String> tsCreate(K key, CreateOptions<K, V> options) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.create(key, options));
    }

    @Override
    public RedisFuture<String> tsAlter(K key, AlterOptions<K, V> options) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.alter(key, options));
    }

    @Override
    public RedisFuture<Long> tsAdd(K key, Sample sample) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.add(key, sample));
    }

    @Override
    public RedisFuture<Long> tsAdd(K key, Sample sample, AddOptions<K, V> options) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.add(key, sample, options));
    }

    @Override
    public RedisFuture<Long> tsDecrby(K key, double value) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.decrby(key, value, null));
    }

    @Override
    public RedisFuture<Long> tsDecrby(K key, double value, IncrbyOptions<K, V> options) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.decrby(key, value, options));
    }

    @Override
    public RedisFuture<Long> tsIncrby(K key, double value) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.incrby(key, value, null));
    }

    @Override
    public RedisFuture<Long> tsIncrby(K key, double value, IncrbyOptions<K, V> options) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.incrby(key, value, options));
    }

    @Override
    public RedisFuture<List<Long>> tsMadd(KeySample<K> ... samples) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.madd(samples));
    }

    @Override
    public RedisFuture<String> tsCreaterule(K sourceKey, K destKey, CreateRuleOptions options) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.createRule(sourceKey, destKey, options));
    }

    @Override
    public RedisFuture<String> tsDeleterule(K sourceKey, K destKey) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.deleteRule(sourceKey, destKey));
    }

    @Override
    public RedisFuture<List<Sample>> tsRange(K key, TimeRange range) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.range(key, range));
    }

    @Override
    public RedisFuture<List<Sample>> tsRange(K key, TimeRange range, RangeOptions options) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.range(key, range, options));
    }

    @Override
    public RedisFuture<List<Sample>> tsRevrange(K key, TimeRange range) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.revrange(key, range));
    }

    @Override
    public RedisFuture<List<Sample>> tsRevrange(K key, TimeRange range, RangeOptions options) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.revrange(key, range, options));
    }

    @Override
    public RedisFuture<List<RangeResult<K, V>>> tsMrange(TimeRange range) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.mrange(range));
    }

    @Override
    public RedisFuture<List<RangeResult<K, V>>> tsMrange(TimeRange range, MRangeOptions<K, V> options) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.mrange(range, options));
    }

    @Override
    public RedisFuture<List<RangeResult<K, V>>> tsMrevrange(TimeRange range) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.mrevrange(range));
    }

    @Override
    public RedisFuture<List<RangeResult<K, V>>> tsMrevrange(TimeRange range, MRangeOptions<K, V> options) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.mrevrange(range, options));
    }

    @Override
    public RedisFuture<Sample> tsGet(K key) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.get(key));
    }

    @Override
    public RedisFuture<List<GetResult<K, V>>> tsMget(MGetOptions<K, V> options) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.mget(options));
    }

    @Override
    public RedisFuture<List<GetResult<K, V>>> tsMget(V ... filters) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.mget(filters));
    }

    @Override
    public RedisFuture<List<GetResult<K, V>>> tsMgetWithLabels(V ... filters) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.mgetWithLabels(filters));
    }

    @Override
    public RedisFuture<List<Object>> tsInfo(K key) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.info(key, false));
    }

    @Override
    public RedisFuture<List<Object>> tsInfoDebug(K key) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.info(key, true));
    }

    @Override
    public RedisFuture<List<V>> tsQueryIndex(V ... filters) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.queryIndex(filters));
    }

    @Override
    public RedisFuture<Long> tsDel(K key, TimeRange timeRange) {
        return this.dispatch((RedisCommand)this.timeSeriesCommandBuilder.tsDel(key, timeRange));
    }

    @Override
    public RedisFuture<String> ftCreate(K index, Field<K> ... fields) {
        return this.ftCreate(index, (com.redis.lettucemod.search.CreateOptions<K, V>)null, fields);
    }

    @Override
    public RedisFuture<String> ftCreate(K index, com.redis.lettucemod.search.CreateOptions<K, V> options, Field<K> ... fields) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.create(index, options, fields));
    }

    @Override
    public RedisFuture<String> ftDropindex(K index) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.dropIndex(index, false));
    }

    @Override
    public RedisFuture<String> ftDropindexDeleteDocs(K index) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.dropIndex(index, true));
    }

    @Override
    public RedisFuture<List<Object>> ftInfo(K index) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.info(index));
    }

    @Override
    public RedisFuture<SearchResults<K, V>> ftSearch(K index, V query) {
        return this.ftSearch(index, query, null);
    }

    @Override
    public RedisFuture<SearchResults<K, V>> ftSearch(K index, V query, SearchOptions<K, V> options) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.search(index, query, options));
    }

    @Override
    public RedisFuture<AggregateResults<K>> ftAggregate(K index, V query) {
        return this.ftAggregate(index, query, (AggregateOptions)null);
    }

    @Override
    public RedisFuture<AggregateResults<K>> ftAggregate(K index, V query, AggregateOptions<K, V> options) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.aggregate(index, query, options));
    }

    @Override
    public RedisFuture<AggregateWithCursorResults<K>> ftAggregate(K index, V query, CursorOptions cursor) {
        return this.ftAggregate(index, query, cursor, null);
    }

    @Override
    public RedisFuture<AggregateWithCursorResults<K>> ftAggregate(K index, V query, CursorOptions cursor, AggregateOptions<K, V> options) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.aggregate(index, query, cursor, options));
    }

    @Override
    public RedisFuture<AggregateWithCursorResults<K>> ftCursorRead(K index, long cursor) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.cursorRead(index, cursor, null));
    }

    @Override
    public RedisFuture<AggregateWithCursorResults<K>> ftCursorRead(K index, long cursor, long count) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.cursorRead(index, cursor, count));
    }

    @Override
    public RedisFuture<String> ftCursorDelete(K index, long cursor) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.cursorDelete(index, cursor));
    }

    @Override
    public RedisFuture<Long> ftSugadd(K key, Suggestion<V> suggestion) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.sugadd(key, suggestion));
    }

    @Override
    public RedisFuture<Long> ftSugaddIncr(K key, Suggestion<V> suggestion) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.sugaddIncr(key, suggestion));
    }

    @Override
    public RedisFuture<List<Suggestion<V>>> ftSugget(K key, V prefix) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.sugget(key, prefix));
    }

    @Override
    public RedisFuture<List<Suggestion<V>>> ftSugget(K key, V prefix, SuggetOptions options) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.sugget(key, prefix, options));
    }

    @Override
    public RedisFuture<Boolean> ftSugdel(K key, V string) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.sugdel(key, string));
    }

    @Override
    public RedisFuture<Long> ftSuglen(K key) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.suglen(key));
    }

    @Override
    public RedisFuture<String> ftAlter(K index, Field<K> field) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.alter(index, field));
    }

    @Override
    public RedisFuture<String> ftAliasadd(K name, K index) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.aliasAdd(name, index));
    }

    @Override
    public RedisFuture<String> ftAliasdel(K name) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.aliasDel(name));
    }

    @Override
    public RedisFuture<String> ftAliasupdate(K name, K index) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.aliasUpdate(name, index));
    }

    @Override
    public RedisFuture<List<K>> ftList() {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.list());
    }

    @Override
    public RedisFuture<List<V>> ftTagvals(K index, K field) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.tagVals(index, field));
    }

    @Override
    public RedisFuture<Long> ftDictadd(K dict, V ... terms) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.dictadd(dict, terms));
    }

    @Override
    public RedisFuture<Long> ftDictdel(K dict, V ... terms) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.dictdel(dict, terms));
    }

    @Override
    public RedisFuture<List<V>> ftDictdump(K dict) {
        return this.dispatch((RedisCommand)this.searchCommandBuilder.dictdump(dict));
    }

    @Override
    public RedisFuture<Long> jsonDel(K key) {
        return this.jsonDel(key, null);
    }

    @Override
    public RedisFuture<Long> jsonDel(K key, String path) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.del(key, path));
    }

    @Override
    public RedisFuture<V> jsonGet(K key, K ... paths) {
        return this.jsonGet(key, null, paths);
    }

    @Override
    public RedisFuture<V> jsonGet(K key, GetOptions options, K ... paths) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.get(key, options, paths));
    }

    @Override
    public RedisFuture<List<KeyValue<K, V>>> jsonMget(String path, K ... keys) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.mgetKeyValue(path, keys));
    }

    public RedisFuture<List<KeyValue<K, V>>> jsonMget(String path, Iterable<K> keys) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.mgetKeyValue(path, keys));
    }

    @Override
    public RedisFuture<Long> jsonMget(KeyValueStreamingChannel<K, V> channel, String path, K ... keys) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.mget(channel, path, keys));
    }

    public RedisFuture<Long> jsonMget(KeyValueStreamingChannel<K, V> channel, String path, Iterable<K> keys) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.mget(channel, path, keys));
    }

    @Override
    public RedisFuture<String> jsonSet(K key, String path, V json) {
        return this.jsonSet(key, path, json, null);
    }

    @Override
    public RedisFuture<String> jsonSet(K key, String path, V json, SetMode options) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.set(key, path, json, options));
    }

    @Override
    public RedisFuture<String> jsonMerge(K key, String path, V json) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.merge(key, path, json));
    }

    @Override
    public RedisFuture<String> jsonType(K key) {
        return this.jsonType(key, null);
    }

    @Override
    public RedisFuture<String> jsonType(K key, String path) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.type(key, path));
    }

    @Override
    public RedisFuture<V> jsonNumincrby(K key, String path, double number) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.numIncrBy(key, path, number));
    }

    @Override
    public RedisFuture<V> jsonNummultby(K key, String path, double number) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.numMultBy(key, path, number));
    }

    @Override
    public RedisFuture<Long> jsonStrappend(K key, V json) {
        return this.jsonStrappend(key, null, json);
    }

    @Override
    public RedisFuture<Long> jsonStrappend(K key, String path, V json) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.strAppend(key, path, json));
    }

    @Override
    public RedisFuture<Long> jsonStrlen(K key, String path) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.strLen(key, path));
    }

    @Override
    public RedisFuture<Long> jsonArrappend(K key, String path, V ... jsons) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.arrAppend(key, path, jsons));
    }

    @Override
    public RedisFuture<Long> jsonArrindex(K key, String path, V scalar) {
        return this.jsonArrindex(key, path, scalar, null);
    }

    @Override
    public RedisFuture<Long> jsonArrindex(K key, String path, V scalar, Slice slice) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.arrIndex(key, path, scalar, slice));
    }

    @Override
    public RedisFuture<Long> jsonArrinsert(K key, String path, long index, V ... jsons) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.arrInsert(key, path, index, jsons));
    }

    @Override
    public RedisFuture<Long> jsonArrlen(K key) {
        return this.jsonArrlen(key, null);
    }

    @Override
    public RedisFuture<Long> jsonArrlen(K key, String path) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.arrLen(key, path));
    }

    @Override
    public RedisFuture<V> jsonArrpop(K key) {
        return this.jsonArrpop(key, null);
    }

    @Override
    public RedisFuture<V> jsonArrpop(K key, ArrpopOptions<K> options) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.arrPop(key, options));
    }

    @Override
    public RedisFuture<Long> jsonArrtrim(K key, String path, long start, long stop) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.arrTrim(key, path, start, stop));
    }

    @Override
    public RedisFuture<List<K>> jsonObjkeys(K key) {
        return this.jsonObjkeys(key, null);
    }

    @Override
    public RedisFuture<List<K>> jsonObjkeys(K key, String path) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.objKeys(key, path));
    }

    @Override
    public RedisFuture<Long> jsonObjlen(K key) {
        return this.jsonObjlen(key, null);
    }

    @Override
    public RedisFuture<Long> jsonObjlen(K key, String path) {
        return this.dispatch((RedisCommand)this.jsonCommandBuilder.objLen(key, path));
    }

    @Override
    public RedisFuture<Boolean> bfAdd(K key, V item) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.bfAdd(key, item));
    }

    @Override
    public RedisFuture<Long> bfCard(K key) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.bfCard(key));
    }

    @Override
    public RedisFuture<Boolean> bfExists(K key, V item) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.bfExists(key, item));
    }

    @Override
    public RedisFuture<BloomFilterInfo> bfInfo(K key) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.bfInfo(key));
    }

    @Override
    public RedisFuture<Long> bfInfo(K key, BloomFilterInfoType type) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.bfInfo(key, type));
    }

    @Override
    public RedisFuture<List<Boolean>> bfInsert(K key, V ... items) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.bfInsert(key, items));
    }

    @Override
    public RedisFuture<List<Boolean>> bfInsert(K key, BloomFilterInsertOptions options, V ... items) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.bfInsert(key, options, items));
    }

    @Override
    public RedisFuture<List<Boolean>> bfMAdd(K key, V ... items) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.bfMAdd(key, items));
    }

    @Override
    public RedisFuture<List<Boolean>> bfMExists(K key, V ... items) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.bfMExists(key, items));
    }

    @Override
    public RedisFuture<String> bfReserve(K key, double errorRate, long capacity) {
        return this.bfReserve(key, errorRate, capacity, null);
    }

    @Override
    public RedisFuture<String> bfReserve(K key, double errorRate, long capacity, BloomFilterReserveOptions options) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.bfReserve(key, errorRate, capacity, options));
    }

    @Override
    public RedisFuture<Boolean> cfAdd(K key, V item) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cfAdd(key, item));
    }

    @Override
    public RedisFuture<Boolean> cfAddNx(K key, V item) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cfAddNx(key, item));
    }

    @Override
    public RedisFuture<Long> cfCount(K key, V item) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cfCount(key, item));
    }

    @Override
    public RedisFuture<Boolean> cfDel(K key, V item) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cfDel(key, item));
    }

    @Override
    public RedisFuture<Boolean> cfExists(K key, V item) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cfExists(key, item));
    }

    @Override
    public RedisFuture<CuckooFilter> cfInfo(K key) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cfInfo(key));
    }

    @Override
    public RedisFuture<List<Long>> cfInsert(K key, V ... items) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cfInsert(key, items));
    }

    @Override
    public RedisFuture<List<Long>> cfInsert(K key, CuckooFilterInsertOptions options, V ... items) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cfInsert(key, items, options));
    }

    @Override
    public RedisFuture<List<Long>> cfInsertNx(K key, V ... items) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cfInsertNx(key, items));
    }

    @Override
    public RedisFuture<List<Long>> cfInsertNx(K key, CuckooFilterInsertOptions options, V ... items) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cfInsertNx(key, items, options));
    }

    @Override
    public RedisFuture<List<Boolean>> cfMExists(K key, V ... items) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cfMExists(key, items));
    }

    @Override
    public RedisFuture<String> cfReserve(K key, long capacity) {
        return this.cfReserve(key, capacity, null);
    }

    @Override
    public RedisFuture<String> cfReserve(K key, long capacity, CuckooFilterReserveOptions options) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cfReserve(key, capacity, options));
    }

    @Override
    public RedisFuture<Long> cmsIncrBy(K key, V item, long increment) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cmsIncrBy(key, item, increment));
    }

    @Override
    public RedisFuture<List<Long>> cmsIncrBy(K key, LongScoredValue<V> ... itemIncrements) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cmsIncrBy(key, itemIncrements));
    }

    @Override
    public RedisFuture<String> cmsInitByProb(K key, double error, double probability) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cmsInitByProb(key, error, probability));
    }

    @Override
    public RedisFuture<String> cmsInitByDim(K key, long width, long depth) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cmsInitByDim(key, width, depth));
    }

    @Override
    public RedisFuture<List<Long>> cmsQuery(K key, V ... items) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cmsQuery(key, items));
    }

    @Override
    public RedisFuture<String> cmsMerge(K destKey, K ... keys) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cmsMerge(destKey, keys));
    }

    @Override
    public RedisFuture<String> cmsMerge(K destKey, LongScoredValue<K> ... sourceKeyWeights) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cmsMerge(destKey, sourceKeyWeights));
    }

    @Override
    public RedisFuture<CmsInfo> cmsInfo(K key) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.cmsInfo(key));
    }

    @Override
    public RedisFuture<List<Value<V>>> topKAdd(K key, V ... items) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.topKAdd(key, items));
    }

    @Override
    public RedisFuture<List<Value<V>>> topKIncrBy(K key, LongScoredValue<V> ... itemIncrements) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.topKIncrBy(key, itemIncrements));
    }

    @Override
    public RedisFuture<TopKInfo> topKInfo(K key) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.topKInfo(key));
    }

    @Override
    public RedisFuture<List<String>> topKList(K key) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.topKList(key));
    }

    @Override
    public RedisFuture<List<KeyValue<String, Long>>> topKListWithScores(K key) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.topKListWithScores(key));
    }

    @Override
    public RedisFuture<List<Boolean>> topKQuery(K key, V ... items) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.topKQuery(key, items));
    }

    @Override
    public RedisFuture<String> topKReserve(K key, long k) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.topKReserve(key, k));
    }

    @Override
    public RedisFuture<String> topKReserve(K key, long k, long width, long depth, double decay) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.topKReserve(key, k, width, depth, decay));
    }

    @Override
    public RedisFuture<String> tDigestAdd(K key, double ... values) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.tDigestAdd(key, values));
    }

    @Override
    public RedisFuture<List<Double>> tDigestByRank(K key, long ... ranks) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.tDigestByRank(key, ranks));
    }

    @Override
    public RedisFuture<List<Double>> tDigestByRevRank(K key, long ... revRanks) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.tDigestByRevRank(key, revRanks));
    }

    @Override
    public RedisFuture<List<Double>> tDigestCdf(K key, double ... values) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.tDigestCdf(key, values));
    }

    @Override
    public RedisFuture<String> tDigestCreate(K key) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.tDigestCreate(key));
    }

    @Override
    public RedisFuture<String> tDigestCreate(K key, long compression) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.tDigestCreate(key, compression));
    }

    @Override
    public RedisFuture<TDigestInfo> tDigestInfo(K key) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.tDigestInfo(key));
    }

    @Override
    public RedisFuture<Double> tDigestMax(K key) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.tDigestMax(key));
    }

    @Override
    public RedisFuture<String> tDigestMerge(K destinationKey, K ... sourceKeys) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.tDigestMerge(destinationKey, sourceKeys));
    }

    @Override
    public RedisFuture<String> tDigestMerge(K destinationKey, TDigestMergeOptions options, K ... sourceKeys) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.tDigestMerge(destinationKey, options, sourceKeys));
    }

    @Override
    public RedisFuture<Double> tDigestMin(K key) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.tDigestMin(key));
    }

    @Override
    public RedisFuture<List<Double>> tDigestQuantile(K key, double ... quantiles) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.tDigestQuantile(key, quantiles));
    }

    @Override
    public RedisFuture<List<Long>> tDigestRank(K key, double ... values) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.tDigestRank(key, values));
    }

    @Override
    public RedisFuture<String> tDigestReset(K key) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.tDigestReset(key));
    }

    @Override
    public RedisFuture<List<Long>> tDigestRevRank(K key, double ... values) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.tDigestRevRank(key, values));
    }

    @Override
    public RedisFuture<Double> tDigestTrimmedMean(K key, double lowCutQuantile, double highCutQuantile) {
        return this.dispatch((RedisCommand)this.bloomCommandBuilder.tDigestTrimmedMean(key, lowCutQuantile, highCutQuantile));
    }
}

