/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod;

import com.redis.lettucemod.RedisModulesClientBuilder;
import com.redis.lettucemod.RedisURIBuilder;
import com.redis.lettucemod.StatefulRedisModulesConnectionImpl;
import com.redis.lettucemod.api.StatefulRedisModulesConnection;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.ProtocolVersion;
import io.lettuce.core.protocol.PushHandler;
import io.lettuce.core.resource.ClientResources;
import java.time.Duration;

public class RedisModulesClient
extends RedisClient {
    public static final ProtocolVersion DEFAULT_PROTOCOL_VERSION = ProtocolVersion.RESP2;
    public static final ClientOptions DEFAULT_CLIENT_OPTIONS = RedisModulesClient.defaultClientOptions(ClientOptions.builder()).build();

    protected RedisModulesClient(ClientResources clientResources, RedisURI redisURI) {
        super(clientResources, redisURI);
        this.setOptions(DEFAULT_CLIENT_OPTIONS);
    }

    public static <B extends ClientOptions.Builder> B defaultClientOptions(B builder) {
        builder.protocolVersion(DEFAULT_PROTOCOL_VERSION);
        return builder;
    }

    protected RedisModulesClient() {
        this.setOptions(DEFAULT_CLIENT_OPTIONS);
    }

    public static RedisModulesClient create() {
        return new RedisModulesClient();
    }

    public static RedisModulesClient create(RedisURI redisURI) {
        RedisModulesClient.assertNotNull(redisURI);
        return new RedisModulesClient(null, redisURI);
    }

    public static RedisModulesClient create(String uri) {
        LettuceAssert.notEmpty((CharSequence)uri, (String)"URI must not be empty");
        return new RedisModulesClient(null, RedisURI.create((String)uri));
    }

    public static RedisModulesClient create(ClientResources clientResources) {
        RedisModulesClient.assertNotNull(clientResources);
        return new RedisModulesClient(clientResources, new RedisURI());
    }

    public static RedisModulesClient create(ClientResources clientResources, String uri) {
        RedisModulesClient.assertNotNull(clientResources);
        LettuceAssert.notEmpty((CharSequence)uri, (String)"URI must not be empty");
        return RedisModulesClient.create(clientResources, RedisURI.create((String)uri));
    }

    private static void assertNotNull(ClientResources clientResources) {
        LettuceAssert.notNull((Object)clientResources, (String)"ClientResources must not be null");
    }

    public static RedisModulesClient create(ClientResources clientResources, RedisURI redisURI) {
        RedisModulesClient.assertNotNull(clientResources);
        RedisModulesClient.assertNotNull(redisURI);
        return new RedisModulesClient(clientResources, redisURI);
    }

    public static RedisModulesClientBuilder builder() {
        return new RedisModulesClientBuilder();
    }

    public static RedisURIBuilder uriBuilder() {
        return new RedisURIBuilder();
    }

    public StatefulRedisModulesConnection<String, String> connect() {
        return this.connect(this.newStringStringCodec());
    }

    public <K, V> StatefulRedisModulesConnection<K, V> connect(RedisCodec<K, V> codec) {
        return (StatefulRedisModulesConnection)super.connect(codec);
    }

    public StatefulRedisModulesConnection<String, String> connect(RedisURI redisURI) {
        return (StatefulRedisModulesConnection)super.connect(redisURI);
    }

    public <K, V> StatefulRedisModulesConnection<K, V> connect(RedisCodec<K, V> codec, RedisURI redisURI) {
        return (StatefulRedisModulesConnection)super.connect(codec, redisURI);
    }

    private static void assertNotNull(RedisURI redisURI) {
        LettuceAssert.notNull((Object)redisURI, (String)"RedisURI must not be null");
    }

    protected <K, V> StatefulRedisModulesConnectionImpl<K, V> newStatefulRedisConnection(RedisChannelWriter channelWriter, PushHandler pushHandler, RedisCodec<K, V> codec, Duration timeout) {
        return new StatefulRedisModulesConnectionImpl<K, V>(channelWriter, pushHandler, codec, timeout);
    }
}

