/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod;

import com.redis.lettucemod.RedisModulesClient;
import com.redis.lettucemod.cluster.RedisModulesClusterClient;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.internal.LettuceAssert;

public class RedisModulesClientBuilder {
    private RedisURI uri = RedisURI.create((String)"127.0.0.1", (int)6379);
    private boolean cluster;
    private ClientOptions clientOptions;

    public AbstractRedisClient build() {
        if (this.cluster) {
            RedisModulesClusterClient client = RedisModulesClusterClient.create(this.uri);
            if (this.clientOptions != null) {
                client.setOptions(this.clusterClientOptions());
            }
            return client;
        }
        RedisModulesClient client = RedisModulesClient.create(this.uri);
        if (this.clientOptions != null) {
            client.setOptions(this.clientOptions);
        }
        return client;
    }

    private ClusterClientOptions clusterClientOptions() {
        LettuceAssert.isTrue((boolean)(this.clientOptions instanceof ClusterClientOptions), (String)"Client options must be an instance of ClusterClientOptions");
        return (ClusterClientOptions)this.clientOptions;
    }

    public RedisModulesClientBuilder uri(RedisURI uri) {
        this.uri = uri;
        return this;
    }

    public RedisModulesClientBuilder cluster(boolean cluster) {
        this.cluster = cluster;
        return this;
    }

    public RedisModulesClientBuilder clientOptions(ClientOptions options) {
        this.clientOptions = options;
        return this;
    }
}

